
document.addEventListener('contextmenu', (event) => {
    event.preventDefault();
  });

const redTimer = document.getElementById('red-timer');
const blueTimer = document.getElementById('blue-timer');
const redStartBtn = document.getElementById('red-start');
const redPauseBtn = document.getElementById('red-pause');
const redResetBtn = document.getElementById('red-reset');
const blueStartBtn = document.getElementById('blue-start');
const bluePauseBtn = document.getElementById('blue-pause');
const blueResetBtn = document.getElementById('blue-reset');
const bothStartBtn = document.getElementById('both-start');
const bothPauseBtn = document.getElementById('both-pause');
const resetAllBtn = document.getElementById('reset-all');
const redResumeBtn = document.getElementById('red-resume');
const blueResumeBtn = document.getElementById('blue-resume');
const resumeBothBtn = document.getElementById('resume-both');
const beep = document.getElementById('beep');

// redResumeBtn.disabled = true;
redResumeBtn.classList.add("hidden");
// redPauseBtn.disabled = true;
redPauseBtn.classList.add("hidden");
// redResetBtn.disabled = true;
redResetBtn.classList.add("hidden");

// blueResumeBtn.disabled = true;
blueResumeBtn.classList.add("hidden");
// bluePauseBtn.disabled = true;
bluePauseBtn.classList.add("hidden");
// blueResetBtn.disabled = true;
blueResetBtn.classList.add("hidden");


// resumeBothBtn.disabled = true;
resumeBothBtn.classList.add("hidden");
// resetAllBtn.disabled = true;
resetAllBtn.classList.add("hidden");
// bothPauseBtn.disabled = true;
bothPauseBtn.classList.add("hidden");



let redIntervalId;
let blueIntervalId;

function startTimer(timer, startBtn, pauseBtn, resumeBtn, intervalId) {
  let timeLeft = 15;
  timer.textContent = timeLeft;

  clearInterval(intervalId);

  intervalId = setInterval(() => {
    timeLeft--;
    timer.textContent = timeLeft;

    if (timeLeft === 0) {
      clearInterval(intervalId);
      // startBtn.disabled = false;
      startBtn.classList.remove("hidden");
      // pauseBtn.disabled = true;
      pauseBtn.classList.add("hidden");
      // resumeBtn.disabled = true;
      resumeBtn.classList.add("hidden");
      // bothStartBtn.disabled = false;
      bothStartBtn.classList.remove("hidden");
      // bothPauseBtn.disabled = true;
      bothPauseBtn.classList.add("hidden");
      // resumeBothBtn.disabled = true;
      resumeBothBtn.classList.add("hidden");
      beep.play();
    }
  }, 1000);

  // startBtn.disabled = true;
  startBtn.classList.add("hidden");
  // pauseBtn.disabled = false;
  pauseBtn.classList.remove("hidden");
  // resumeBtn.disabled = true;
  resumeBtn.classList.add("hidden");
  return intervalId;
}

function restartTimer(timer, startBtn, pauseBtn, resumeBtn, intervalId) {
  let timeLeft = timer.textContent;

  clearInterval(intervalId);

  intervalId = setInterval(() => {
    timeLeft--;
    timer.textContent = timeLeft;

    if (timeLeft === 0) {
      clearInterval(intervalId);
      // startBtn.disabled = false;
      startBtn.classList.remove("hidden");
      // pauseBtn.disabled = true;
      pauseBtn.classList.add("hidden");
      // resumeBtn.disabled = true;
      resumeBtn.classList.add("hidden");
      // bothStartBtn.disabled = false;
      bothStartBtn.classList.remove("hidden");
      // bothPauseBtn.disabled = true;
      bothPauseBtn.classList.add("hidden");
      // resumeBothBtn.disabled = true;
      resumeBothBtn.classList.add("hidden");
      beep.play();
    }
  }, 1000);

  // startBtn.disabled = true;
  startBtn.classList.add("hidden");
  // pauseBtn.disabled = false;
  pauseBtn.classList.remove("hidden");
  // resumeBtn.disabled = true;
  resumeBtn.classList.add("hidden");
  return intervalId;
}


function pauseTimer(intervalId) {
  clearInterval(intervalId);
}

function resetTimer(timer, startBtn, pauseBtn, resumeBtn, intervalId) {
  clearInterval(intervalId);
  timer.textContent = 15;
  // startBtn.disabled = false;
  startBtn.classList.remove("hidden");
  // pauseBtn.disabled = true;
  pauseBtn.classList.add("hidden");
  // resumeBtn.disabled = true;
  resumeBtn.classList.add("hidden");
}


redStartBtn.addEventListener('click', () => {
  redIntervalId = startTimer(redTimer, redStartBtn, redPauseBtn, redResumeBtn, redIntervalId);
});

redPauseBtn.addEventListener('click', () => {
  pauseTimer(redIntervalId);
  // redPauseBtn.disabled = true;
  redPauseBtn.classList.add("hidden");
  // redStartBtn.disabled = true;
  redStartBtn.classList.add("hidden");
  // redResetBtn.disabled = false;
  redResetBtn.classList.remove("hidden");
  // redResumeBtn.disabled = false;
  redResumeBtn.classList.remove("hidden");

});

redResetBtn.addEventListener('click', () => {
  redIntervalId = resetTimer(redTimer, redStartBtn, redPauseBtn, redResumeBtn, redIntervalId);
  // redResetBtn.disabled =true;
  redResetBtn.classList.add("hidden");
});

redResumeBtn.addEventListener('click', () => {
  redIntervalId = restartTimer(redTimer, redStartBtn, redPauseBtn, redResumeBtn, redIntervalId);
});

blueStartBtn.addEventListener('click', () => {
  blueIntervalId = startTimer(blueTimer, blueStartBtn, bluePauseBtn, blueResumeBtn, blueIntervalId);
});

bluePauseBtn.addEventListener('click', () => {
  pauseTimer(blueIntervalId);
  // bluePauseBtn.disabled = true;
  bluePauseBtn.classList.add("hidden");
  // blueStartBtn.disabled = true;
  blueStartBtn.classList.add("hidden");
  // blueResetBtn.disabled = false;
  blueResetBtn.classList.remove("hidden");
  // blueResumeBtn.disabled = false;
  blueResumeBtn.classList.remove("hidden");
});

blueResetBtn.addEventListener('click', () => {
  blueIntervalId = resetTimer(blueTimer, blueStartBtn, bluePauseBtn, blueResumeBtn,blueIntervalId);
  // blueResetBtn.disabled =true;
  blueResetBtn.classList.add("hidden");

});

blueResumeBtn.addEventListener('click', () => {
  blueIntervalId = restartTimer(blueTimer, blueStartBtn, bluePauseBtn, blueResumeBtn, blueIntervalId);
});

bothStartBtn.addEventListener('click', () => {
  redIntervalId = startTimer(redTimer, redStartBtn, redPauseBtn, redResumeBtn, redIntervalId);
  blueIntervalId = startTimer(blueTimer, blueStartBtn, bluePauseBtn, blueResumeBtn, blueIntervalId);
  // bothStartBtn.disabled = true;
  bothStartBtn.classList.add("hidden");
  // bothPauseBtn.disabled = false;
  bothPauseBtn.classList.remove("hidden");
  // resetAllBtn.disabled = true;
  resetAllBtn.classList.add("hidden");
  // resumeBothBtn.disabled = true;
  resumeBothBtn.classList.add("hidden");

});

bothPauseBtn.addEventListener('click', () => {
  pauseTimer(redIntervalId);
  pauseTimer(blueIntervalId);
  // redPauseBtn.disabled = true;
  redPauseBtn.classList.add("hidden");
  // bluePauseBtn.disabled = true;
  bluePauseBtn.classList.add("hidden");
  // bothStartBtn.disabled = true;
  bothStartBtn.classList.add("hidden");
  // bothPauseBtn.disabled = true;
  bothPauseBtn.classList.add("hidden");
  // resetAllBtn.disabled = false;
  resetAllBtn.classList.remove("hidden");
  // resumeBothBtn.disabled = false;
  resumeBothBtn.classList.remove("hidden");

});

resetAllBtn.addEventListener('click', () => {
  redIntervalId  = resetTimer(redTimer, redStartBtn, redPauseBtn, redResumeBtn, redIntervalId);
  blueIntervalId = resetTimer(blueTimer, blueStartBtn, bluePauseBtn, blueResumeBtn, blueIntervalId);
  // resetAllBtn.disabled = true;
  resetAllBtn.classList.add("hidden");
  // bothStartBtn.disabled = false;
  bothStartBtn.classList.remove("hidden");
  // bothPauseBtn.disabled = true;
  bothPauseBtn.classList.add("hidden");
  // resumeBothBtn.disabled = true;
  resumeBothBtn.classList.add("hidden");
});

resumeBothBtn.addEventListener('click', () => {
  redIntervalId  = restartTimer(redTimer, redStartBtn, redPauseBtn,redResumeBtn, redIntervalId);
  blueIntervalId  = restartTimer(blueTimer, blueStartBtn, bluePauseBtn, blueResumeBtn, blueIntervalId);
  // resumeBothBtn.disabled = true;
  resumeBothBtn.classList.add("hidden");
  // bothStartBtn.disabled = true;
  bothStartBtn.classList.add("hidden");
  // bothPauseBtn.disabled = false;
  bothPauseBtn.classList.remove("hidden");
  // resetAllBtn.disabled = false;
  resetAllBtn.classList.remove("hidden");
});