<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use App\Customer;
use App\Course;
use App\StudentCourse;
use App\TeacherTime;
use App\Lesson;
use App\Setting;
use App\Message;
use Mail;
use DateTime;

class ApiController extends Controller {

 public function index(Request $request) {

  return 'in progress';
 } 
 

 public function getSearch (Request $request){
  return "in testing";
 }

  public function joinCourse(Request $request){
         $join = StudentCourse::where('courseId', $request->courseId)->where('studentId', $request->studentId)->first();
               if($join){
            return response()->json([
                  'status' => ['type' => 'fail', 'code' => 0],
                 'error' => 'ﺗﻢ اﻻﺷﺘﺮاﻙ ﺳﺎﺑﻘﺎ'
               ]);
    }else{
           $join = new  StudentCourse();
           $join->courseId=$request->courseId;
           $join->studentId=$request->studentId;
           $join->save();
           
           
            $users = \App\User::all();
                $registrationIds =  array();
                foreach(  $users as $user){
                   $registrationIds[] = $user->ftoken;
              }
            $this->pushNotification('تنبية هام','تم استلام طلب للانضمام الى دورة برجاء الدخول',$registrationIds);

          return response()->json([
                           'status' => ['type' => 'success', 'code' => 1],
                           'message' => 'تم تقديم طلبكم وسيتم إضافتكم إلى المجموعة في أقرب وقت إن شاء الله'
                       ]);
    }

  }

   public function acceptCourse(Request $request){
         $accept = Course::where('Id', $request->courseId)->where('teacherId','<>', 0)->first();
               if($accept){
            return response()->json([
                  'status' => ['type' => 'fail', 'code' => 0],
                 'error' => 'لقد تم قبول الدورة من قبل مدرس اخر'
               ]);
    }else{
           $accept = Course::find($request->courseId);
           $accept->teacherId=$request->teacherId;
           $accept->save();
           
            $users = \App\User::all();
                $registrationIds =  array();
                foreach(  $users as $user){
                   $registrationIds[] = $user->ftoken;
              }

            $teacher = Customer::find($request->teacherId);
            
            $this->pushNotification('تنبية هام',$teacher->name.'لقد تم قبول الدورة من قبل ',$registrationIds);           
         
          return response()->json([
                           'status' => ['type' => 'success', 'code' => 1],
                           'message' => 'ﺗﻢ ﻗﺒﻮﻝ اﻟﺪﻭﺭﺓ ﺑﻨﺠﺎﺡ'
                       ]);
    }

  }
 
 public function getCourses(Request $request){

    if($request->type){
       return Course::where('teacherId',0)->where('type','<>',3)->where('type',$request->type)->get();
    }else{
         return Course::where('teacherId','<>',0)->where('type','<>',3)->where('type','<>',2)->get();
    }
 }

 public function getStudentCourses(Request $request){
       return StudentCourse::with('info')->where('studentId',$request->sid)->where('active',1)->get();
   
 }
 
 public function deleteStudentCourse(Request $request){
       $course = StudentCourse::where('id',$request->acceptId)->where('studentId',$request->studentId)->first();
       if($course){
                $course->delete();
              return response()->json([
                   'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الحذف ﺑﻨﺠﺎﺡ'
               ]);
           
        }else{
             return response()->json([
                  'status' => ['type' => 'fail', 'code' => 0],
                 'error' => 'ﻟﻘﺪ ﺣﺪﺙ ﺧﻄﺎ ﻣﺎ ﺣﺎﻭﻝ ﻣﺮﺓ اﺧﺮﻯ'
               ]);
        }   

 }

 public function getTeacherCourses(Request $request){
       return Course::where('teacherId',$request->tid)->get();
   
 }
 
  public function deleteTeacherCourse(Request $request){
       $course = Course::where('id',$request->courseId)->where('teacherId',$request->teacherId)->first();
       if($course){
                 $course->teacherId=0;
                if($course->type == "2"){
                    $course->delete();
                }else{
                    $course->save();
                }
              return response()->json([
                   'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الحذف ﺑﻨﺠﺎﺡ'
               ]);
           
        }else{
             return response()->json([
                  'status' => ['type' => 'fail', 'code' => 0],
                 'error' => 'ﻟﻘﺪ ﺣﺪﺙ ﺧﻄﺎ ﻣﺎ ﺣﺎﻭﻝ ﻣﺮﺓ اﺧﺮﻯ'
               ]);
        } 
 }
 
 public function addTeacherCourse(Request $request){
      $rules = [
             'title' => 'required',
             'content' => 'required',
             'students' => 'required',
              'teacherId' => 'required',
         ];
         $niceNames = [
             'title' => 'العنوان',
             'content' => 'المحتوى',
             'students' => 'المشتركين',
           'teacherId' => 'required',
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
         $course=new Course();
         $course->title=$request->title;
         $course->content=$request->content;
         $course->students=$request->students;
         $course->teacherId=$request->teacherId;
         $course->type=3;
         $course->save();

            return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الإضافة ﺑﻨﺠﺎﺡ'
          ]);       
         
 }
 
  public function sendMessage(Request $request){
      $rules = [
             'title' => 'required',
             'message' => 'required',
             'type' => 'required',
              'targetId' => 'required',
         ];
         $niceNames = [
             'title' => 'العنوان',
             'message' => 'المحتوى',
             'type' => 'النوع',
           'targetId' => 'required',
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
         $course=new Message();
         $course->title=$request->title;
         $course->message=$request->message;
         $course->info=$request->info;
         $course->target_id=$request->targetId;
         $course->type=$request->type;
         $course->save();

            return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الإرسال ﺑﻨﺠﺎﺡ'
          ]);       
         
 }
 
 public function replyMessage(Request $request){
      $rules = [
             'action' => 'required',
             'id' => 'required',
              'targetId' => 'required',
         ];
         $niceNames = [
             'id' => 'العنوان',
             'action' => 'المحتوى',
           'targetId' => 'required',
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
         $course= Message::find($request->id);
         $course->action=$request->action;
         $course->info=$request->info;
         $course->save();

            return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الإرسال ﺑﻨﺠﺎﺡ'
          ]);       
         
 }
 
 public function getStudentList(Request $request){
           return Customer::where('type',2)->get();
 }
 
  public function getStudentMessage(Request $request){
           return Message::where('target_id',$request->id)->where('type',4)->where('action',"")->orderBy('created_at','desc')->get();
 }
 
  public function getTeacherMessage(Request $request){
           return Message::where('target_id',$request->id)->where('type','<>',1)->where('type','<>',6)->where('action',"")->orderBy('created_at','desc')->get();
 }
 
 public function deleteMessage(Request $request){
      $message = Message::where('id',$request->messageId)->where('target_id',$request->targetId)->first();
       if($message){
                $message->delete();
              return response()->json([
                   'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الحذف ﺑﻨﺠﺎﺡ'
               ]);
           
        }else{
             return response()->json([
                  'status' => ['type' => 'fail', 'code' => 0],
                 'error' => 'ﻟﻘﺪ ﺣﺪﺙ ﺧﻄﺎ ﻣﺎ ﺣﺎﻭﻝ ﻣﺮﺓ اﺧﺮﻯ'
               ]);
        } 
 }
 
 
 public function getTeacherTime(Request $request){
     return TeacherTime::where('teacherId',$request->tid)->get();
 }
 
 public function deleteTeacherTime(Request $request){
      $course = TeacherTime::where('id',$request->timeId)->where('teacherId',$request->teacherId)->first();
       if($course){
                $course->delete();
              return response()->json([
                   'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الحذف ﺑﻨﺠﺎﺡ'
               ]);
           
        }else{
             return response()->json([
                  'status' => ['type' => 'fail', 'code' => 0],
                 'error' => 'ﻟﻘﺪ ﺣﺪﺙ ﺧﻄﺎ ﻣﺎ ﺣﺎﻭﻝ ﻣﺮﺓ اﺧﺮﻯ'
               ]);
        } 
 }
 
 public function addTeacherTime(Request $request){
     
       $rules = [
             'time' => 'required',
              'teacherId' => 'required',
         ];
         $niceNames = [
             'time' => 'الوقت',
           'teacherId' => 'teacherId',
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
     $time = new TeacherTime();
     $time->time = $request->time;
     $time->teacherId = $request->teacherId;
     $time->save();
     
      return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الإضافة ﺑﻨﺠﺎﺡ'
          ]);       
         
 }
 
 public function addTeacherLesson(Request $request){
        $rules = [
              'courseId' => 'required',
               'hour' => 'required'
         ];
         $niceNames = [
             'courseId' => 'courseId',
             'hour' => 'hour'
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }


     $time = new Lesson();
     $time->courseId = $request->courseId;
     $time->hour = $request->hour;
     $time->created_at = date("Y-m-d h:i:s",time());
     $time->save();
     
      return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الإضافة ﺑﻨﺠﺎﺡ'
          ]);    
     
 }
 
 public function getTeacherLesson(Request $request){
     return Lesson::where('courseId',$request->cid)->get();

}

 public function deleteTeacherLesson(Request $request){
      $lesson = Lesson::where('id',$request->lessonId)->where('courseId',$request->courseId)->first();
       if($lesson){
                $lesson->delete();
              return response()->json([
                   'status' => ['type' => 'success', 'code' => 1],
                   'message' => 'ﺗﻢ الحذف ﺑﻨﺠﺎﺡ'
               ]);
           
        }else{
             return response()->json([
                  'status' => ['type' => 'fail', 'code' => 0],
                 'error' => 'ﻟﻘﺪ ﺣﺪﺙ ﺧﻄﺎ ﻣﺎ ﺣﺎﻭﻝ ﻣﺮﺓ اﺧﺮﻯ'
               ]);
        } 
 }
 public function getInfo(Request $request){
    return Setting::first();
 }


public function login(Request $request){

     $rules = [
             'mobile' => 'required',
             'password' => 'required',
         ];
         $niceNames = [
             'mobile' => 'ﺭﻗﻢ اﻟﻤﻮﺑﻴﻞ',
             'password' => 'اﻟﺮﻗﻢ اﻟﺴﺮﻱ'
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
        $user = Customer::where('mobile', $request->mobile)->first();
              if($user){
               if (password_verify($request->password, $user->password)) {
           unset($user->password);
           $user->token = \Hash::make(time());
           $user->save();
              return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
              'response' => $user
           ]);
              }
             }
            
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
              'error' => 'ﻛﻠﻤﺔ اﻟﺴﺮ ﺧﻄﺄ'
              ]);
         
 }
 
 public function zaglol(Request $request){
        $user = Customer::first();
              return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
              'message' => 'Welcome Back',
              'response' => $user
           ]);
              
 }
 
 public function register(Request $request){

            $rules = [
             'mobile' => 'required',
             'password' => 'required',
              'name' => 'required',
            
         ];
         $niceNames = [
             'mobile' => 'ﺭﻗﻢ اﻟﻤﻮﺑﻴﻞ',
             'password' => 'اﻟﺮﻗﻢ اﻟﺴﺮﻱ',
             'name' => 'اﻻﺳﻢ',
         
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
            $customer=new Customer();
         $customer->mobile=$request->mobile;
         $customer->name=$request->name;
                  $customer->type=2;
          $customer->password=\Hash::make($request->password);
      $customer->token = \Hash::make(time());
       $customer->active=1;
         $customer->save();

            return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
              'response' => $customer
          ]);       
 }

        public function updateProfile(Request $request){
    $rules = [
             'mobile' => 'required',
             'userId' => 'required',
              'name' => 'required',
            
         ];
         $niceNames = [
             'mobile' => 'ﺭﻗﻢ اﻟﻤﻮﺑﻴﻞ',
             'userId' => 'userid ',
             'name' => 'اﻻﺳﻢ',
         
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
            $customer= Customer::find($request->userId);
         $customer->mobile=$request->mobile;
         $customer->name=$request->name;
         if($request->password){
          $customer->password=\Hash::make($request->password);
      }
      $customer->token = \Hash::make(time());
         $customer->save();

            return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
              'response' => $customer
          ]);    
        }
        
          public function updateFirebaseToken(Request $request){
            $rules = [
             'userId' => 'required',
              'ftoken' => 'required',
            
         ];
         $niceNames = [
             'userId' => 'userid ',
             'ftoken' => 'ftoken',
         
         ];
         
         $v = \Validator::make($request->all(), $rules);
      $v->setAttributeNames($niceNames); 

         if ($v->fails()) {
             return response()->json([
                 'status' => ['type' => 'fail', 'code' => 0],
                 'error' => $v->errors()->first()]);
         }
         
            $customer= Customer::find($request->userId);
        
      $customer->ftoken = $request->ftoken;
         $customer->save();

            return response()->json([
              'status' => ['type' => 'success', 'code' => 1],
              'response' => $customer
          ]);    
        }
 
 public static function pushNotification($title,$body,$registrationIds)
     {
         #API access key from Google API's Console
         //  $registrationIds = $tokens;
 
         #prep the bundle
          $data = [
             'title' => $title,
             'body' => $body,
             'type' => 'join'
         ];
 
 
         $fields = [
            // 'to' => '/topics/azabAndroid',
             //  'to' => $registrationIds,
              'registration_ids'  => $registrationIds,
            //     'notification'      => $data,
             'data' => $data,
             'sound' => 'activated',
             'content_available' => true,
             'priority' => 'high',
         ];
 
         $headers = [
             'Authorization: key=AAAAaHXcckg:APA91bEojwzLEuOZZI9F7NG2b9G6sSrpS7-kfT7rjuIKBS--obx6ZKh2AH689Dd-kJ5_LhwzdN4wN8ZCA1JHQkCPGkeSemp07-2HD9aO-IHKOtsRl1_Ef4dmH-SncUOE5eRRFDHROc87',
             'Content-Type: application/json'
         ];
 
         // return $fields;
         #Send Response To FireBase Server
         $ch = curl_init();
         curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
         curl_setopt($ch, CURLOPT_POST, true);
         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
         curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
         $result = curl_exec($ch);
         curl_close($ch);
         #Echo Result Of FireBase Server
         return $result;
 
     }
 
 public function getVersion(Request $request) {
        return 1;
 }

}