<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CartController extends Controller {

    public function addToCart(Request $request) {
        $id = $request->product_id;
        $product = \App\Product::find($id);
        $qnty = $request->quentity;
        $itemArray = array(
            $product->product_id =>
            array(
                'image' => $product->image,
                'name' => $product->name,
                'id' => $product->product_id,
                'quentity' => $qnty,
                'comment' => $request->comment,
                'price' => $product->price,
                'cuttingway' => $request->cuttingway,
                'khalta_way' => $request->khalta_way,
                'hasho_ways' => $request->hasho_ways,
                'recentfat' => $request->recentfat,
                'total' => $product->price * $qnty
            )
        );

        if ($request->session()->get('cart_item') == null) {
            $request->session()->put('cart_item', $itemArray);
        } else {
            $request->session()->put('cart_item', array_merge($request->session()->get('cart_item'), $itemArray));
        }

        $returned_value = array(
            'number_of_product' => count($request->session()->get('cart_item')),
            'image' => $product->image,
            'name' => $product->name,
            'id' => $product->product_id,
            'quentity' => $qnty,
            'comment' => $request->comment,
            'price' => $product->price,
            'cuttingway' => $request->cuttingway,
            'khalta_way' => $request->khalta_way,
            'hasho_ways' => $request->hasho_ways,
            'recentfat' => $request->recentfat,
            'total' => $product->price * $qnty
        );
        return $returned_value;
    }

    public function cart() {

        $data = $data = them\HomeController::layout();
        $data['products'] = Session::get('cart_item');
        $data['deleivery_time'] = DeliveryTime::all();

        $data['lat'] = Session::get('customer_lat');
        $data['lng'] = Session::get('customer_lng');
        return View::make("them.cart.index")->with($data);
    }

    public function remove($id, $key, Request $request) {
        // Session::forget("cart_item." . $id);

        foreach ($request->session()->get("cart_item") as $k => $v) {
            if ($id == $request->session()->get("cart_item")[$k]['id'] && $key == $k) {
                $request->session()->forget("cart_item." . $k);
                break;
            }
        }
        return \Redirect::to('user/shopping/cart');
    }

}
