<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CertificationController extends Controller {

    public function index() {
            $data['menu_name'] = "cert";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Certification::orderBy('updated_at', 'desc')->get();

            return View('admin.cert.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "cert";
            $data = DashboardController::layout($data);
            return View('admin.cert.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',        
            ];
            $niceNames = [
                'title' => 'image ',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Certification;

            $item->title = $request->title;
           
            $item->save();
            return \Redirect::to('admin/cert/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "cert";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Certification::find($id);
            return View('admin.cert.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Certification::find($id);
           
            $item->title = $request->title;
           
            $item->save();
            return \Redirect::to('admin/cert/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Certification::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
