<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ClientController extends Controller {

    public function index() {
            $data['menu_name'] = "client";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Client::orderBy('updated_at', 'desc')->get();

            return View('admin.client.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "client";
            $data = DashboardController::layout($data);
            return View('admin.client.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'type' => 'required',               
            ];
            $niceNames = [
                'title' => 'title ',
                'type' => 'type ',
              
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Client;

            $item->title = $request->title;
            $item->type = $request->type;

        
            $item->save();
            return \Redirect::to('admin/client/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "client";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Client::find($id);
            return View('admin.client.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'type' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'type' => 'type ',
             
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Client::find($id);
           
            $item->title = $request->title;
            $item->type = $request->type;
            
            $item->save();
            return \Redirect::to('admin/client/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Client::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
