<?php
namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
class DashboardController extends Controller{
    public function index(Request $request){
        $request->session()->put('admin_lang',"ar");
        $data['setting']='dashboard page';  //site setting
        $data=DashboardController::layout($data);
      
        $data['users']= \Sentinel::getUserRepository()->get();
        $data['groups'] = \Sentinel::getRoleRepository()->get();
 
       return view('admin.index', $data);
    }
    
    
    public static function layout($data){
        $data['setting']= \App\Setting::find(1);
        $language = \App\Language::all();

        $result = array();
        
        foreach($language as $lang){
          $key = $lang['key'];

            if(session('admin_lang') == "ar"){
                $lang->name = $lang->nameAr;
            }else{
                $lang->name = $lang->nameEn;
            }

        $result[$key] = $lang->name;

        }
       
        $data['language'] =   $result ; 
        $data['header']=View('admin.layout.header')->with($data);
        $data['footer']=View('admin.layout.footer');
        $data['nav']=View('admin.layout.nav')->with($data);
       
        return $data;
    }
    
}
