<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;

class GroupController extends Controller {

    public function index() {
        if (\Sentinel::hasAccess('view.group')) {
            $data['menu_name'] = "admin_user";
            $data = DashboardController::layout($data);
            $data['groups'] = \Sentinel::getRoleRepository()->get();
            return View('admin.group.index', $data);
        } else {
            echo 'you donot have permission to access this';
        }
    }

    public function create() {
        if (\Sentinel::hasAccess('create.group')) {
            $data['menu_name'] = "admin_user";
            $data = DashboardController::layout($data);
            return View('admin.group.create', $data);
        } else {
            echo 'you donot have permission to access this';
        }
    }

    public function store(Request $request) {
        if (\Sentinel::hasAnyAccess(['create.group'])) {
            $group_name = $request->group_name;
            $permissions = $request->permission;
            $number_permission = count($permissions);
            $rules = array();
            for ($i = 0; $i < $number_permission; $i++) {
                $rules[$permissions[$i]] = true;
            }

            $role = \Sentinel::getRoleRepository()->createModel()->create([
                'name' => $group_name,
                'slug' => $group_name,
                'permissions' => $rules,
            ]);

            return \Redirect::to('admin/group/all');
        } else {
            echo 'you donot have permission to access this';
        }
    }
    
   public function edit($id) {
        if (\Sentinel::hasAnyAccess('update.group')) {
            $data['menu_name']="admin_user";
            $data = DashboardController::layout($data);
            
                $data['groups'] = \Sentinel::findRoleById($id);
                return View('admin.group.edit',$data);
            
        } else {
            echo "لا تملك صلاحيه للدخول الى هذه الصفحة";
        }
    }

    public function update($id,Request $request) {
        if (\Sentinel::hasAnyAccess('update.group')) {
            $group_name = $request->group_name;
            $permissions = $request->permission;
            $number_permission = count($permissions);
            $rules = array();
            for ($i = 0; $i < $number_permission; $i++) {
                $rules[$permissions[$i]] = true;
            }
            $role = \Sentinel::findRoleById($id);
            $role->permissions=$rules;
            $role->name=$group_name;
            $role->save();
            return \Redirect::to('admin/group/all');
        } else {
              echo "لا تملك صلاحيه للدخول الى هذه الصفحة";
        }
    }

    public function delete($id) {
        if (\Sentinel::hasAnyAccess('delete.group')) {
            try {
                // Find the group using the group id
                $role = \Sentinel::findRoleById($id);

                // Delete the group
                $role->delete();
                return \Redirect::back()->with('sucess_message', 'تم حذف الجروب بنجاح.');
            } catch (Cartalyst\Sentry\Groups\GroupNotFoundException $e) {
                echo 'لم يتم العثور على هذا الجروب';
            }
        } else {
              echo "لا تملك صلاحيه للدخول الى هذه الصفحة";
        }
    }

}
