<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class JobsController extends Controller {

    public function index() {
            $data['menu_name'] = "jobs";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Jobs::orderBy('updated_at', 'desc')->get();

            return View('admin.jobs.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "jobs";
            $data = DashboardController::layout($data);
            return View('admin.jobs.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',     
            ];
            $niceNames = [
                'title' => 'title ',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Jobs;

            $item->title = $request->title;
           
            $item->save();
            return \Redirect::to('admin/jobs/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "jobs";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Jobs::find($id);
            return View('admin.jobs.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Jobs::find($id);
        
            $item->title = $request->title;
           
            $item->save();
            return \Redirect::to('admin/jobs/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Jobs::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
