<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MBAController extends Controller {

    public function index() {
            $data['menu_name'] = "mba";
            $data = DashboardController::layout($data);
            $data['list'] = \App\MBA::orderBy('updated_at', 'desc')->get();

            return View('admin.mba.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "news";
            $data = DashboardController::layout($data);
            return View('admin.mba.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'image ',
               
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\MBA;

            $item->title = $request->title;
            $item->save();
            return \Redirect::to('admin/mba/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "mba";
            $data = DashboardController::layout($data);
            $data['item'] = \App\MBA::find($id);
            return View('admin.mba.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\MBA::find($id);
           
            $item->title = $request->title;
            $item->save();
            return \Redirect::to('admin/mba/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\MBA::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
