<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class NewsController extends Controller {

    public function index() {
            $data['menu_name'] = "news";
            $data = DashboardController::layout($data);
            $data['list'] = \App\News::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();

            return View('admin.news.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "news";
            $data = DashboardController::layout($data);
            return View('admin.news.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'image' => 'required',
                'order' => 'required',
                'type' => 'required',
            ];
            $niceNames = [
                'title' => 'image ',
                'content' => 'image ',
                'image' => 'image ',
                'order' => 'order',
                'type' => 'type',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\News;

            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;
            $item->type = $request->type;

            $destination = base_path('public/admin/images/news/'); // your upload folder
            $image = $request->file('image');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/news/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "slider";
            $data = DashboardController::layout($data);
            $data['item'] = \App\News::find($id);
            return View('admin.news.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'order' => 'required',
                'type' => 'required',
            ];
            $niceNames = [
                'title' => 'image ',
                'content' => 'image ',
                'order' => 'order',
                'type' => 'type',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\News::find($id);
            if ($request->hasFile('image')) {
                $destination = base_path('public/admin/images/news/'); // your upload folder
                $image = $request->file('image');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;
            $item->type = $request->type;
            
            $item->save();
            return \Redirect::to('admin/news/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\News::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
