<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ReviewController extends Controller {

    public function index() {
            $data['menu_name'] = "review";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Review::orderBy('updated_at', 'desc')->get();

            return View('admin.review.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "review";
            $data = DashboardController::layout($data);
            return View('admin.review.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'name' => 'required',
                'job' => 'required',
                'message' => 'required',
                'file' => 'required',
            ];
            $niceNames = [
                'name' => 'name ',
                'job' => 'job ',
                'message' => 'message ',
                'file' => 'image ',
              
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Review;

            $item->name = $request->name;
            $item->job = $request->job ;
            $item->message = $request->message;

            $destination = base_path('public/admin/images/review/'); // your upload folder
            $image = $request->file('file');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/review/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "review";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Review::find($id);
            return View('admin.review.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'name' => 'required',
                'job' => 'required',
                'message' => 'required',
            ];
            $niceNames = [
                'name' => 'name ',
                'job' => 'job ',
                'message' => 'message ',
             
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Review::find($id);
            if ($request->hasFile('file')) {
                $destination = base_path('public/admin/images/review/'); // your upload folder
                $image = $request->file('file');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
           
            $item->name = $request->name;
            $item->job = $request->job ;
            $item->message = $request->message;
            
            $item->save();
            return \Redirect::to('admin/review/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Review::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
