<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SubServiceController extends Controller {

     public function index($sid) {
            $data['menu_name'] = "subservice";
            $data = DashboardController::layout($data);
            $data['list'] = \App\SubService::where('service_id',$sid)->orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
            $data['sid'] = $sid;
            return View('admin.service.sub.index', $data);
    }

    public function create($sid) {
            $data['menu_name'] = "subservice";
            $data = DashboardController::layout($data);
            $data['sid'] = $sid;
            return View('admin.service.sub.create', $data);
        
    }

   public function store($sid,Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'image' => 'required',
                'order' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'image' => 'image ',
                'order' => 'order', 
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\SubService;

            $item->service_id = $sid;
            $item->title = $request->title;
            $item->content = $request->content;
                $item->order = $request->order;
        
            $destination = base_path('public/admin/images/services/'); // your upload folder
            $image = $request->file('image');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;

          
            $item->save();
            return \Redirect::to('admin/services/sub/'.$sid)->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "subservice";
            $data = DashboardController::layout($data);
            $data['item'] = \App\SubService::find($id);
            return View('admin.service.sub.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'order' => 'required',
                ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\SubService::find($id);
          
            $item->title = $request->title;
            $item->content = $request->content;
             $item->order = $request->order;
           
            if ($request->hasFile('image')) {
                $destination = base_path('public/admin/images/services/'); // your upload folder
                $image = $request->file('image');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
            
            $item->save();
            return \Redirect::to('admin/services/sub/'.$item->service_id)->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\SubService::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }


}
