<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TeamController extends Controller {

    public function index() {
            $data['menu_name'] = "team";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Team::orderBy('updated_at', 'desc')->get();

            return View('admin.team.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "team";
            $data = DashboardController::layout($data);
            return View('admin.team.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'name' => 'required',
                'file' => 'required',
            ];
            $niceNames = [
                'name' => 'name ',
                'file' => 'image ',
              
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Team;

            $item->name = $request->name;
            $item->facebook = $request->facebook ? $request->facebook :"#";
            $item->instagram = $request->instagram ? $request->instagram :"#";
            $item->linkedin = $request->linkedin ? $request->linkedin :"#";

            $destination = base_path('public/admin/images/team/'); // your upload folder
            $image = $request->file('file');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/team/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "team";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Team::find($id);
            return View('admin.team.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'name' => 'required',
            ];
            $niceNames = [
                'name' => 'name ',
             
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Team::find($id);
            if ($request->hasFile('file')) {
                $destination = base_path('public/admin/images/team/'); // your upload folder
                $image = $request->file('file');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
           
            $item->name = $request->name;
            $item->facebook = $request->facebook ? $request->facebook :"#";
            $item->instagram = $request->instagram ? $request->instagram :"#";
            $item->linkedin = $request->linkedin ? $request->linkedin :"#";
            
            $item->save();
            return \Redirect::to('admin/team/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Team::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
