<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TimeController extends Controller {

     public function index() {
            $data['menu_name'] = "time";
            $data = DashboardController::layout($data);
            $data['list'] = \App\TeacherTime::orderBy('created_at', 'desc')->get();
            return View('admin.time.index', $data);
    }

    public function create() {
            $data['menu_name'] = "time";
            $data = DashboardController::layout($data);
            return View('admin.time.create', $data);
        
    }

   public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'order' => 'required',
            ];
            $niceNames = [
                'title' => 'title',
                'content' => 'content ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Service;

            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;

          
            $item->save();
            return \Redirect::to('admin/time/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "time";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Service::find($id);
            return View('admin.time.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                 'order' => 'required',
           ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Service::find($id);
          
            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;

            $item->save();
            return \Redirect::to('admin/time/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\TeacherTime::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }


}
