<?php

namespace App\Http\Controllers\theme;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Mail;

class HomeController extends Controller {

    public function index(Request $request) {
        $request->session()->put('site_lang',"en");
        $data= HomeController::layout();
        return view('theme/index')->with($data);
    }
    
     public function login() {
        $data= HomeController::layout();
        return view('theme/login')->with($data);
    }
    
    
     public function contact() {
        $data= HomeController::layout();
        return view('theme/contact')->with($data);
    }

    public function training() {
        $data= HomeController::layout();
        return view('theme/training')->with($data);
    }

    public function center() {
        $data= HomeController::layout();
        return view('theme/center')->with($data);
    }

    public function why() {
        $data= HomeController::layout();
        return view('theme/why')->with($data);
    }

    public function partner() {
        $data= HomeController::layout();
        return view('theme/partner')->with($data);
    }
    
    public function about() {
        $data= HomeController::layout();
        return view('theme/about')->with($data);
    }

    public function certification() {
        $data= HomeController::layout();
        $data['list'] = \App\Certification::all();
        return view('theme/cert')->with($data);
    }

    public function policy() {
        $data= HomeController::layout();
        return view('theme/privacy')->with($data);
    }
    
    public function doLang(Request $request, $lang){
          $request->session()->put('site_lang',$lang);
                
          return \Redirect::back();
    }
    
    public function logout(Request $request){
          $request->session()->remove('user_id');
          $request->session()->remove('user_mobile');
          $request->session()->remove('user_email');
          $request->session()->remove('user_name');
                
          return \Redirect::to("/");
    }
    
    public function privacy() {
        $data= HomeController::layout();
        return view('theme/privacy')->with($data);
    }

    public function sendContact(Request $request) {
        $data= HomeController::layout();

        $rules = [
                'name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'message' => 'required',
            ];
            $niceNames = [
                'name' => 'name',
                'email' => 'email',
                'phone' => 'phone',
                'message' => 'message',
            ];
        $this->validate($request, $rules, [], $niceNames);

        $item = new \App\Contact;
        $item->name = $request->name;
        $item->email = $request->email;
        $item->phone = $request->phone;
        $item->message = $request->message;
        $item->save();
        
        // Mail::send('emails.welcome', array(), function($message) use($item) {
        // $message->to("hosam.azzam2@gmail.com", "")->subject('New Feedback');
        // });

        return \Redirect::to('/')->with('message', 'Saved Successfully');
    }
    
    public function signin(Request $request) {
    
        $data= HomeController::layout();

        $rules = [
                'email' => 'required',
                'password' => 'required',

            ];
            $niceNames = [
                'email' => 'email/mobile',
                'password' => 'password',
            ];
        $this->validate($request, $rules, [], $niceNames);

        $user = \App\Customer::where('mobile', $request->phone)->orWhere('email',$request->email)->first();
              if($user){
                  if (password_verify($request->password, $user->password)) {
            
                    $request->session()->put('user_id',$user->id);
                    $request->session()->put('user_name',$user->name);
                    $request->session()->put('user_mobile',$user->mobile);
                    $request->session()->put('user_email',$user->email);

                        return \Redirect::to('/')->with('message',$data['language']['site_word_welcome_back'].', '.$user->name);
                    }
                    else{
                        return \Redirect::back()->withInput()->with('error',$data['language']['site_word_password_wrong']);
                    }
                  
              }else{
                  return \Redirect::back()->withInput()->with('error',$data['language']['site_word_email_phone_not_found']);
              }
        
      
      
        
    }

 public function signup(Request $request) {
        $data= HomeController::layout();

        $rules = [
                'name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'password' => 'required',
                'address' => 'required',
            ];
            $niceNames = [
                'name' => 'name',
                'email' => 'email',
                'phone' => 'phone',
                'password' => 'message',
                'address' => 'address',
            ];
        $this->validate($request, $rules, [], $niceNames);
        
        
         $user = \App\Customer::where('mobile', $request->phone)->orWhere('email',$request->email)->first();
              if(!$user){

                $item = new \App\Customer;

                $item->token = \Hash::make(time());
                $item->name = $request->name;
                $item->email = $request->email;
                $item->mobile = $request->phone;
                $item->password = \Hash::make($request->password);
                $item->address = $request->address;
        
                $item->save();
           
                return \Redirect::to('/')->with('message',$data['language']['site_word_account_create_successfully']);
              
              }else{
                  
                return \Redirect::back()->withInput()->with('error',$data['language']['site_word_email_phone_used']);
                  
              }
             
            
            
            
       
        
        // Mail::send('emails.welcome', array(), function($message) use($item) {
        // $message->to("hosam.azzam2@gmail.com", "")->subject('New Feedback');
        // });

    }


    public static function layout() {
        $data['site_setting'] = \App\Setting::find(1);
         $language = \App\Language::all();
        
        $result = array();
          foreach ($language as $lang)
          { 
            $key = $lang['key'];
            if(session('site_lang') == "ar"){
                $lang->name = $lang->nameAr;
            }else{
                $lang->name = $lang->nameEn;
            }  
            $result[$key] = $lang->name;
          }
       
        $data['language'] =   $result ; 
        $data['sliders'] = \App\Slider::orderBy('updated_at', 'desc')->limit(5)->get();
        $data['mezaf'] = \App\Meza::orderBy('updated_at', 'desc')->limit(3)->get();
        $data['mezas'] = \App\Meza::orderBy('updated_at', 'desc')->skip(3)->limit(2)->get();
        $data['isos'] = \App\ISO::orderBy('updated_at', 'desc')->limit(5)->get();
        $data['teams'] = \App\Team::orderBy('updated_at', 'desc')->limit(3)->get();
        $data['reviews'] = \App\Review::orderBy('updated_at', 'desc')->limit(5)->get();
        // $data['gallery'] = \App\Gallery::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // $data['new'] = \App\News::where('type',0)->orderBy('order', 'asc')->orderBy('created_at', 'desc')->first();
        // $data['info'] = \App\Info::first();
        // $data['news'] = \App\News::where('type','<>',0)->orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // $data['clients'] = \App\Client::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // $data['projects'] = \App\Project::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // $data['services'] = \App\Service::with('sub')->orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // $data['sections'] = \App\Section::first();
        // $data['challenges'] = \App\Challenge::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // $data['navigation'] = \App\Navigation::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // $services = \App\Service::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
        // foreach ($services as $key) {
        //     $key->sub= \App\SubService::where('service_id',$key->id)->orderBy('order', 'asc')->orderBy('created_at', 'desc')->get(); //paginate(2)
        // }
        // $data['services'] = $services;
        return $data;
    }

}
