<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>{{$language['site_title']}}</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Free HTML Templates" name="keywords">
    <meta content="Free HTML Templates" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet"> 

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="public/theme/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="public/theme/css/style.css" rel="stylesheet">
</head>

<div>



    <!-- Navbar Start -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light shadow-sm px-5 py-3 py-lg-0">
        <a href="home" class="navbar-brand p-0">
             <img src="public/admin/images/setting/{{$site_setting->logo}}" alt="EAEL Logo" class="navbar-brand-img" style="height: 5rem;">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
         <div class="collapse navbar-collapse" id="navbarCollapse">
            <div class="navbar-nav ms-auto py-0 me-n3">
                <a href="home" class="nav-item nav-link active">HOME</a>
                <a href="about" class="nav-item nav-link">ABOUT US</a>
                <a href="partner" class="nav-item nav-link">TRAINING PARTNER</a>
                <a href="certification" class="nav-item nav-link">CERTIFICATIONS</a>
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">REGISTER</a>
                    <div class="dropdown-menu m-0">
                        <a href="#" class="dropdown-item">Training</a>
                        <a href="center" class="dropdown-item">Training Center</a>
                    </div>
                </div>
                <a href="contact" class="nav-item nav-link">CONTACT US</a>
            </div>
        </div>
    </nav>
    <!-- Navbar End -->


    <!-- Page Header Start -->
    <div class="container-fluid bg-dark p-5">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="display-4 text-white">Training</h1>
                <a href="home">Home</a>
                <i class="far fa-square text-primary px-2"></i>
                <a href="#">Training</a>
            </div>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- Content Start -->
     <div class="container-fluid bg-secondary px-0">
        <div class="row g-0 justify-content-center align-items-center">
            <div class="col-lg-8 py-6 px-5">
                <h1 class="display-5 mb-4">Training Request</h1>
                <form>
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-1" placeholder="John Doe">
                                <label for="form-floating-1">Full Name</label>
                            </div>
                        </div>
                         <div class="col-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-1" placeholder="John Doe">
                                <label for="form-floating-1">Mobile Number</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="date" class="form-control" id="form-floating-2" placeholder="name@example.com">
                                <label for="form-floating-2">Birthday</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-1" placeholder="John Doe">
                                <label for="form-floating-1">Nationality</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <select  class="form-select" name="gender" id="form-floating-1">
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                                <label for="form-floating-2">Gender</label>
                            </div>
                        </div>
                         <div class="col-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-1" placeholder="John Doe">
                                <label for="form-floating-1">National ID</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="email" class="form-control" id="form-floating-2" placeholder="name@example.com">
                                <label for="form-floating-2">Email Address</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="email" class="form-control" id="form-floating-2" placeholder="name@example.com">
                                <label for="form-floating-2">Educational Qualification</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="email" class="form-control" id="form-floating-2" placeholder="name@example.com">
                                <label for="form-floating-2">Degree</label>
                            </div>
                        </div>
                         <div class="col-6">
                            <div class="form-floating">
                                <select  class="form-select" name="gender" id="form-floating-1">
                                    <option value="male">S.T Senior Trainer</option>
                                    <option value="female">C.T Certified Trainer</option>
                                    <option value="female">P.T Professional Trainer</option>
                                    <option value="female">I.C.T International Certified Trainer</option>
                                    <option value="female">C.T.E Certified Training Expert</option>
                                    <option value="female">C.G.T Certified Great Trainer</option>
                                    <option value="female">C.C Certified Consultant</option>
                                    
                                </select>
                                <label for="form-floating-2">International Certification</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="file" class="form-control" id="form-floating-3" placeholder="Subject">
                                <label for="form-floating-3">Certification</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="file" class="form-control" id="form-floating-3" placeholder="Subject">
                                <label for="form-floating-3">Passport</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="file" class="form-control" id="form-floating-3" placeholder="Subject">
                                <label for="form-floating-3">Photo</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="file" class="form-control" id="form-floating-3" placeholder="Subject">
                                <label for="form-floating-3">C.V file</label>
                            </div>
                        </div>
                        
                     
                        <div class="col-12">
                            <button class="btn btn-primary w-100 py-3" type="submit">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <!-- Content End -->

    </div>
    <div class="container-fluid bg-dark text-secondary p-5">
        <div class="row g-5">
            <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Quick Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <a class="text-secondary mb-2" href="home"><i class="bi bi-arrow-right text-primary me-2"></i>Home</a>
                    <!--<a class="text-secondary mb-2" href="why"><i class="bi bi-arrow-right text-primary me-2"></i>WHY CHOOSE EAEL?</a>-->
                    <a class="text-secondary mb-2" href="about"><i class="bi bi-arrow-right text-primary me-2"></i>About Us</a>

                </div>
            </div>
             <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Popular Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <!--<a class="text-secondary mb-2" href="policy"><i class="bi bi-arrow-right text-primary me-2"></i>Privacy Policy</a>-->
                    <a class="text-secondary mb-2" href="certification"><i class="bi bi-arrow-right text-primary me-2"></i>Certification</a>
                    <a class="text-secondary" href="contact"><i class="bi bi-arrow-right text-primary me-2"></i>Contact Us</a>
                </div>
            </div>
            <!-- <div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Get In Touch</h3>-->
            <!--    <p class="mb-2"><i class="bi bi-geo-alt text-primary me-2"></i>{{$site_setting->address}}</p>-->
            <!--    <p class="mb-2"><i class="bi bi-envelope-open text-primary me-2"></i>{{$site_setting->email}}</p>-->
            <!--    <p class="mb-0"><i class="bi bi-telephone text-primary me-2"></i>{{$site_setting->mobile}}</p>-->
            <!--</div>-->
            <!--<div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Follow Us</h3>-->
            <!--    <div class="d-flex">-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="{{$site_setting->twitter}}"><i class="fab fa-twitter fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="{{$site_setting->facebook}}"><i class="fab fa-facebook-f fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="{{$site_setting->linkedin}}"><i class="fab fa-linkedin-in fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle" href="{{$site_setting->youtube}}"><i class="fab fa-youtube fw-normal"></i></a>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
    </div>
   
    <!-- Footer End -->


    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-circle back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="public/theme/lib/easing/easing.min.js"></script>
    <script src="public/theme/lib/waypoints/waypoints.min.js"></script>
    <script src="public/theme/lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="public/theme/js/main.js"></script>
</body>

</html>