<!DOCTYPE html>
<html lang="en">
  <head>
    <title><?php echo e($language['site_title']); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <link href="https://fonts.googleapis.com/css?family=Poppins:200,300,400,500,600,700,800&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lipis/flag-icons@6.11.0/css/flag-icons.min.css"/>
    <link rel="stylesheet" href="/public/theme/css/open-iconic-bootstrap.min.css">
    <link rel="stylesheet" href="/public/theme/css/animate.css">
    
    <link rel="stylesheet" href="/public/theme/css/owl.carousel.min.css">
    <link rel="stylesheet" href="/public/theme/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="/public/theme/css/magnific-popup.css">

    <link rel="stylesheet" href="/public/theme/css/aos.css">

    <link rel="stylesheet" href="/public/theme/css/ionicons.min.css">

    <!--<link rel="stylesheet" href="public/theme/css/bootstrap-datepicker.css">-->
    <link rel="stylesheet" href="/public/theme/css/jquery.timepicker.css">


    <link rel="stylesheet" href="/public/theme/css/flaticon.css">
    <link rel="stylesheet" href="/public/theme/css/icomoon.css">
     <?php if(session('site_lang') == "ar"): ?>
        <link rel="stylesheet" href="/public/theme/css/styleAr.css">
        <link rel="stylesheet" href="/public/theme/css/bootstrap-datepickerAr.css">
    <?php else: ?>
        <link rel="stylesheet" href="/public/theme/css/styleEn.css">
        <link rel="stylesheet" href="/public/theme/css/bootstrap-datepickerEn.css">
    <?php endif; ?>
    
  </head>
  <body>
                   <?php echo $__env->make('common.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	  <nav class="navbar navbar-expand-lg navbar-dark ftco_navbar bg-dark ftco-navbar-light" id="ftco-navbar">
	    <div class="container">
	      <a class="navbar-brand" href="/">
	          
               <img src="/public/theme/images/logo2.png" style="width: 150px;"></img>
               </a>
	      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#ftco-nav" aria-controls="ftco-nav" aria-expanded="false" aria-label="Toggle navigation">
	        <span class="oi oi-menu"></span> 
	      </button>

	      <div class="collapse navbar-collapse" id="ftco-nav">
	        <ul class="navbar-nav ml-auto">
	          <li class="nav-item"><a href="/" class="nav-link"><?php echo e($language['site_word_home']); ?></a></li>
	          <li class="nav-item"><a href="/about" class="nav-link"><?php echo e($language['site_word_about']); ?></a></li>
	          <li class="nav-item"><a href="/cars" class="nav-link"><?php echo e($language['site_word_cars']); ?></a></li>
	          <li class="nav-item"><a href="/contact" class="nav-link"><?php echo e($language['site_word_contact']); ?></a></li>
                 <?php if(session('user_id')): ?>
	          <li class="nav-item"><a href="/profile" class="nav-link"><?php echo e($language['site_word_profile']); ?></a></li>
	          <li class="nav-item"><a href="/logout" class="nav-link"><?php echo e($language['site_word_logout']); ?></a></li>
	                <?php else: ?>
	          <li class="nav-item"><a href="/login" class="nav-link"><?php echo e($language['site_word_login']); ?></a></li>	        
	             <?php endif; ?>	      
	        </ul>
	        <div class="dropdown">
                <a class="dropdown-toggle" href="#" id="Dropdown" role="button" data-mdb-toggle="dropdown" aria-expanded="false">
                    <i></i>
                    <?php if(session('site_lang') == "ar"): ?>
                    <img src="/public/ae.svg" style="width: 25px;" ></img>
                    <?php else: ?>
                    <img src="/public/um.svg" style="width: 25px;" ></img>
                    <?php endif; ?>
                </a>
            
                <ul class="dropdown-menu" aria-labelledby="Dropdown">
                    <li>
                        <a class="dropdown-item" href="/lang/en"><i><img src="/public/um.svg" style="width: 25px" ></img></i> <?php echo e($language['english']); ?> <i class="fa fa-check text-success ms-2"></i></a>
                    </li>
                    <li><hr class="dropdown-divider" /></li>
                    <li>
                        <a class="dropdown-item" href="/lang/ar"><i><img src="/public/ae.svg" style="width: 25px" ></img></i> <?php echo e($language['arabic']); ?></a>
                    </li>
                 
                
                </ul>
            </div>
	        
	      </div>
	    </div>
	  </nav>
    <!-- END nav -->
    
    <section class="hero-wrap hero-wrap-2 js-fullheight" style="background-image: url(/public/theme/images/bg_3.jpg);" data-stellar-background-ratio="0.5">
      <div class="overlay"></div>
      <div class="container">
        <div class="row no-gutters slider-text js-fullheight align-items-end justify-content-start">
          <div class="col-md-9 ftco-animate pb-5">
          	<p class="breadcrumbs"><span class="mr-2"><a href="/"><?php echo e($language['site_word_home']); ?> <i class="ion-ios-arrow-forward"></i></a></span> <span><?php echo e($language['site_word_car_details']); ?> <i class="ion-ios-arrow-forward"></i></span></p>
            <h1 class="mb-3 bread"><?php echo e($language['site_word_car_details']); ?></h1>
          </div>
        </div>
      </div>
    </section>
		

		<section class="ftco-section ftco-car-details">
      <div class="container">
      	<div class="row justify-content-center">
      		<div class="col-md-12">
      			<div class="car-details">
      			    
      			  <div class="row">
    			<div class="col-md-12">
			             <?php if(session('site_lang') == "ar"): ?>
    				<div class="carousel-car-gallery-rtl owl-carousel">
                    <?php else: ?>
    				<div class="carousel-car-gallery owl-carousel">
                    <?php endif; ?>
                        
    					<div class="item">
    						<div class="car-wrap rounded ftco-animate">

		    					<div class="img rounded d-flex align-items-end" style="background-image: url(/public/admin/images/<?php echo e($item->image); ?>); height: 600px;">
		    					</div>
		    					

		    				</div>
    					</div>

                        <?php $__currentLoopData = $item->gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                            <div class="item">
    						<div class="car-wrap rounded ftco-animate">

		    					<div class="img rounded d-flex align-items-end" style="background-image: url(/public/admin/images/<?php echo e($gal->image); ?>); height: 600px;">
		    					</div>
		    					

		    			  	</div>
    					  </div>
    					
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    					
    					
    				     </div>
	
    				</div>
    			</div>

      			    
      			    
      				<!--<div class="img rounded" style="background-image: url(/public/admin/images/<?php echo e($item->image); ?>);"></div>-->

      				<div class="text text-center">
      					<span class="subheading"></span>
      					<?php if(session('site_lang') == "ar"): ?>
      					    <h2><?php echo e($item->title_ar); ?></h2>
      				    <?php else: ?>
      					    <h2><?php echo e($item->title_en); ?></h2>
      				    <?php endif; ?>
      				</div>
      			</div>
      		</div>
      	</div>
      	
      		
    			
    	
    	
    				
    				
      	<div class="row">
      		<div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center" style="border: none;"></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	<?php echo e($language['from']); ?>

		                	<span><?php echo e($item->from); ?></span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center" style="border: none;"></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                		<?php echo e($language['to']); ?>

		                	<span><?php echo e($item->to); ?></span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center" style="border: none;"></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                		<?php echo e($language['plate_num']); ?>

		                	<span><?php echo e($item->plate); ?></span>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon  align-items-center justify-content-center" style="border: none;"></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	<?php echo e($language['color']); ?>

		                		<?php if(session('site_lang') == "ar"): ?>
      					    <span><?php echo e($item->color_ar); ?></span>
      				    <?php else: ?>
      					    <span><?php echo e($item->color_en); ?></span>
      				    <?php endif; ?>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
          <div class="col-md d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services">
              <div class="media-body py-md-4">
              	<div class="d-flex mb-3 align-items-center">
	              	<div class="icon d-flex align-items-center justify-content-center" style="border: none;"></div>
	              	<div class="text">
		                <h3 class="heading mb-0 pl-3">
		                	<?php echo e($language['price']); ?>

		                	 <?php if($item->offer =="0"): ?>
			    						 	<span>   <?php echo e($item->price); ?> <span>/<?php echo e($language['day']); ?></span>
			    						    <?php else: ?>
			    						    	<span> <s style="color:lightGrey;"> <?php echo e($item->price); ?></s> <?php echo e(($item->price  - (($item->price * $item->offer) / 100) )); ?> <span>/<?php echo e($language['day']); ?></span>
			    						    <?php endif; ?>
		                </h3>
	                </div>
                </div>
              </div>
            </div>      
          </div>
      	</div>
      	
      	
      	<div class="row">
      		<div class="col-md-12 pills">
						<div class="bd-example bd-example-tabs">
							<div class="d-flex justify-content-center">
							  <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">

							    <!--<li class="nav-item">-->
							    <!--  <a class="nav-link active" id="pills-description-tab" data-toggle="pill" href="#pills-description" role="tab" aria-controls="pills-description" aria-expanded="true">Features</a>-->
							    <!--</li>-->
							    <li class="nav-item">
							      <a class="nav-link" id="pills-manufacturer-tab" data-toggle="pill" href="#pills-manufacturer" role="tab" aria-controls="pills-manufacturer" aria-expanded="true"><?php echo e($language['site_word_description']); ?></a>
							    </li>
							    <!--<li class="nav-item">-->
							    <!--  <a class="nav-link" id="pills-review-tab" data-toggle="pill" href="#pills-review" role="tab" aria-controls="pills-review" aria-expanded="true">Review</a>-->
							    <!--</li>-->
							  </ul>
							</div>

						  <div class="tab-content" id="pills-tabContent">
						    <div class="tab-pane fade" id="pills-description" role="tabpanel" aria-labelledby="pills-description-tab">
						    	<div class="row">
						    		<div class="col-md-4">
						    			<ul class="features">
						    				<li class="check"><span class="ion-ios-checkmark"></span>Airconditions</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Child Seat</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>GPS</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Luggage</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Music</li>
						    			</ul>
						    		</div>
						    		<div class="col-md-4">
						    			<ul class="features">
						    				<li class="check"><span class="ion-ios-checkmark"></span>Seat Belt</li>
						    				<li class="remove"><span class="ion-ios-close"></span>Sleeping Bed</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Water</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Bluetooth</li>
						    				<li class="remove"><span class="ion-ios-close"></span>Onboard computer</li>
						    			</ul>
						    		</div>
						    		<div class="col-md-4">
						    			<ul class="features">
						    				<li class="check"><span class="ion-ios-checkmark"></span>Audio input</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Long Term Trips</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Car Kit</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Remote central locking</li>
						    				<li class="check"><span class="ion-ios-checkmark"></span>Climate control</li>
						    			</ul>
						    		</div>
						    	</div>
						    </div>

						    <div class="tab-pane fade show active" id="pills-manufacturer" role="tabpanel" aria-labelledby="pills-manufacturer-tab">
						        <?php if(session('site_lang') == "ar"): ?>
                                <?php echo $item->content_ar; ?>

                                <?php else: ?>
                               <?php echo $item->content_en; ?>

                                <?php endif; ?>
						    </div>

						    <div class="tab-pane fade" id="pills-review" role="tabpanel" aria-labelledby="pills-review-tab">
						      <div class="row">
							   		<div class="col-md-7">
							   			<h3 class="head">23 Reviews</h3>
							   			<div class="review d-flex">
									   		<div class="user-img" style="background-image: url(images/person_1.jpg)"></div>
									   		<div class="desc">
									   			<h4>
									   				<span class="text-left">Jacob Webb</span>
									   				<span class="text-right">14 March 2018</span>
									   			</h4>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
								   					</span>
								   					<span class="text-right"><a href="#" class="reply"><i class="icon-reply"></i></a></span>
									   			</p>
									   			<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrov</p>
									   		</div>
									   	</div>
									   	<div class="review d-flex">
									   		<div class="user-img" style="background-image: url(images/person_2.jpg)"></div>
									   		<div class="desc">
									   			<h4>
									   				<span class="text-left">Jacob Webb</span>
									   				<span class="text-right">14 March 2018</span>
									   			</h4>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
								   					</span>
								   					<span class="text-right"><a href="#" class="reply"><i class="icon-reply"></i></a></span>
									   			</p>
									   			<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrov</p>
									   		</div>
									   	</div>
									   	<div class="review d-flex">
									   		<div class="user-img" style="background-image: url(images/person_3.jpg)"></div>
									   		<div class="desc">
									   			<h4>
									   				<span class="text-left">Jacob Webb</span>
									   				<span class="text-right">14 March 2018</span>
									   			</h4>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
								   					</span>
								   					<span class="text-right"><a href="#" class="reply"><i class="icon-reply"></i></a></span>
									   			</p>
									   			<p>When she reached the first hills of the Italic Mountains, she had a last view back on the skyline of her hometown Bookmarksgrov</p>
									   		</div>
									   	</div>
							   		</div>
							   		<div class="col-md-5">
							   			<div class="rating-wrap">
								   			<h3 class="head">Give a Review</h3>
								   			<div class="wrap">
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(98%)
								   					</span>
								   					<span>20 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(85%)
								   					</span>
								   					<span>10 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(70%)
								   					</span>
								   					<span>5 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(10%)
								   					</span>
								   					<span>0 Reviews</span>
									   			</p>
									   			<p class="star">
									   				<span>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					<i class="ion-ios-star"></i>
									   					(0%)
								   					</span>
								   					<span>0 Reviews</span>
									   			</p>
									   		</div>
								   		</div>
							   		</div>
							   	</div>
						    </div>
						  </div>
						</div>
		      </div>
				</div>
      </div>
    </section>
    

    <section class="ftco-section contact-section">
      <div class="container">
        <div class="row d-flex mb-5 contact-info">
        	
        	<div class="col-md-12 heading-section text-center ftco-animate mb-5">
            <h3 class="mb-2"><?php echo e($language['site_word_book_request_form']); ?></h3>
          </div>
          
       <div class="col-md-12 block-9 mb-md-5">
          <form action="/request/send" class="bg-light p-5 contact-form" method="POST">
              <?php echo e(csrf_field()); ?>

            <input type="hidden" name="car_id" value="<?php echo e($item->id); ?>">
            <div class="form-group d-flex ">
              <input type="text" name="name" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['name']); ?>">
              <input type="email" name="email" required="required" class="form-control" placeholder="<?php echo e($language['site_word_email']); ?>">
            </div>
            <div class="form-group d-flex">
              <input type="phone" name="phone" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_phone']); ?>">
              <input type="number" name="days" min="1" required="required" class="form-control" placeholder="<?php echo e($language['site_word_num_days']); ?>">
            </div>
            <div class="form-group d-flex">
              <input type="text" name="from" required="required" id="book_pick_date" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_pick_up_date']); ?>">
              <input type="text" name="to" required="required" id="book_off_date" class="form-control" placeholder="<?php echo e($language['site_word_drop_off_date']); ?>">
            </div>
            <div class="form-group d-flex">
              <input type="text" name="fplace" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_pick_up_address']); ?>">
              <input type="text" name="tplace" required="required" class="form-control" placeholder="<?php echo e($language['site_word_drop_off_address']); ?>">
            </div>
        
            <div class="form-group justify-content-center row "  >
              <input type="submit" name="web" value="<?php echo e($language['site_word_send_book_request']); ?>" class="btn btn-danger py-3 px-5 mr-auto ml-auto">
               <?php if(!session('user_id')): ?>
              <input type="submit"  name="whats" value="<?php echo e($language['site_word_send_throw_whatsapp']); ?>" class="btn btn-success py-3 px-5 mr-auto ml-auto">
               <?php endif; ?>
            </div>
          </form>
        </div>
          
          
        </div>
       
      </div>
    </section>
    
  
  
    
    <!--<section class="ftco-section ftco-no-pt">-->
    <!--	<div class="container">-->
    <!--		<div class="row justify-content-center">-->
    <!--      <div class="col-md-12 heading-section text-center ftco-animate mb-5">-->
    <!--      	<span class="subheading">Choose Car</span>-->
    <!--        <h2 class="mb-2">Related Cars</h2>-->
    <!--      </div>-->
    <!--    </div>-->
    <!--    <div class="row">-->
    <!--    	<div class="col-md-4">-->
    <!--				<div class="car-wrap rounded ftco-animate">-->
    <!--					<div class="img rounded d-flex align-items-end" style="background-image: url(images/car-1.jpg);">-->
    <!--					</div>-->
    <!--					<div class="text">-->
    <!--						<h2 class="mb-0"><a href="car-single.html">Mercedes Grand Sedan</a></h2>-->
    <!--						<div class="d-flex mb-3">-->
	   <!-- 						<span class="cat">Cheverolet</span>-->
	   <!-- 						<p class="price ml-auto">$500 <span>/day</span></p>-->
    <!--						</div>-->
    <!--						<p class="d-flex mb-0 d-block"><a href="#" class="btn btn-primary py-2 mr-1">Book now</a> <a href="car-single.html" class="btn btn-secondary py-2 ml-1">Details</a></p>-->
    <!--					</div>-->
    <!--				</div>-->
    <!--			</div>-->
    		
    <!--    </div>-->
    <!--	</div>-->
    <!--</section>-->
    
    
  
    

   <footer class="ftco-footer ftco-bg-dark ftco-section">
      <div id="contact" class="container">
        <div class="row mb-5">
          <div class="col-md">
            <div class="ftco-footer-widget mb-4">
              <h2 class="ftco-heading-2"><a href="#" class="logo">
              
                <img src="/public/theme/images/logow.png" style="width: 150px;"></img>
                  </a>
                  </h2>
              <p><?php echo e($language['about_small']); ?></p>
              <ul class="ftco-footer-social list-unstyled float-md-left float-lft mt-5">
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->twitter); ?>"><span class="icon-twitter"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->facebook); ?>"><span class="icon-facebook"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->instagram); ?>"><span class="icon-instagram"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->snapchat); ?>"><span class="icon-snapchat"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->linkedin); ?>"><span class="icon-linkedin"></span></a></li>

              </ul>
            </div>
          </div>
          
          <div class="col-md">
            <div class="ftco-footer-widget mb-4">
            	<h2 class="ftco-heading-2"><?php echo e($language['site_word_have_question']); ?></h2>
            	<div class="block-23 mb-3">
	              <ul>
	                <li><span class="icon icon-map-marker"></span><span class="text"><?php echo e($language['address']); ?></span></li>
	                <li><a href="tel:<?php echo e($site_setting->phone); ?>"><span class="icon icon-phone"></span><span class="text"><?php echo e($site_setting->phone); ?></span></a></li>
	                <li><a target="_blank" href="https://wa.me/<?php echo e($site_setting->whatsapp); ?>"><span class="icon icon-whatsapp"></span><span class="text"><?php echo e($site_setting->whatsapp); ?></span></a></li>
	                <li><a href="mailto:<?php echo e($site_setting->email); ?>"><span class="icon icon-envelope"></span><span class="text"><?php echo e($site_setting->email); ?></span></a></li>
	              </ul>
	            </div>
            </div>
          </div>
        </div>
        <div class="row">
         
          <div class="col-md-12 text-center">

            <p><!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
  <!--
  Copyright &copy;<script>document.write(new Date().getFullYear());</script> All rights reserved | This template is made with <i class="icon-heart color-danger" aria-hidden="true"></i> by <a href="https://colorlib.com" target="_blank">Colorlib</a>
  
  -->
  <!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. --></p>
          </div>
        </div>
      </div>
    </footer>
    
  

  <!-- loader -->
  <div id="ftco-loader" class="show fullscreen"><svg class="circular" width="48px" height="48px"><circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke="#eeeeee"/><circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke-miterlimit="10" stroke="#F96D00"/></svg></div>


    <script src="/public/theme/js/jquery.min.js"></script>
  <script src="/public/theme/js/jquery-migrate-3.0.1.min.js"></script>
  <script src="/public/theme/js/popper.min.js"></script>
  <script src="/public/theme/js/bootstrap.min.js"></script>
  <script src="/public/theme/js/jquery.easing.1.3.js"></script>
  <script src="/public/theme/js/jquery.waypoints.min.js"></script>
  <script src="/public/theme/js/jquery.stellar.min.js"></script>
  <script src="/public/theme/js/owl.carousel.min.js"></script>
  <script src="/public/theme/js/jquery.magnific-popup.min.js"></script>
  <script src="/public/theme/js/aos.js"></script>
  <script src="/public/theme/js/jquery.animateNumber.min.js"></script>
  <script src="/public/theme/js/bootstrap-datepicker.js"></script>
  <script src="/public/theme/js/jquery.timepicker.min.js"></script>
  <script src="/public/theme/js/scrollax.min.js"></script>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBVWaKrjvy3MaE7SQ74_uJiULgl1JY0H2s&sensor=false"></script>
  <script src="/public/theme/js/google-map.js"></script>
  <script src="/public/theme/js/main.js"></script>

  </body>
</html><?php /**PATH /home/afanhttk/public_html/resources/views/theme/carsingle.blade.php ENDPATH**/ ?>