<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo e($language['site_title']); ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Free HTML Templates" name="keywords">
    <meta content="Free HTML Templates" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet"> 

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="public/theme/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="public/theme/css/style.css" rel="stylesheet">
</head>

<div>



    <!-- Navbar Start -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light shadow-sm px-5 py-3 py-lg-0">
        <a href="home" class="navbar-brand p-0">
             <img src="public/admin/images/setting/<?php echo e($site_setting->logo); ?>" alt="EAEL Logo" class="navbar-brand-img" style="height: 5rem;">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
         <div class="collapse navbar-collapse" id="navbarCollapse">
            <div class="navbar-nav ms-auto py-0 me-n3">
                <a href="home" class="nav-item nav-link active">HOME</a>
                <a href="about" class="nav-item nav-link">ABOUT US</a>
                <a href="partner" class="nav-item nav-link">TRAINING PARTNER</a>
                <a href="#" class="nav-item nav-link">CERTIFICATIONS</a>
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">REGISTER</a>
                    <div class="dropdown-menu m-0">
                        <a href="training" class="dropdown-item">Training</a>
                        <a href="center" class="dropdown-item">Training Center</a>
                    </div>
                </div>
                <a href="contact" class="nav-item nav-link">CONTACT US</a>
            </div>
        </div>
    </nav>
    <!-- Navbar End -->


    <!-- Page Header Start -->
    <div class="container-fluid bg-dark p-5" style="background-image: url('public/theme/img/new-4.jpg'); background-size: cover;background-position: top;height: 400px">
        <div class="row" style="margin-top: 150px;">
            <div class="col-12 text-center">
                <h1 class="display-4 text-white">Certification</h1>
                <a href="home">Home</a>
                <i class="far fa-square text-primary px-2"></i>
                <a href="#">Certification</a>
            </div>
        </div>
    </div>
    <!-- Page Header End -->

    <!-- Search End -->
    <div class="container-fluid bg-primary text-secondary p-5">
        <div class="row g-5">
            <div class="col-12 text-center">
                <h1 class="display-5 mb-4">Search For Certifications </h1>
                <form class="mx-auto" style="max-width: 1024px;">
                    <div class="input-group">
                        <input type="text" class="form-control border-white p-3" placeholder="Certification Number">
                        <button class="btn btn-dark px-4">Search</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Search End -->

    <!-- Content Start -->
    <div class="container-fluid py-6 px-5">
        <div class="container">
            <div class="row g-4 h-100 justify-content-center align-items-center mb-4">
               
                <div class="col-lg-12 wow fadeInUp" data-wow-delay="0.3s">
                    <?php echo $language['site_certification']; ?>


                </div>
               
            </div>
        </div>
    </div>
    <!-- Content End -->

    </div>
    <div class="container-fluid bg-dark text-secondary p-5">
        <div class="row g-5">
            <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Quick Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <a class="text-secondary mb-2" href="home"><i class="bi bi-arrow-right text-primary me-2"></i>Home</a>
                    <!--<a class="text-secondary mb-2" href="why"><i class="bi bi-arrow-right text-primary me-2"></i>WHY CHOOSE EAEL?</a>-->
                    <a class="text-secondary mb-2" href="about"><i class="bi bi-arrow-right text-primary me-2"></i>About Us</a>

                </div>
            </div>
             <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Popular Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <!--<a class="text-secondary mb-2" href="policy"><i class="bi bi-arrow-right text-primary me-2"></i>Privacy Policy</a>-->
                    <a class="text-secondary mb-2" href="#"><i class="bi bi-arrow-right text-primary me-2"></i>Certification</a>
                    <a class="text-secondary" href="contact"><i class="bi bi-arrow-right text-primary me-2"></i>Contact Us</a>
                </div>
            </div>
            <!-- <div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Get In Touch</h3>-->
            <!--    <p class="mb-2"><i class="bi bi-geo-alt text-primary me-2"></i><?php echo e($site_setting->address); ?></p>-->
            <!--    <p class="mb-2"><i class="bi bi-envelope-open text-primary me-2"></i><?php echo e($site_setting->email); ?></p>-->
            <!--    <p class="mb-0"><i class="bi bi-telephone text-primary me-2"></i><?php echo e($site_setting->mobile); ?></p>-->
            <!--</div>-->
            <!--<div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Follow Us</h3>-->
            <!--    <div class="d-flex">-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->twitter); ?>"><i class="fab fa-twitter fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->facebook); ?>"><i class="fab fa-facebook-f fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->linkedin); ?>"><i class="fab fa-linkedin-in fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle" href="<?php echo e($site_setting->youtube); ?>"><i class="fab fa-youtube fw-normal"></i></a>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
    </div>
   
    <!-- Footer End -->


    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-circle back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="public/theme/lib/easing/easing.min.js"></script>
    <script src="public/theme/lib/waypoints/waypoints.min.js"></script>
    <script src="public/theme/lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="public/theme/js/main.js"></script>
</body>

</html><?php /**PATH /home/hosakdnx/hosazz.com/eael/resources/views/theme/cert.blade.php ENDPATH**/ ?>