<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo e($language['site_title']); ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="eael" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet"> 

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="public/theme/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="public/theme/css/style.css" rel="stylesheet">
</head>

<div>


    <!-- Navbar Start -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light shadow-sm px-5 py-3 py-lg-0">
        <a href="#" class="navbar-brand p-0">
             <img src="public/admin/images/setting/<?php echo e($site_setting->logo); ?>" alt="EAEL Logo" class="navbar-brand-img" style="height: 5rem;">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarCollapse">
            <div class="navbar-nav ms-auto py-0 me-n3">
                <a href="#" class="nav-item nav-link active">HOME</a>
                <a href="#why" class="nav-item nav-link">WHY CHOOSE EAEL?</a>
                <a href="about" class="nav-item nav-link">ABOUT US</a>
                <a href="partner" class="nav-item nav-link">TRAINING PARTNER</a>
                <a href="certification" class="nav-item nav-link">CERTIFICATIONS</a>
                <a href="#contact" class="nav-item nav-link">CONTACT US</a>
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">REGISTER</a>
                    <div class="dropdown-menu m-0">
                        <a href="training" class="dropdown-item">Training</a>
                        <a href="center" class="dropdown-item">Training Center</a>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <!-- Navbar End -->


    <!-- Carousel Start -->
    <div class="container-fluid p-0">
        <div id="header-carousel" class="carousel slide carousel-fade" data-bs-ride="carousel">
            <div class="carousel-inner">
            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
                <div class="carousel-item <?php if( $loop->index ==0): ?> active <?php endif; ?>">
                    <img class="w-100" src="public/admin/images/slider/<?php echo e($slider->image); ?>" alt="Image">
                    <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                        <div class="p-3" style="max-width: 900px;">
                            <h5 class="text-white text-uppercase"><?php echo e($slider->title); ?></h5>
                            <h1 class="display-1 text-white mb-md-4"> <?php echo $slider->content; ?></h1>
                            <!--<a href="" class="btn btn-primary py-md-3 px-md-5 me-3 rounded-pill">Get Quote</a>-->
                            <!--<a href="" class="btn btn-secondary py-md-3 px-md-5 rounded-pill">Contact Us</a>-->
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#header-carousel"
                data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#header-carousel"
                data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
    </div>
    <!-- Carousel End -->


    <!-- About Start -->
    <div class="container-fluid bg-secondary p-0">
        <div class="row g-0">
            <div class="col-lg-6 py-6 px-5">
                <h1 class="display-5 mb-4">Welcome To <span class="text-primary">EAEL</span></h1>
                <h4 class="text-primary mb-4">We have the Europe's widest range of leadership, management coaching, and Consultants qualifications</h4>
                <p class="mb-4">Since 1990, we have supported Thousands clients. Our consultants and experts have worked with most of Arabic nations and have served organizations in every part of the world, in nearly every industry. EAEL has over 2500 trainers and consultants with deep strategy expertise,. Our leaders and experts engage in multiple knowledge-building efforts each year, developing cutting-edge tools and resources directly applicable to our clients’ needs.</p>
                <a href="#contact" class="btn btn-primary py-md-3 px-md-5 rounded-pill">Get A Call</a>
            </div>
            <div class="col-lg-6">
                <div class="h-100 d-flex flex-column justify-content-center bg-primary p-5">
                    <div class="d-flex text-white mb-5">
                        <div class="d-flex flex-shrink-0 align-items-center justify-content-center bg-white text-primary rounded-circle mx-auto mb-4" style="width: 60px; height: 60px;">
                            <i class="fa fa-chart-line fs-4"></i>
                        </div>
                        <div class="ps-4">
                            <h3>Training and Certification</h3>
                            <p class="mb-0">EAEL offers Certificate and Training provides a broad base of knowledge and skills</p>
                        </div>
                    </div>
                    <div class="d-flex text-white mb-5">
                        <div class="d-flex flex-shrink-0 align-items-center justify-content-center bg-white text-primary rounded-circle mx-auto mb-4" style="width: 60px; height: 60px;">
                            <i class="fa fa-chart-line fs-4"></i>
                        </div>
                        <div class="ps-4">
                            <h3>Leadership and management</h3>
                            <p class="mb-0">EAEL offers Middle East’s broadest and most popular range of leadership and management qualifications</p>
                        </div>
                    </div>
                    <div class="d-flex text-white">
                        <div class="d-flex flex-shrink-0 align-items-center justify-content-center bg-white text-primary rounded-circle mx-auto mb-4" style="width: 60px; height: 60px;">
                            <i class="fa fa-balance-scale fs-4"></i>
                        </div>
                        <div class="ps-4">
                            <h3>Coaching and Mentoring</h3>
                            <p class="mb-0">Coaching is a practical leadership and management discipline that allows managers to unleash potential</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->
    

    <!-- Services Start -->
    <div class="container-fluid pt-6 px-5">
        <div class="text-center mx-auto mb-5" style="max-width: 1024px;">
            <h1 class="display-5 mb-0">Become A EAEL's Member</h1></br>
            <p>When you join us, you become part of a world-renowned professional body. We represent more than 2500 managers, leaders and Trainer – from highly experienced senior executives to aspiring Trainer and those in their first positions. By joining us, you can access services to further your career and get your skills formally recognized with post-nominal letters</p>
            <hr class="w-25 mx-auto bg-primary">
        </div>
        <div class="row g-5">
            <div class="col-lg-4 col-md-6 ">
                <div class="service-item bg-secondary text-center px-5">
                    <div class="d-flex align-items-center justify-content-center bg-primary text-white rounded-circle mx-auto mb-4" style="width: 90px; height: 90px;">
                        <i class="fa fa-user-tie fa-2x"></i>
                    </div>
                    <h3 class="mb-3">Improve your performance</h3>
                    <p class="mb-0">Tap into a wealth of information on the latest management thinking</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-secondary text-center px-5">
                    <div class="d-flex align-items-center justify-content-center bg-primary text-white rounded-circle mx-auto mb-4" style="width: 90px; height: 90px;">
                        <i class="fa fa-chart-pie fa-2x"></i>
                    </div>
                    <h3 class="mb-3">Advance your career</h3>
                    <p class="mb-0">Use our Careers Innovation Centre to capitalize on opportunities</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="service-item bg-secondary text-center px-5">
                    <div class="d-flex align-items-center justify-content-center bg-primary text-white rounded-circle mx-auto mb-4" style="width: 90px; height: 90px;">
                        <i class="fa fa-chart-line fa-2x"></i>
                    </div>
                    <h3 class="mb-3">Build your networks</h3>
                    <p class="mb-0">Share ideas with like-minded professionals at events and online.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 offset-lg-4">
                <div class="service-item bg-secondary text-center px-5">
                    <div class="d-flex align-items-center justify-content-center bg-primary text-white rounded-circle mx-auto mb-4" style="width: 90px; height: 90px;">
                        <i class="fa fa-chart-area fa-2x"></i>
                    </div>
                    <h3 class="mb-3">Recognized as a leader</h3>
                    <p class="mb-0">Use our post-nominal letters to set yourself apart from the crowd.</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Services End -->


    <!-- Features Start -->
    <div id="why" class="container-fluid py-6 px-5">
        <div class="text-center mx-auto mb-5" style="max-width: 600px;">
            <h1 class="display-5 mb-0">EAEL’s Qualifications</h1>
            <hr class="w-25 mx-auto bg-primary">
        </div>
        <div class="row g-5">
            <div class="col-lg-4">
                <div class="row g-5">
                    <div class="col-12">
                      <div class="d-flex align-items-center">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                          <i class="fa fa-user-tie fs-4 text-white"></i>
                        </div>
                        <h3 style="padding-left: 10px;"> Level 2</h3>
                      </div>
                      <p class="mb-0">Certificate in Team Leading, 
Award and Extended Award for Young Leaders, 
Award and Certificate in Effective Team Member Skills, 
Award and Certificate in Leadership and Team Skills, 
Diploma in Team Leading</p>
                    </div>
                     <div class="col-12">
                      <div class="d-flex align-items-center">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                          <i class="fa fa-user-tie fs-4 text-white"></i>
                        </div>
                        <h3 style="padding-left: 10px;"> Level 3</h3>
                      </div>
                      <p class="mb-0">Award, Certificate and Diploma in Leadership and Management, 
Certificate in Effective Management, 
Certificate in Leadership, 
Certificate in Principles of Leadership and Management, 
Diploma in Management</p>
                    </div>
                     <div class="col-12">
                      <div class="d-flex align-items-center">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                          <i class="fa fa-user-tie fs-4 text-white"></i>
                        </div>
                        <h3 style="padding-left: 10px;"> Level 4</h3>
                      </div>
                      <p class="mb-0">Award in Leadership and Management, 
Certificate in Leadership and Management, 
Diploma in Leadership and Management, 
Certificate and Diploma in Principles of Leadership and Management, 
Award in Leadership</p>
                    </div>

                    <!--<div class="col-12">-->
                    <!--    <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">-->
                    <!--        <i class="fa fa-award fs-4 text-white"></i>-->
                    <!--    </div>-->
                    <!--    <h3>Level 4</h3>-->
                    <!--    <p class="mb-0">Magna sea eos sit dolor, ipsum amet ipsum lorem diam dolor eos diam et diam dolor ea</p>-->
                    <!--</div>-->
                </div>
            </div>
            <div class="col-lg-4">
                <div class="d-block bg-primary h-100 text-center">
                    <img class="img-fluid" src="public/theme/img/feature.jpg" alt="">
                    <div class="p-4">
                        <p class="text-white mb-4">EAEL’s leadership and management qualifications help you develop the skills, knowledge and personal abilities you need to succeed.

If you are leading a team for the first time or preparing to step up to senior management, the innovative design of our qualifications means you can fast-track your progression and target training to your precise needs.</p>
                        <a href="cert" class="btn btn-light py-md-3 px-md-5 rounded-pill mb-2">Learn More</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="row g-5">
                    <div class="col-12">
                      <div class="d-flex align-items-center">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                          <i class="fa fa-user-tie fs-4 text-white"></i>
                        </div>
                        <h3 style="padding-left: 10px;"> Level 5</h3>
                      </div>
                      <p class="mb-0">Award, Certificate and Diploma in Leadership and Management, 
Award and Certificate in Leadership, 
Award in Leadership and Management Skills, 
Certificate in Leading with Integrity, 
Diploma in Principles of Leadership and Management </p>
                    </div>
                    <div class="col-12">
                      <div class="d-flex align-items-center">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                          <i class="fa fa-user-tie fs-4 text-white"></i>
                        </div>
                        <h3 style="padding-left: 10px;"> Level 6</h3>
                      </div>
                      <p class="mb-0">Award in Management, 
Certificate in Management</p>
                    </div>
                    <div class="col-12">
                      <div class="d-flex align-items-center">
                        <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                          <i class="fa fa-user-tie fs-4 text-white"></i>
                        </div>
                        <h3 style="padding-left: 10px;"> Level 7</h3>
                      </div>
                      <p class="mb-0">Qualifications in Leadership and Management, 
Diploma in Strategic Management and Leadership</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Features Start -->


    <!-- Quote Start -->
    <div id="contact" class="container-fluid bg-secondary px-0">
        <div class="row g-0">
            <div class="col-lg-6 py-6 px-5">
                <h1 class="display-5 mb-4">Contact For Any Queries</h1>
                <p class="mb-4"> In the past ten years, over thousands managers have trusted EAEL for their management and benefitted from our qualifications or recognized training programs. Benefits of working with EAEL EAEL will benefit your organization in many ways: • Flexible qualifications that can be adapted to suit your business needs • Recognition for your in-house training • Free studying membership with the academy</p>
                <form>
                    <div class="row gx-3">
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-1" placeholder="John Doe">
                                <label for="form-floating-1">Full Name</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating mb-3">
                                <input type="email" class="form-control" id="form-floating-2" placeholder="name@example.com">
                                <label for="form-floating-2">Email address</label>
                            </div>
                        </div>
                         <div class="col-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-1" placeholder="John Doe">
                                <label for="form-floating-1">Mobile Number</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <button class="btn btn-primary w-100 h-100" type="submit">Send A Request</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-lg-6" style="min-height: 400px;">
                <div class="position-relative h-100">
                    <img class="position-absolute w-100 h-100" src="public/theme/img/quote.jpg" style="object-fit: cover;">
                </div>
            </div>
        </div>
    </div>
    <!-- Quote End -->




    <!-- Testimonial Start -->
    <!--<div class="container-fluid bg-secondary p-0">-->
    <!--    <div class="row g-0">-->
    <!--        <div class="col-lg-6" style="min-height: 500px;">-->
    <!--            <div class="position-relative h-100">-->
    <!--                <img class="position-absolute w-100 h-100" src="public/theme/img/testimonial.jpg" style="object-fit: cover;">-->
    <!--            </div>-->
    <!--        </div>-->
    <!--        <div class="col-lg-6 py-6 px-5">-->
    <!--            <h1 class="display-5 mb-4">What Say Our Client!!!</h1>-->
    <!--            <div class="owl-carousel testimonial-carousel">-->
    <!--                <div class="testimonial-item">-->
    <!--                    <p class="fs-4 fw-normal mb-4"><i class="fa fa-quote-left text-primary me-3"></i>Dolores sed duo clita tempor justo dolor et stet lorem kasd labore dolore lorem ipsum. At lorem lorem magna ut et, nonumy et labore et tempor diam tempor erat dolor rebum sit ipsum.</p>-->
    <!--                    <div class="d-flex align-items-center">-->
    <!--                        <img class="img-fluid rounded-circle" src="public/theme/img/testimonial-1.jpg" alt="">-->
    <!--                        <div class="ps-4">-->
    <!--                            <h3>Client Name</h3>-->
    <!--                            <span class="text-uppercase">Profession</span>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--                <div class="testimonial-item">-->
    <!--                    <p class="fs-4 fw-normal mb-4"><i class="fa fa-quote-left text-primary me-3"></i>Dolores sed duo clita tempor justo dolor et stet lorem kasd labore dolore lorem ipsum. At lorem lorem magna ut et, nonumy et labore et tempor diam tempor erat dolor rebum sit ipsum.</p>-->
    <!--                    <div class="d-flex align-items-center">-->
    <!--                        <img class="img-fluid rounded-circle" src="public/theme/img/testimonial-2.jpg" alt="">-->
    <!--                        <div class="ps-4">-->
    <!--                            <h3>Client Name</h3>-->
    <!--                            <span class="text-uppercase">Profession</span>-->
    <!--                        </div>-->
    <!--                    </div>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
    <!-- Testimonial End -->




    <!-- Footer Start -->
    <div class="container-fluid bg-dark text-secondary p-5">
        <div class="row g-5">
            <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Quick Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <a class="text-secondary mb-2" href="#"><i class="bi bi-arrow-right text-primary me-2"></i>Home</a>
                    <!--<a class="text-secondary mb-2" href="why"><i class="bi bi-arrow-right text-primary me-2"></i>WHY CHOOSE EAEL?</a>-->
                    <a class="text-secondary mb-2" href="about"><i class="bi bi-arrow-right text-primary me-2"></i>About Us</a>

                </div>
            </div>
             <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Popular Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <!--<a class="text-secondary mb-2" href="policy"><i class="bi bi-arrow-right text-primary me-2"></i>Privacy Policy</a>-->
                    <a class="text-secondary mb-2" href="certification"><i class="bi bi-arrow-right text-primary me-2"></i>Certification</a>
                    <a class="text-secondary" href="contact"><i class="bi bi-arrow-right text-primary me-2"></i>Contact Us</a>
                </div>
            </div>
            <!--<div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Get In Touch</h3>-->
            <!--    <p class="mb-2"><i class="bi bi-geo-alt text-primary me-2"></i><?php echo e($site_setting->address); ?></p>-->
            <!--    <p class="mb-2"><i class="bi bi-envelope-open text-primary me-2"></i><?php echo e($site_setting->email); ?></p>-->
            <!--    <p class="mb-0"><i class="bi bi-telephone text-primary me-2"></i><?php echo e($site_setting->mobile); ?></p>-->
            <!--</div>-->
            <!--<div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Follow Us</h3>-->
            <!--    <div class="d-flex">-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->twitter); ?>"><i class="fab fa-twitter fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->facebook); ?>"><i class="fab fa-facebook-f fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->linkedin); ?>"><i class="fab fa-linkedin-in fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle" href="<?php echo e($site_setting->youtube); ?>"><i class="fab fa-youtube fw-normal"></i></a>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
    </div>
  
    <!-- Footer End -->


    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-circle back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="public/theme/lib/easing/easing.min.js"></script>
    <script src="public/theme/lib/waypoints/waypoints.min.js"></script>
    <script src="public/theme/lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="public/theme/js/main.js"></script>
</body>

</html><?php /**PATH /home/hosakdnx/hosazz.com/eael/resources/views/theme/index.blade.php ENDPATH**/ ?>