<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo e($language['site_title']); ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="Free HTML Templates" name="keywords">
    <meta content="Free HTML Templates" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@500;600;700&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet"> 

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="public/theme/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="public/theme/css/style.css" rel="stylesheet">
</head>

<div>



    <!-- Navbar Start -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light shadow-sm px-5 py-3 py-lg-0">
        <a href="home" class="navbar-brand p-0">
             <img src="public/admin/images/setting/<?php echo e($site_setting->logo); ?>" alt="EAEL Logo" class="navbar-brand-img" style="height: 5rem;">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarCollapse">
            <div class="navbar-nav ms-auto py-0 me-n3">
                <a href="home" class="nav-item nav-link active">HOME</a>
                <a href="about" class="nav-item nav-link">ABOUT US</a>
                <a href="partner" class="nav-item nav-link">TRAINING PARTNER</a>
                <a href="certification" class="nav-item nav-link">CERTIFICATIONS</a>
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">REGISTER</a>
                    <div class="dropdown-menu m-0">
                        <a href="training" class="dropdown-item">Training</a>
                        <a href="center" class="dropdown-item">Training Center</a>
                    </div>
                </div>
                <a href="#" class="nav-item nav-link">CONTACT US</a>
            </div>
        </div>
    </nav>
    <!-- Navbar End -->


    <!-- Page Header Start -->
    <div class="container-fluid bg-dark p-5">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="display-4 text-white">Contact Us</h1>
                <a href="home">Home</a>
                <i class="far fa-square text-primary px-2"></i>
                <a href="#">Contact Us</a>
            </div>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- Contact Start -->
    <div class="container-fluid bg-secondary px-0">
        <div class="row g-0">
            <div class="col-lg-6 py-6 px-5">
                <h1 class="display-5 mb-4">Contact For Any Queries</h1>
                <form>
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-1" placeholder="John Doe">
                                <label for="form-floating-1">Full Name</label>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-floating">
                                <input type="email" class="form-control" id="form-floating-2" placeholder="name@example.com">
                                <label for="form-floating-2">Email address</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-floating">
                                <input type="text" class="form-control" id="form-floating-3" placeholder="Subject">
                                <label for="form-floating-3">Subject</label>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-floating">
                                <textarea class="form-control" placeholder="Message" id="form-floating-4" style="height: 150px"></textarea>
                                <label for="form-floating-4">Message</label>
                              </div>
                        </div>
                        <div class="col-12">
                            <button class="btn btn-primary w-100 py-3" type="submit">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-lg-6" style="min-height: 400px;">
                <div class="position-relative h-100">
                    <iframe class="position-relative w-100 h-100"
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3001156.4288297426!2d-78.01371936852176!3d42.72876761954724!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4ccc4bf0f123a5a9%3A0xddcfc6c1de189567!2sNew%20York%2C%20USA!5e0!3m2!1sen!2sbd!4v1603794290143!5m2!1sen!2sbd"
                        frameborder="0" style="border:0;" allowfullscreen="" aria-hidden="false" tabindex="0"></iframe>
                </div>
            </div>
        </div>
    </div>
    <!-- Contact End -->

    </div>
    <div class="container-fluid bg-dark text-secondary p-5">
        <div class="row g-5">
            <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Quick Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <a class="text-secondary mb-2" href="home"><i class="bi bi-arrow-right text-primary me-2"></i>Home</a>
                    <!--<a class="text-secondary mb-2" href="why"><i class="bi bi-arrow-right text-primary me-2"></i>WHY CHOOSE EAEL?</a>-->
                    <a class="text-secondary mb-2" href="about"><i class="bi bi-arrow-right text-primary me-2"></i>About Us</a>

                </div>
            </div>
             <div class="col-lg-3 col-md-6">
                <h3 class="text-white mb-4">Popular Links</h3>
                <div class="d-flex flex-column justify-content-start">
                    <!--<a class="text-secondary mb-2" href="policy"><i class="bi bi-arrow-right text-primary me-2"></i>Privacy Policy</a>-->
                    <a class="text-secondary mb-2" href="certification"><i class="bi bi-arrow-right text-primary me-2"></i>Certification</a>
                    <a class="text-secondary" href="#"><i class="bi bi-arrow-right text-primary me-2"></i>Contact Us</a>
                </div>
            </div>
            <!-- <div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Get In Touch</h3>-->
            <!--    <p class="mb-2"><i class="bi bi-geo-alt text-primary me-2"></i><?php echo e($site_setting->address); ?></p>-->
            <!--    <p class="mb-2"><i class="bi bi-envelope-open text-primary me-2"></i><?php echo e($site_setting->email); ?></p>-->
            <!--    <p class="mb-0"><i class="bi bi-telephone text-primary me-2"></i><?php echo e($site_setting->mobile); ?></p>-->
            <!--</div>-->
            <!--<div class="col-lg-3 col-md-6">-->
            <!--    <h3 class="text-white mb-4">Follow Us</h3>-->
            <!--    <div class="d-flex">-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->twitter); ?>"><i class="fab fa-twitter fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->facebook); ?>"><i class="fab fa-facebook-f fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle me-2" href="<?php echo e($site_setting->linkedin); ?>"><i class="fab fa-linkedin-in fw-normal"></i></a>-->
            <!--        <a class="btn btn-lg btn-primary btn-lg-square rounded-circle" href="<?php echo e($site_setting->youtube); ?>"><i class="fab fa-youtube fw-normal"></i></a>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
    </div>
   
    <!-- Footer End -->


    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-circle back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="public/theme/lib/easing/easing.min.js"></script>
    <script src="public/theme/lib/waypoints/waypoints.min.js"></script>
    <script src="public/theme/lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="public/theme/js/main.js"></script>
</body>

</html><?php /**PATH /home/hosakdnx/hosazz.com/eael/resources/views/theme/contact.blade.php ENDPATH**/ ?>