<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MessageController extends Controller {
//teacher to admin 1
//student to admin 2
//admin to teacher 3
//admin to student 4
//admin to fees 5
//teacher to fees 6

    public function index() {
            $data['menu_name'] = "message";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Message::orderBy('created_at', 'desc')->get();
            return View('admin.message.index', $data);
    }
    
     public function indexType($type) {
            $data['menu_name'] = "message";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Message::where('type', $type)->orderBy('created_at', 'desc')->get();
            $data['type'] = $type;
            return View('admin.message.index', $data);
    }
    
     public function fees() {
            $data['menu_name'] = "message";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Message::where('type', 5)->where('action','<>',"")->orderBy('created_at', 'desc')->get();
            return View('admin.message.fees', $data);
    }

    public function create($type) {
            $data['menu_name'] = "message";
            $data = DashboardController::layout($data);
            $data['sid'] = $type;
            return View('admin.message.create', $data);
    }
    
    public function feesCreate() {
            $data['menu_name'] = "message";
            $data = DashboardController::layout($data);
            return View('admin.message.fcreate', $data);
    }

   public function store(Request $request,$sid) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'type' => 'required'
            ];
            $niceNames = [
                'title' => 'title',
                'content' => 'content ',
                'type' =>'type'
            ];
            $this->validate($request, $rules, [], $niceNames);

            if( $request->type==4){
                 $users = \App\Customer::where('type',2)->get();
                $registrationIds =  array();
                foreach(  $users as $user){
                   $registrationIds[] = $user->ftoken;
                    $item = new \App\Message;
        
                    $item->title = $request->title;
                    $item->message = $request->content;
                    $item->info = $request->info ? $request->info : "";
                    $item->type = 4;
                    $item->target_id = $user->id;
                    $item->save();
                }
            }else if( $request->type==3){
                 $teachers = \App\Customer::where('type',1)->get();
                $registrationIds =  array();
                foreach(  $teachers as $teacher){
                   $registrationIds[] = $teacher->ftoken;
                    $item = new \App\Message;
        
                    $item->title = $request->title;
                    $item->message = $request->content;
                    $item->info = $request->info ? $request->info : "";
                    $item->type = 3;
                    $item->target_id = $teacher->id;
                    $item->save();
                }
            }else if( $request->type==2){
                   $customers = \App\Customer::all();
                $registrationIds =  array();
                foreach(  $customers as $customer){
                   $registrationIds[] = $customer->ftoken;
                    $item = new \App\Message;
        
                    $item->title = $request->title;
                    $item->message = $request->content;
                    $item->info = $request->info ? $request->info : "";
                    $item->type = $customer->type + 2;
                    $item->target_id = $customer->id;
                    $item->save();
                }
            }
            
           $this->pushNotification($request->title,$request->content,$registrationIds);
            return \Redirect::to('admin/message/all/'.$sid)->with('message', 'Added Successfully');
      
    }
    
    public function storeFees(Request $request){
          $rules = [
                'title' => 'required',
                'content' => 'required',
            ];
            $niceNames = [
                'title' => 'title',
                'content' => 'content ',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $teachers = \App\Customer::where('type',1)->get();
                $registrationIds =  array();
                foreach(  $teachers as $teacher){
                   $registrationIds[] = $teacher->ftoken;
                    $item = new \App\Message;
        
                    $item->title = $request->title;
                    $item->message = $request->content;
                    $item->type = 5;
                    $item->target_id = $teacher->id;
                    $item->save();
                }
            
           $this->pushNotification($request->title,$request->content,$registrationIds);

            return \Redirect::to('admin/message/fees')->with('message', 'Added Successfully');
      
        
    }

    public function edit($id) {
            $data['menu_name'] = "message";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Message::find($id);
            return View('admin.message.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'order' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Message::find($id);
            
            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;
            
            $item->save();
            return \Redirect::to('admin/message/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Message::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }
    
     public static function pushNotification($title,$body,$registrationIds)
     {
         #API access key from Google API's Console
         //  $registrationIds = $tokens;
 
         #prep the bundle
         $data = [
             'title' => $title,
             'body' => $body,
             'type' => 'urgent'
         ];
 
 
         $fields = [
            //  'to' => '/topics/azabAndroid',
            //   'to' => $idtoken,
              'registration_ids'  => $registrationIds,
            //     'notification'      => $data,
             'data' => $data,
             'sound' => 'activated',
             'content_available' => true,
             'priority' => 'high',
         ];

         $headers = [
             'Authorization: key=AAAAaHXcckg:APA91bEojwzLEuOZZI9F7NG2b9G6sSrpS7-kfT7rjuIKBS--obx6ZKh2AH689Dd-kJ5_LhwzdN4wN8ZCA1JHQkCPGkeSemp07-2HD9aO-IHKOtsRl1_Ef4dmH-SncUOE5eRRFDHROc87',
             'Content-Type: application/json'
         ];
 
         // return $fields;
         #Send Response To FireBase Server
         $ch = curl_init();
         curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
         curl_setopt($ch, CURLOPT_POST, true);
         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
         curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
         $result = curl_exec($ch);
         curl_close($ch);
         #Echo Result Of FireBase Server
         return $result;
 
     }

}
