<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class OrderController extends Controller {

    public function index() {
            $data['menu_name'] = "order";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Order::orderBy('created_at', 'desc')->get();

            return View('admin.order.index', $data);
        
    }

    public function create() {
            $data['menu_name'] = "project";
            $data = DashboardController::layout($data);
            return View('admin.challenge.create', $data);
        
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'image' => 'required',
                'order' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'image' => 'image ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Challenge;

            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;

            $destination = base_path('public/admin/images/challenge/'); // your upload folder
            $image = $request->file('image');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/challenge/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "challenge";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Challenge::find($id);
            return View('admin.challenge.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'order' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'order' => 'order'
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Challenge::find($id);
            if ($request->hasFile('image')) {
                $destination = base_path('public/admin/images/challenge/'); // your upload folder
                $image = $request->file('image');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;
            
            $item->save();
            return \Redirect::to('admin/challenge/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Order::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
