<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SectionController extends Controller {

    public function index() {
            $data['menu_name'] = "section";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Section::orderBy('order', 'asc')->get();

            return View('admin.section.index', $data);
       
    }

  
    public function edit($id) {
            $data['menu_name'] = "section";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Section::find($id);
            return View('admin.section.edit', $data);
      
    }

    public function update($id, Request $request) {
            $rules = [
                'certificates_title' => 'required',
                'profile_title' => 'required',
                'licenecs_title' => 'required',
                'certificates_date' => 'required',
                'profile_date' => 'required',
                'licenecs_date' => 'required',
                'why_us_content' => 'required',
                'our_team_title' => 'required',
                'our_team_content' => 'required',
                'client_content' => 'required',
                'services_title' => 'required',
                'story_content' => 'required',
                'address_content' => 'required',
                'learn_title' => 'required',
                'learn_sub_title' => 'required',
                'learn_content' => 'required',
                'pdf_link' => 'required',

            ];
            $niceNames = [
                'certificates_title' => 'certificates_title',
                'profile_title' => 'profile_title',
                'licenecs_title' => 'licenecs_title',
                'certificates_date' => 'certificates_date',
                'profile_date' => 'profile_date',
                'licenecs_date' => 'licenecs_date',
                'why_us_content' => 'why_us_content',
                'our_team_title' => 'our_team_title',
                'our_team_content' => 'our_team_content',
                'client_content' => 'client_content',
                'services_title' => 'services_title',
                'story_content' => 'story_content',
                'address_content' => 'address_content',
                'story_img_1' => 'story_img_1',
                'story_img_2' => 'story_img_2',
                'learn_title' => 'learn_title',
                'learn_sub_title' => 'learn_sub_title',
                'learn_content' => 'learn_content',
                'learn_img' => 'learn_img',
                'pdf_link' => 'pdf_link',

            ];
            $this->validate($request, $rules, [], $niceNames);
            $item = \App\Section::find($id);
            
            if ($request->hasFile('story_img_1')) {
                $destination = base_path('public/admin/images/sections/'); // your upload folder
                $image = $request->file('story_img_1');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->story_img_1 = $filename;
            }
             if ($request->hasFile('story_img_2')) {
                $destination = base_path('public/admin/images/sections/'); // your upload folder
                $image = $request->file('story_img_2');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->story_img_2 = $filename;
            }
             if ($request->hasFile('learn_img')) {
                $destination = base_path('public/admin/images/sections/'); // your upload folder
                $image = $request->file('learn_img');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->learn_img = $filename;
            }
             if ($request->hasFile('pdf_link')) {
                $destination = base_path('public/admin/images/sections/'); // your upload folder
                $image = $request->file('pdf_link');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->pdf_link = $filename;
            }
            $item->certificates_title = $request->certificates_title;
            $item->profile_title = $request->profile_title;
            $item->licenecs_title = $request->licenecs_title;
            $item->certificates_date = $request->certificates_date;
            $item->profile_date = $request->profile_date;
            $item->licenecs_date = $request->licenecs_date;
            $item->why_us_content = $request->why_us_content;
            $item->our_team_title = $request->our_team_title;
            $item->our_team_content = $request->our_team_content;
            $item->client_content = $request->client_content;
            $item->services_title = $request->services_title;
            $item->story_content = $request->story_content;
            $item->address_content = $request->address_content;
            $item->learn_title = $request->learn_title;
            $item->learn_sub_title = $request->learn_sub_title;
            $item->learn_content = $request->learn_content;


            $item->save();
            return \Redirect::to('admin/sections/edit/'.$id)->with('message', 'Updated Successfully');
       
    }

    // public function delete($id) {
    //         $category = \App\Category::find($id);
    //         $category->delete();
    //         return \Redirect::back()->with('message', 'لقد تم الحذف بنجاح');
       
    // }

}
