<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;

class UserController extends Controller {

    public function index() {
        if (\Sentinel::hasAccess('view.users')) {
            $data['menu_name'] = "admin_user";
            $data = DashboardController::layout($data);
            $data['users'] = \Sentinel::getUserRepository()->get();

            return View('admin.user.index', $data);
        } else {
            echo 'you donot have permission to access this';
        }
    }

    public function create() {
        if (\Sentinel::hasAccess('create.user')) {
            $data['menu_name'] = "admin_user";
            $data = DashboardController::layout($data);
            $data['groups'] = \Sentinel::getRoleRepository()->get();
            return View('admin.user.create', $data);
        } else {
            echo 'you donot have permission to access this';
        }
    }

    public function store(Request $request) {
        if (\Sentinel::hasAnyAccess(['create.user'])) {
            $rules = [
                'email' => 'email|unique:users',
            ];
            $niceNames = [
                'email' => 'البريد الالكترونى',
            ];
            $this->validate($request, $rules, [], $niceNames);
            $first_name = $request->first_name;
            $last_name = $request->last_name;
            $email = $request->email;
            $group_id = 1;
            $password = $request->password;
            $credentials = [
                'email' => $email,
                'password' => $password,
                'first_name' => $first_name,
                'last_name' => $last_name,
            ];

            $user = \Sentinel::registerAndActivate($credentials);
            $role = \Sentinel::findRoleById($group_id);

            $role->users()->attach($user);

            return \Redirect::to('admin/user/all');
        } else {
            echo 'لا تملك الصالحيه للدخول لهذه الصفحه';
        }
    }

    public function edit($id) {
        if (\Sentinel::hasAnyAccess('update.user')) {
            $data['menu_name'] = "admin_user";
            $data = DashboardController::layout($data);
            $user_role=\Sentinel::findById($id)->roles()->get();
            foreach($user_role as $role){
               $data['group_id']=$role->id;
                
            }
            $data['users'] = \Sentinel::findById($id);
            $data['groups'] = \Sentinel::getRoleRepository()->get();
            return View('admin.user.edit', $data);
        } else {
            echo "لا تملك صلاحيه للدخول الى هذه الصفحة";
        }
    }

    public function update($id, Request $request) {
        if (\Sentinel::hasAnyAccess('update.user')) {
            $user = \Sentinel::findById($id);
            $first_name = $request->first_name;
            $last_name = $request->last_name;
            $email = $request->email;
            $group_id = 1;
            $password = $request->password;
            $removed_id=$request->removed_id;
            if ($password) {
                $credentials = [
                    'email' => $email,
                    'password' => $password,
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                ];
            } else {
                $credentials = [
                    'email' => $email,
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                ];
            }


            $user = \Sentinel::update($user, $credentials);
            $role = \Sentinel::findRoleById($removed_id);

            $role->users()->detach($user);
            
            $new_role=\Sentinel::findRoleById($group_id);
            $new_role->users()->attach($user);
            
            return \Redirect::to('admin/user/all');
        } else {
            echo "لا تملك صلاحيه للدخول الى هذه الصفحة";
        }
    }

    public function delete($id) {
        if (\Sentinel::hasAnyAccess('delete.user')) {
            $user = \Sentinel::findById($id);
            $user_role=\Sentinel::findById($id)->roles()->get();
            foreach($user_role as $role){
               $removed_id=$role->id;
                
            }
            $role = \Sentinel::findRoleById($removed_id);

            $role->users()->detach($user);
            
            $user->delete();
            return \Redirect::back()->with('message', 'sucess delete user');
        } else {
            echo "لا تملك صلاحيه للدخول الى هذه الصفحة";
        }
    }
    
     public function profile() {
        $data['menu_name'] = "profile";
        $data = DashboardController::layout($data);
        $data['users'] = \Sentinel::getUser();
        //print_r($user);
        
        return View('admin.user.profile',$data);
    }
    
     public function updateProfile($id, Request $request) {
       
            $user = \Sentinel::findById($id);
            $first_name = $request->first_name;
            $last_name = $request->last_name;
            $email = $request->email;
            
            $password = $request->password;
          
            if ($password) {
                $credentials = [
                    'email' => $email,
                    'password' => $password,
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                ];
            } else {
                $credentials = [
                    'email' => $email,
                    'first_name' => $first_name,
                    'last_name' => $last_name,
                ];
            }


            $user = \Sentinel::update($user, $credentials);
           

            return \Redirect::back()->with('message','تم التعديل بنجاح');
        
    }


}
