<!DOCTYPE html>
<html lang="en">
  <head>
    <title><?php echo e($language['site_title']); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <link href="https://fonts.googleapis.com/css?family=Poppins:200,300,400,500,600,700,800&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lipis/flag-icons@6.11.0/css/flag-icons.min.css"/>
    <link rel="stylesheet" href="/public/theme/css/open-iconic-bootstrap.min.css">
    <link rel="stylesheet" href="/public/theme/css/animate.css">
    
    <link rel="stylesheet" href="/public/theme/css/owl.carousel.min.css">
    <link rel="stylesheet" href="/public/theme/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="/public/theme/css/magnific-popup.css">

    <link rel="stylesheet" href="/public/theme/css/aos.css">
 
    <link rel="stylesheet" href="/public/theme/css/ionicons.min.css">

    <!--<link rel="stylesheet" href="public/theme/css/bootstrap-datepicker.css">-->
    <link rel="stylesheet" href="/public/theme/css/jquery.timepicker.css">

    
    <link rel="stylesheet" href="/public/theme/css/flaticon.css">
    <link rel="stylesheet" href="/public/theme/css/icomoon.css">
     <?php if(session('site_lang') == "ar"): ?>
        <link rel="stylesheet" href="/public/theme/css/styleAr.css">
        <link rel="stylesheet" href="/public/theme/css/bootstrap-datepickerAr.css">
    <?php else: ?>
        <link rel="stylesheet" href="/public/theme/css/styleEn.css">
        <link rel="stylesheet" href="/public/theme/css/bootstrap-datepickerEn.css">
    <?php endif; ?>
    
  </head>
  <body>
        <?php echo $__env->make('common.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	  <nav class="navbar navbar-expand-lg navbar-dark ftco_navbar bg-dark ftco-navbar-light" id="ftco-navbar">
	    <div class="container">
	      <a class="navbar-brand" href="/">
	          
               <img src="/public/theme/images/logo2.png" style="width: 150px;"></img>
               </a>
	      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#ftco-nav" aria-controls="ftco-nav" aria-expanded="false" aria-label="Toggle navigation">
	        <span class="oi oi-menu"></span> 
	      </button>

	      <div class="collapse navbar-collapse" id="ftco-nav">
	        <ul class="navbar-nav ml-auto">
	          <li class="nav-item"><a href="/" class="nav-link"><?php echo e($language['site_word_home']); ?></a></li>
	          <li class="nav-item"><a href="/about" class="nav-link"><?php echo e($language['site_word_about']); ?></a></li>
	          <li class="nav-item"><a href="/cars" class="nav-link"><?php echo e($language['site_word_cars']); ?></a></li>
	          <li class="nav-item"><a href="/contact" class="nav-link"><?php echo e($language['site_word_contact']); ?></a></li>
	          <li class="nav-item active"><a href="#" class="nav-link"><?php echo e($language['site_word_login']); ?></a></li>
	        </ul>
	        
	        <div class="dropdown">
                <a class="dropdown-toggle" href="#" id="Dropdown" role="button" data-mdb-toggle="dropdown" aria-expanded="false">
                    <i></i>
                    <?php if(session('site_lang') == "ar"): ?>
                    <img src="/public/ae.svg" style="width: 25px;" ></img>
                    <?php else: ?>
                    <img src="/public/um.svg" style="width: 25px;" ></img>
                    <?php endif; ?>
                </a>
            
                <ul class="dropdown-menu" aria-labelledby="Dropdown">
                    <li>
                        <a class="dropdown-item" href="/lang/en"><i><img src="/public/um.svg" style="width: 25px" ></img></i> <?php echo e($language['english']); ?> <i class="fa fa-check text-success ms-2"></i></a>
                    </li>
                    <li><hr class="dropdown-divider" /></li>
                    <li>
                        <a class="dropdown-item" href="/lang/ar"><i><img src="/public/ae.svg" style="width: 25px" ></img></i> <?php echo e($language['arabic']); ?></a>
                    </li>
                 
                
                </ul>
            </div>
	        
	      </div>
	    </div>
	  </nav>
    <!-- END nav -->
    
    <section class="hero-wrap hero-wrap-2 js-fullheight" style="background-image: url('/public/theme/images/bg_3.jpg');" data-stellar-background-ratio="0.5">
      <div class="overlay"></div>
      <div class="container">
        <div class="row no-gutters slider-text js-fullheight align-items-end justify-content-start">
          <div class="col-md-9 ftco-animate pb-5">
          	<p class="breadcrumbs"><span class="mr-2"><a href="/"><?php echo e($language['site_word_home']); ?> <i class="ion-ios-arrow-forward"></i></a></span> <span><?php echo e($language['site_word_profile']); ?> <i class="ion-ios-arrow-forward"></i></span></p>
            <h1 class="mb-3 bread"></h1>
          </div>
        </div>
      </div>
    </section>
		


    <section class="ftco-section contact-section">
      <div class="container">
        <div class="row d-flex mb-5 contact-info">
        	
        <div class="col-md-6 block-9 mb-md-5">
            <form action="/signup" class="bg-light p-5 contact-form" method="POST">
                    <?php echo e(csrf_field()); ?>

              <div class="form-group">
                <input type="text" name="name" required="required" class="form-control" placeholder="<?php echo e($language['name']); ?>" value="<?php echo e(old('name')); ?>">
              </div>
              <div class="form-group">
                <input type="text" name="email" required="required" class="form-control" placeholder="<?php echo e($language['site_word_email']); ?>" value="<?php echo e(old('email')); ?>">
              </div>
              <div class="form-group">
                <input type="password" name="password" required="required" class="form-control" placeholder="<?php echo e($language['password']); ?>" value="<?php echo e(old('password')); ?>">
              </div>
              <div class="form-group">
                <input type="text" name="phone" required="required" class="form-control" placeholder="<?php echo e($language['site_word_phone']); ?>" value="<?php echo e(old('phone')); ?>">
              </div>
               <div class="form-group">
                <input type="text" name="address" required="required" class="form-control" placeholder="<?php echo e($language['site_word_address']); ?>" value="<?php echo e(old('address')); ?>">
              </div>
            
              <div class="form-group">
                <input type="submit" value="<?php echo e($language['site_word_create_account']); ?>" class="btn btn-primary py-3 px-5">
              </div>
            </form>
          
          </div> 
          
          <div class="col-md-6 block-9 mb-md-5">
            <form action="/signin" class="bg-light p-5 contact-form" method="POST">
                                  <?php echo e(csrf_field()); ?>

              <div class="form-group">
                <input type="text"  name="email" required="required" class="form-control" placeholder="Your Email/Your Mobile" value="<?php echo e(old('email')); ?>">
              </div>
              <div class="form-group">
                <input type="password" name="password" required="required" class="form-control" placeholder="Password" value="<?php echo e(old('password')); ?>">
              </div>
              
              <div class="form-group">
                <input type="submit" value="<?php echo e($language['site_word_login']); ?>" class="btn btn-primary py-3 px-5">
              </div>
            </form>
          
          </div>
        </div>
       
      </div>
    </section>

	


   <footer class="ftco-footer ftco-bg-dark ftco-section">
      <div id="contact" class="container">
        <div class="row mb-5">
          <div class="col-md">
            <div class="ftco-footer-widget mb-4">
              <h2 class="ftco-heading-2"><a href="#" class="logo">
              
                <img src="/public/theme/images/logow.png" style="width: 150px;"></img>
                  </a>
                  </h2>
              <p><?php echo e($language['about_small']); ?></p>
              <ul class="ftco-footer-social list-unstyled float-md-left float-lft mt-5">
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->twitter); ?>"><span class="icon-twitter"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->facebook); ?>"><span class="icon-facebook"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->instagram); ?>"><span class="icon-instagram"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->snapchat); ?>"><span class="icon-snapchat"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->linkedin); ?>"><span class="icon-linkedin"></span></a></li>

              </ul>
            </div>
          </div>
          
          <div class="col-md">
            <div class="ftco-footer-widget mb-4">
            	<h2 class="ftco-heading-2"><?php echo e($language['site_word_have_question']); ?></h2>
            	<div class="block-23 mb-3">
	              <ul>
	                <li><span class="icon icon-map-marker"></span><span class="text"><?php echo e($language['address']); ?></span></li>
	                <li><a href="tel:<?php echo e($site_setting->phone); ?>"><span class="icon icon-phone"></span><span class="text"><?php echo e($site_setting->phone); ?></span></a></li>
	                <li><a target="_blank" href="https://wa.me/<?php echo e($site_setting->whatsapp); ?>"><span class="icon icon-whatsapp"></span><span class="text"><?php echo e($site_setting->whatsapp); ?></span></a></li>
	                <li><a href="mailto:<?php echo e($site_setting->email); ?>"><span class="icon icon-envelope"></span><span class="text"><?php echo e($site_setting->email); ?></span></a></li>
	              </ul>
	            </div>
            </div>
          </div>
        </div>
        <div class="row">
         
          <div class="col-md-12 text-center">

            <p><!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
  <!--
  Copyright &copy;<script>document.write(new Date().getFullYear());</script> All rights reserved | This template is made with <i class="icon-heart color-danger" aria-hidden="true"></i> by <a href="https://colorlib.com" target="_blank">Colorlib</a>
  
  -->
  <!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. --></p>
          </div>
        </div>
      </div>
    </footer>
    
  

  <!-- loader -->
  <div id="ftco-loader" class="show fullscreen"><svg class="circular" width="48px" height="48px"><circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke="#eeeeee"/><circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke-miterlimit="10" stroke="#F96D00"/></svg></div>


    <script src="/public/theme/js/jquery.min.js"></script>
  <script src="/public/theme/js/jquery-migrate-3.0.1.min.js"></script>
  <script src="/public/theme/js/popper.min.js"></script>
  <script src="/public/theme/js/bootstrap.min.js"></script>
  <script src="/public/theme/js/jquery.easing.1.3.js"></script>
  <script src="/public/theme/js/jquery.waypoints.min.js"></script>
  <script src="/public/theme/js/jquery.stellar.min.js"></script>
  <script src="/public/theme/js/owl.carousel.min.js"></script>
  <script src="/public/theme/js/jquery.magnific-popup.min.js"></script>
  <script src="/public/theme/js/aos.js"></script>
  <script src="/public/theme/js/jquery.animateNumber.min.js"></script>
  <script src="/public/theme/js/bootstrap-datepicker.js"></script>
  <script src="/public/theme/js/jquery.timepicker.min.js"></script>
  <script src="/public/theme/js/scrollax.min.js"></script>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBVWaKrjvy3MaE7SQ74_uJiULgl1JY0H2s&sensor=false"></script>
  <script src="/public/theme/js/google-map.js"></script>
  <script src="/public/theme/js/main.js"></script>
    
  </body>
</html><?php /**PATH /home/afanhttk/public_html/resources/views/theme/login.blade.php ENDPATH**/ ?>