<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AppointmentType;
use Illuminate\Http\Request;

class AppointmentTypesController extends Controller
{
    public function index()
    {
        $appointment_types = AppointmentType::get();
        return view('new_admin.appointment_types.list', compact('appointment_types'));
    }

    public function update(Request $request)
    {
        foreach ($request->is_active as $key => $value) {
            AppointmentType::where('name', $key)->update(
                [
                    'is_active' => $value
                ]
            );
        }
        foreach ($request->display_name as $key => $value) {
            AppointmentType::where('name', $key)->update(
                [
                    'display_name' => $value
                ]
            );
        }
        $notify[] = ['success', 'Appointment Types Have been updated'];
        return redirect()->route('admin.appointment_types.list')->withNotify($notify);
    }
}
