<?php

namespace App\Http\Controllers\Front;

use App\Events\MessageSent;
use App\Events\MessageTyping;
use App\Events\MessageSeen;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Message;
use App\Models\User;
use Illuminate\Support\Facades\Validator;

class ChatController extends Controller
{
    public function fetchMessages(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'receiver_id' => 'required',
            'sender_id' => 'required',
            'appointment_id' => 'required'
        ]);
        if ($validator->fails()) {

            $obj = ["Status" => false, "success" => 0, "errors" => $validator->errors()];
            return response()->json($obj);
        }
        $token = "123";
        if ($request->token == $token) {
            $receiver = $request->receiver_id;
            $sender = $request->sender_id;
            // session('')
            $messages = Message::where('appointment_id', $request->appointment_id)->where(function ($q) use ($request) {

                $q->orWhere('sender_id', $request->sender_id);
                $q->orWhere('receiver_id', $request->sender_id);
            })->where(function ($q) use ($request) {

                $q->orWhere('sender_id', $request->receiver_id);
                $q->orWhere('receiver_id', $request->receiver_id);
            })->get();

            $obj = ["Status" => true, "success" => 1, "data" => ["messages" => $messages], "msg" => "Successfully got  Messages"];

            return response()->json($obj);
        }
        $obj = ["Status" => false, "success" => 0, "msg" => "Token Incorrect"];
        return response()->json($obj);
    }
    public function sendMessage(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'receiver_id' => 'required',
            'sender_id' => 'required',
            // 'message' => 'required|string'
            'appointment_id' => 'required'
        ]);

        if ($validator->fails()) {

            $obj = ["Status" => false, "success" => 0, "errors" => $validator->errors()];
            return response()->json($obj);
        }
        $token = "123";
        if ($request->token == $token) {
            if ($request->hasFile('attachment')) {
                $file_name = uploadFile($request, 'attachment', 'chat');
                $is_attachment = 1;
            }
            if ($request->hasFile('audio_message')) {
                $audio_recording_url = uploadFile($request, 'audio_message', 'chat');
                $is_audio_recording = 1;
            }
            $message = Message::create([
                'appointment_id' => $request->appointment_id,
                'message' => $request->message,
                'receiver_id' => $request->receiver_id,
                'sender_id' => $request->sender_id,
                'attachment_url' => $file_name ?? null,
                'is_attachment' => $is_attachment ?? 0,
                'audio_recording_url' => $audio_recording_url ?? null,
                'is_audio_recording' => $is_audio_recording ?? 0
            ]);
            $message = Message::find($message->id);
            $obj = ["Status" => true, "success" => 1,  "data" => ["message" => $message], "msg" => "Message Sent Successfully"];
            broadcast(new MessageSent($message))->toOthers();
            return response()->json($obj);
        }

        $obj = ["Status" => false, "success" => 0, "msg" => "Token Incorrect"];
        return response()->json($obj);
    }
    public function broadcastTypingEvent(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'receiver_id' => 'required',
            'sender_id' => 'required',
            'appointment_id' => 'required'
        ]);

        if ($validator->fails()) {

            $obj = ["Status" => false, "success" => 0, "errors" => $validator->errors()];
            return response()->json($obj);
        } else {
            broadcast(new MessageTyping($request->all()));
            $obj = ["Status" => true, "success" => 1, "msg" => "Event Broadcast Successfully"];

            return response()->json($obj);
        }
    }
    public function markMessageSeen(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'receiver_id' => 'required',
            'sender_id' => 'required',
            'appointment_id' => 'required'
        ]);

        if ($validator->fails()) {

            $obj = ["Status" => false, "success" => 0, "errors" => $validator->errors()];
            return response()->json($obj);
        } else {
            $messages = Message::where('appointment_id', $request->appointment_id)->where('receiver_id', $request->receiver_id)->where('sender_id', $request->sender_id)->where('is_seen', 0)->update([
                'is_seen' => true,
                'seen_at' => now()
            ]);
            $obj = ["Status" => true, "success" => 1, "msg" => "Messages have been marked as seen successfully"];

            return response()->json($obj);
        }
    }
    public function broadcastIsSeenEvent(Request $request){
        $validator = Validator::make($request->all(), [
            'message_id' => 'required',
            'receiver_id' => 'required',
            'sender_id' => 'required',
            'appointment_id' => 'required'
        ]);

        if ($validator->fails()) {

            $obj = ["Status" => false, "success" => 0, "errors" => $validator->errors()];
            return response()->json($obj);
        } else {
            Message::where('appointment_id', $request->appointment_id)->where('receiver_id', $request->receiver_id)->where('sender_id', $request->sender_id)->where('is_seen', 0)->update([
                'is_seen' => true,
                'seen_at' => now()
            ]);
            broadcast(new MessageSeen($request->all()));
            $obj = ["Status" => true, "success" => 1, "msg" => "Seen Event Broadcast Successfully"];

            return response()->json($obj);
        }
    }
}
