<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
class Message extends Model
{
    use HasFactory;
    protected $fillable = [
        'message','sender_id','sender_name','receiver_id','receiver_name','appointment_id','attachment_url','is_attachment','is_audio_recording','audio_recording_url','is_seen','seen_at'
    ];

    public  function mentee()
    {
        return $this->belongsTo(User::class,'sender_id','id');
    }
    public  function mentor()
    {
        return $this->belongsTo(User::class,'sender_id','id');
    }

}
