/**
 * @license Copyright (c) 2003-2022, CKSource Holding sp. z o.o. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */
/**
 * @module utils/tomap
 */
import objectToMap from './objecttomap';
import isIterable from './isiterable';
/**
 * Transforms object or iterable to map. Iterable needs to be in the format acceptable by the `Map` constructor.
 *
 *		map = toMap( { 'foo': 1, 'bar': 2 } );
 *		map = toMap( [ [ 'foo', 1 ], [ 'bar', 2 ] ] );
 *		map = toMap( anotherMap );
 *
 * @param {Object|Iterable|null} data Object or iterable to transform.
 * @returns {Map} Map created from data.
 */
export default function toMap(data) {
    if (isIterable(data)) {
        return new Map(data);
    }
    else {
        return objectToMap(data);
    }
}
