/*
* @sum.cumo/vue-datepicker v4.0.0
* (c) 2018-2022 sum.cumo GmbH
* Released under the Apache-2.0 License.
*/
'use strict';

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

var check = function (it) {
  return it && it.Math == Math && it;
}; // https://github.com/zloirock/core-js/issues/86#issuecomment-115759028


var global$d = // eslint-disable-next-line es/no-global-this -- safe
check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || // eslint-disable-next-line no-restricted-globals -- safe
check(typeof self == 'object' && self) || check(typeof commonjsGlobal == 'object' && commonjsGlobal) || // eslint-disable-next-line no-new-func -- fallback
function () {
  return this;
}() || Function('return this')();

var objectGetOwnPropertyDescriptor = {};

var fails$e = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

var fails$d = fails$e; // Detect IE8's incomplete defineProperty implementation

var descriptors = !fails$d(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, {
    get: function () {
      return 7;
    }
  })[1] != 7;
});

var objectPropertyIsEnumerable = {};

var $propertyIsEnumerable = {}.propertyIsEnumerable; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

var getOwnPropertyDescriptor$2 = Object.getOwnPropertyDescriptor; // Nashorn ~ JDK8 bug

var NASHORN_BUG = getOwnPropertyDescriptor$2 && !$propertyIsEnumerable.call({
  1: 2
}, 1); // `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable

objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor$2(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

var createPropertyDescriptor$3 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var toString$1 = {}.toString;

var classofRaw$1 = function (it) {
  return toString$1.call(it).slice(8, -1);
};

var fails$c = fails$e;
var classof$6 = classofRaw$1;
var split = ''.split; // fallback for non-array-like ES3 and non-enumerable old V8 strings

var indexedObject = fails$c(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof$6(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;

// https://tc39.es/ecma262/#sec-requireobjectcoercible

var requireObjectCoercible$8 = function (it) {
  if (it == undefined) throw TypeError("Can't call method on " + it);
  return it;
};

var IndexedObject$2 = indexedObject;
var requireObjectCoercible$7 = requireObjectCoercible$8;

var toIndexedObject$5 = function (it) {
  return IndexedObject$2(requireObjectCoercible$7(it));
};

var isObject$a = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};

var isObject$9 = isObject$a; // `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string

var toPrimitive$4 = function (input, PREFERRED_STRING) {
  if (!isObject$9(input)) return input;
  var fn, val;
  if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject$9(val = fn.call(input))) return val;
  if (typeof (fn = input.valueOf) == 'function' && !isObject$9(val = fn.call(input))) return val;
  if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject$9(val = fn.call(input))) return val;
  throw TypeError("Can't convert object to primitive value");
};

var requireObjectCoercible$6 = requireObjectCoercible$8; // `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject

var toObject$5 = function (argument) {
  return Object(requireObjectCoercible$6(argument));
};

var toObject$4 = toObject$5;
var hasOwnProperty = {}.hasOwnProperty;

var has$7 = function hasOwn(it, key) {
  return hasOwnProperty.call(toObject$4(it), key);
};

var global$c = global$d;
var isObject$8 = isObject$a;
var document$1 = global$c.document; // typeof document.createElement is 'object' in old IE

var EXISTS = isObject$8(document$1) && isObject$8(document$1.createElement);

var documentCreateElement$1 = function (it) {
  return EXISTS ? document$1.createElement(it) : {};
};

var DESCRIPTORS$5 = descriptors;
var fails$b = fails$e;
var createElement = documentCreateElement$1; // Thank's IE8 for his funny defineProperty

var ie8DomDefine = !DESCRIPTORS$5 && !fails$b(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- requied for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () {
      return 7;
    }
  }).a != 7;
});

var DESCRIPTORS$4 = descriptors;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var createPropertyDescriptor$2 = createPropertyDescriptor$3;
var toIndexedObject$4 = toIndexedObject$5;
var toPrimitive$3 = toPrimitive$4;
var has$6 = has$7;
var IE8_DOM_DEFINE$1 = ie8DomDefine; // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe

var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor; // `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor

objectGetOwnPropertyDescriptor.f = DESCRIPTORS$4 ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject$4(O);
  P = toPrimitive$3(P, true);
  if (IE8_DOM_DEFINE$1) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) {
    /* empty */
  }
  if (has$6(O, P)) return createPropertyDescriptor$2(!propertyIsEnumerableModule.f.call(O, P), O[P]);
};

var objectDefineProperty = {};

var isObject$7 = isObject$a;

var anObject$b = function (it) {
  if (!isObject$7(it)) {
    throw TypeError(String(it) + ' is not an object');
  }

  return it;
};

var DESCRIPTORS$3 = descriptors;
var IE8_DOM_DEFINE = ie8DomDefine;
var anObject$a = anObject$b;
var toPrimitive$2 = toPrimitive$4; // eslint-disable-next-line es/no-object-defineproperty -- safe

var $defineProperty = Object.defineProperty; // `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty

objectDefineProperty.f = DESCRIPTORS$3 ? $defineProperty : function defineProperty(O, P, Attributes) {
  anObject$a(O);
  P = toPrimitive$2(P, true);
  anObject$a(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) {
    /* empty */
  }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var DESCRIPTORS$2 = descriptors;
var definePropertyModule$4 = objectDefineProperty;
var createPropertyDescriptor$1 = createPropertyDescriptor$3;
var createNonEnumerableProperty$5 = DESCRIPTORS$2 ? function (object, key, value) {
  return definePropertyModule$4.f(object, key, createPropertyDescriptor$1(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var redefine$5 = {exports: {}};

var global$b = global$d;
var createNonEnumerableProperty$4 = createNonEnumerableProperty$5;

var setGlobal$3 = function (key, value) {
  try {
    createNonEnumerableProperty$4(global$b, key, value);
  } catch (error) {
    global$b[key] = value;
  }

  return value;
};

var global$a = global$d;
var setGlobal$2 = setGlobal$3;
var SHARED = '__core-js_shared__';
var store$3 = global$a[SHARED] || setGlobal$2(SHARED, {});
var sharedStore = store$3;

var store$2 = sharedStore;
var functionToString = Function.toString; // this helper broken in `3.4.1-3.4.4`, so we can't use `shared` helper

if (typeof store$2.inspectSource != 'function') {
  store$2.inspectSource = function (it) {
    return functionToString.call(it);
  };
}

var inspectSource$2 = store$2.inspectSource;

var global$9 = global$d;
var inspectSource$1 = inspectSource$2;
var WeakMap$1 = global$9.WeakMap;
var nativeWeakMap = typeof WeakMap$1 === 'function' && /native code/.test(inspectSource$1(WeakMap$1));

var shared$4 = {exports: {}};

var store$1 = sharedStore;
(shared$4.exports = function (key, value) {
  return store$1[key] || (store$1[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.12.1',
  mode: 'global',
  copyright: '© 2021 Denis Pushkarev (zloirock.ru)'
});

var id = 0;
var postfix = Math.random();

var uid$2 = function (key) {
  return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
};

var shared$3 = shared$4.exports;
var uid$1 = uid$2;
var keys$1 = shared$3('keys');

var sharedKey$2 = function (key) {
  return keys$1[key] || (keys$1[key] = uid$1(key));
};

var hiddenKeys$4 = {};

var NATIVE_WEAK_MAP = nativeWeakMap;
var global$8 = global$d;
var isObject$6 = isObject$a;
var createNonEnumerableProperty$3 = createNonEnumerableProperty$5;
var objectHas = has$7;
var shared$2 = sharedStore;
var sharedKey$1 = sharedKey$2;
var hiddenKeys$3 = hiddenKeys$4;
var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var WeakMap = global$8.WeakMap;
var set, get, has$5;

var enforce = function (it) {
  return has$5(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;

    if (!isObject$6(it) || (state = get(it)).type !== TYPE) {
      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
    }

    return state;
  };
};

if (NATIVE_WEAK_MAP || shared$2.state) {
  var store = shared$2.state || (shared$2.state = new WeakMap());
  var wmget = store.get;
  var wmhas = store.has;
  var wmset = store.set;

  set = function (it, metadata) {
    if (wmhas.call(store, it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    wmset.call(store, it, metadata);
    return metadata;
  };

  get = function (it) {
    return wmget.call(store, it) || {};
  };

  has$5 = function (it) {
    return wmhas.call(store, it);
  };
} else {
  var STATE = sharedKey$1('state');
  hiddenKeys$3[STATE] = true;

  set = function (it, metadata) {
    if (objectHas(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty$3(it, STATE, metadata);
    return metadata;
  };

  get = function (it) {
    return objectHas(it, STATE) ? it[STATE] : {};
  };

  has$5 = function (it) {
    return objectHas(it, STATE);
  };
}

var internalState = {
  set: set,
  get: get,
  has: has$5,
  enforce: enforce,
  getterFor: getterFor
};

var global$7 = global$d;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$5;
var has$4 = has$7;
var setGlobal$1 = setGlobal$3;
var inspectSource = inspectSource$2;
var InternalStateModule = internalState;
var getInternalState = InternalStateModule.get;
var enforceInternalState = InternalStateModule.enforce;
var TEMPLATE = String(String).split('String');
(redefine$5.exports = function (O, key, value, options) {
  var unsafe = options ? !!options.unsafe : false;
  var simple = options ? !!options.enumerable : false;
  var noTargetGet = options ? !!options.noTargetGet : false;
  var state;

  if (typeof value == 'function') {
    if (typeof key == 'string' && !has$4(value, 'name')) {
      createNonEnumerableProperty$2(value, 'name', key);
    }

    state = enforceInternalState(value);

    if (!state.source) {
      state.source = TEMPLATE.join(typeof key == 'string' ? key : '');
    }
  }

  if (O === global$7) {
    if (simple) O[key] = value;else setGlobal$1(key, value);
    return;
  } else if (!unsafe) {
    delete O[key];
  } else if (!noTargetGet && O[key]) {
    simple = true;
  }

  if (simple) O[key] = value;else createNonEnumerableProperty$2(O, key, value); // add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative
})(Function.prototype, 'toString', function toString() {
  return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
});

var global$6 = global$d;
var path$1 = global$6;

var path = path$1;
var global$5 = global$d;

var aFunction$3 = function (variable) {
  return typeof variable == 'function' ? variable : undefined;
};

var getBuiltIn$3 = function (namespace, method) {
  return arguments.length < 2 ? aFunction$3(path[namespace]) || aFunction$3(global$5[namespace]) : path[namespace] && path[namespace][method] || global$5[namespace] && global$5[namespace][method];
};

var objectGetOwnPropertyNames = {};

var ceil = Math.ceil;
var floor$1 = Math.floor; // `ToInteger` abstract operation
// https://tc39.es/ecma262/#sec-tointeger

var toInteger$4 = function (argument) {
  return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor$1 : ceil)(argument);
};

var toInteger$3 = toInteger$4;
var min$3 = Math.min; // `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength

var toLength$7 = function (argument) {
  return argument > 0 ? min$3(toInteger$3(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};

var toInteger$2 = toInteger$4;
var max$2 = Math.max;
var min$2 = Math.min; // Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).

var toAbsoluteIndex$2 = function (index, length) {
  var integer = toInteger$2(index);
  return integer < 0 ? max$2(integer + length, 0) : min$2(integer, length);
};

var toIndexedObject$3 = toIndexedObject$5;
var toLength$6 = toLength$7;
var toAbsoluteIndex$1 = toAbsoluteIndex$2; // `Array.prototype.{ indexOf, includes }` methods implementation

var createMethod$3 = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject$3($this);
    var length = toLength$6(O.length);
    var index = toAbsoluteIndex$1(fromIndex, length);
    var value; // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check

    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++]; // eslint-disable-next-line no-self-compare -- NaN check

      if (value != value) return true; // Array#indexOf ignores holes, Array#includes - not
    } else for (; length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    }
    return !IS_INCLUDES && -1;
  };
};

var arrayIncludes = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod$3(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod$3(false)
};

var has$3 = has$7;
var toIndexedObject$2 = toIndexedObject$5;
var indexOf = arrayIncludes.indexOf;
var hiddenKeys$2 = hiddenKeys$4;

var objectKeysInternal = function (object, names) {
  var O = toIndexedObject$2(object);
  var i = 0;
  var result = [];
  var key;

  for (key in O) !has$3(hiddenKeys$2, key) && has$3(O, key) && result.push(key); // Don't enum bug & hidden keys


  while (names.length > i) if (has$3(O, key = names[i++])) {
    ~indexOf(result, key) || result.push(key);
  }

  return result;
};

var enumBugKeys$3 = ['constructor', 'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf'];

var internalObjectKeys$1 = objectKeysInternal;
var enumBugKeys$2 = enumBugKeys$3;
var hiddenKeys$1 = enumBugKeys$2.concat('length', 'prototype'); // `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe

objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys$1(O, hiddenKeys$1);
};

var objectGetOwnPropertySymbols = {};

objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

var getBuiltIn$2 = getBuiltIn$3;
var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var anObject$9 = anObject$b; // all object keys, includes non-enumerable and symbols

var ownKeys$2 = getBuiltIn$2('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject$9(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
};

var has$2 = has$7;
var ownKeys$1 = ownKeys$2;
var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
var definePropertyModule$3 = objectDefineProperty;

var copyConstructorProperties$1 = function (target, source) {
  var keys = ownKeys$1(source);
  var defineProperty = definePropertyModule$3.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;

  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!has$2(target, key)) defineProperty(target, key, getOwnPropertyDescriptor(source, key));
  }
};

var fails$a = fails$e;
var replacement = /#|\.prototype\./;

var isForced$2 = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails$a(detection) : !!detection;
};

var normalize = isForced$2.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced$2.data = {};
var NATIVE = isForced$2.NATIVE = 'N';
var POLYFILL = isForced$2.POLYFILL = 'P';
var isForced_1 = isForced$2;

var global$4 = global$d;
var getOwnPropertyDescriptor$1 = objectGetOwnPropertyDescriptor.f;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$5;
var redefine$4 = redefine$5.exports;
var setGlobal = setGlobal$3;
var copyConstructorProperties = copyConstructorProperties$1;
var isForced$1 = isForced_1;
/*
  options.target      - name of the target object
  options.global      - target is the global object
  options.stat        - export as static methods of target
  options.proto       - export as prototype methods of target
  options.real        - real prototype method for the `pure` version
  options.forced      - export even if the native feature is available
  options.bind        - bind methods to the target, required for the `pure` version
  options.wrap        - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe      - use the simple assignment of property instead of delete + defineProperty
  options.sham        - add a flag to not completely full polyfills
  options.enumerable  - export as enumerable property
  options.noTargetGet - prevent calling a getter on target
*/

var _export = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var FORCED, target, key, targetProperty, sourceProperty, descriptor;

  if (GLOBAL) {
    target = global$4;
  } else if (STATIC) {
    target = global$4[TARGET] || setGlobal(TARGET, {});
  } else {
    target = (global$4[TARGET] || {}).prototype;
  }

  if (target) for (key in source) {
    sourceProperty = source[key];

    if (options.noTargetGet) {
      descriptor = getOwnPropertyDescriptor$1(target, key);
      targetProperty = descriptor && descriptor.value;
    } else targetProperty = target[key];

    FORCED = isForced$1(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced); // contained in target

    if (!FORCED && targetProperty !== undefined) {
      if (typeof sourceProperty === typeof targetProperty) continue;
      copyConstructorProperties(sourceProperty, targetProperty);
    } // add a flag to not completely full polyfills


    if (options.sham || targetProperty && targetProperty.sham) {
      createNonEnumerableProperty$1(sourceProperty, 'sham', true);
    } // extend global


    redefine$4(target, key, sourceProperty, options);
  }
};

var getBuiltIn$1 = getBuiltIn$3;
var engineUserAgent = getBuiltIn$1('navigator', 'userAgent') || '';

var global$3 = global$d;
var userAgent = engineUserAgent;
var process = global$3.process;
var versions = process && process.versions;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  version = match[0] < 4 ? 1 : match[0] + match[1];
} else if (userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);

  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = match[1];
  }
}

var engineV8Version = version && +version;

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION$2 = engineV8Version;
var fails$9 = fails$e; // eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing

var nativeSymbol = !!Object.getOwnPropertySymbols && !fails$9(function () {
  return !String(Symbol()) || // Chrome 38 Symbol has incorrect toString conversion
  // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
  !Symbol.sham && V8_VERSION$2 && V8_VERSION$2 < 41;
});

/* eslint-disable es/no-symbol -- required for testing */
var NATIVE_SYMBOL$1 = nativeSymbol;
var useSymbolAsUid = NATIVE_SYMBOL$1 && !Symbol.sham && typeof Symbol.iterator == 'symbol';

var global$2 = global$d;
var shared$1 = shared$4.exports;
var has$1 = has$7;
var uid = uid$2;
var NATIVE_SYMBOL = nativeSymbol;
var USE_SYMBOL_AS_UID = useSymbolAsUid;
var WellKnownSymbolsStore = shared$1('wks');
var Symbol$1 = global$2.Symbol;
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$1 : Symbol$1 && Symbol$1.withoutSetter || uid;

var wellKnownSymbol$b = function (name) {
  if (!has$1(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
    if (NATIVE_SYMBOL && has$1(Symbol$1, name)) {
      WellKnownSymbolsStore[name] = Symbol$1[name];
    } else {
      WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
    }
  }

  return WellKnownSymbolsStore[name];
};

var internalObjectKeys = objectKeysInternal;
var enumBugKeys$1 = enumBugKeys$3; // `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe

var objectKeys$1 = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys$1);
};

var DESCRIPTORS$1 = descriptors;
var definePropertyModule$2 = objectDefineProperty;
var anObject$8 = anObject$b;
var objectKeys = objectKeys$1; // `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe

var objectDefineProperties = DESCRIPTORS$1 ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject$8(O);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;

  while (length > index) definePropertyModule$2.f(O, key = keys[index++], Properties[key]);

  return O;
};

var getBuiltIn = getBuiltIn$3;
var html$1 = getBuiltIn('document', 'documentElement');

var anObject$7 = anObject$b;
var defineProperties = objectDefineProperties;
var enumBugKeys = enumBugKeys$3;
var hiddenKeys = hiddenKeys$4;
var html = html$1;
var documentCreateElement = documentCreateElement$1;
var sharedKey = sharedKey$2;
var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');

var EmptyConstructor = function () {
  /* empty */
};

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
}; // Create object with fake `null` prototype: use ActiveX Object with cleared prototype


var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak

  return temp;
}; // Create object with fake `null` prototype: use iframe Object with cleared prototype


var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe); // https://github.com/zloirock/core-js/issues/475

  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
}; // Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug


var activeXDocument;

var NullProtoObject = function () {
  try {
    /* global ActiveXObject -- old IE */
    activeXDocument = document.domain && new ActiveXObject('htmlfile');
  } catch (error) {
    /* ignore */
  }

  NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
  var length = enumBugKeys.length;

  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];

  return NullProtoObject();
};

hiddenKeys[IE_PROTO] = true; // `Object.create` method
// https://tc39.es/ecma262/#sec-object.create

var objectCreate = Object.create || function create(O, Properties) {
  var result;

  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject$7(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null; // add "__proto__" for Object.getPrototypeOf polyfill

    result[IE_PROTO] = O;
  } else result = NullProtoObject();

  return Properties === undefined ? result : defineProperties(result, Properties);
};

var wellKnownSymbol$a = wellKnownSymbol$b;
var create$1 = objectCreate;
var definePropertyModule$1 = objectDefineProperty;
var UNSCOPABLES = wellKnownSymbol$a('unscopables');
var ArrayPrototype = Array.prototype; // Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

if (ArrayPrototype[UNSCOPABLES] == undefined) {
  definePropertyModule$1.f(ArrayPrototype, UNSCOPABLES, {
    configurable: true,
    value: create$1(null)
  });
} // add a key to Array.prototype[@@unscopables]


var addToUnscopables$2 = function (key) {
  ArrayPrototype[UNSCOPABLES][key] = true;
};

var $$b = _export;
var $includes = arrayIncludes.includes;
var addToUnscopables$1 = addToUnscopables$2; // `Array.prototype.includes` method
// https://tc39.es/ecma262/#sec-array.prototype.includes

$$b({
  target: 'Array',
  proto: true
}, {
  includes: function includes(el
  /* , fromIndex = 0 */
  ) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
}); // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

addToUnscopables$1('includes');

var isObject$5 = isObject$a;

var aPossiblePrototype$1 = function (it) {
  if (!isObject$5(it) && it !== null) {
    throw TypeError("Can't set " + String(it) + ' as a prototype');
  }

  return it;
};

/* eslint-disable no-proto -- safe */
var anObject$6 = anObject$b;
var aPossiblePrototype = aPossiblePrototype$1; // `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es/no-object-setprototypeof -- safe

var objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;

  try {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
    setter.call(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) {
    /* empty */
  }

  return function setPrototypeOf(O, proto) {
    anObject$6(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter.call(O, proto);else O.__proto__ = proto;
    return O;
  };
}() : undefined);

var isObject$4 = isObject$a;
var setPrototypeOf = objectSetPrototypeOf; // makes subclassing work correct for wrapped built-ins

var inheritIfRequired$1 = function ($this, dummy, Wrapper) {
  var NewTarget, NewTargetPrototype;
  if ( // it can work only with native `setPrototypeOf`
  setPrototypeOf && // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
  typeof (NewTarget = dummy.constructor) == 'function' && NewTarget !== Wrapper && isObject$4(NewTargetPrototype = NewTarget.prototype) && NewTargetPrototype !== Wrapper.prototype) setPrototypeOf($this, NewTargetPrototype);
  return $this;
};

var whitespaces$2 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' + '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

var requireObjectCoercible$5 = requireObjectCoercible$8;
var whitespaces$1 = whitespaces$2;
var whitespace = '[' + whitespaces$1 + ']';
var ltrim = RegExp('^' + whitespace + whitespace + '*');
var rtrim = RegExp(whitespace + whitespace + '*$'); // `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation

var createMethod$2 = function (TYPE) {
  return function ($this) {
    var string = String(requireObjectCoercible$5($this));
    if (TYPE & 1) string = string.replace(ltrim, '');
    if (TYPE & 2) string = string.replace(rtrim, '');
    return string;
  };
};

var stringTrim = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod$2(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod$2(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod$2(3)
};

var DESCRIPTORS = descriptors;
var global$1 = global$d;
var isForced = isForced_1;
var redefine$3 = redefine$5.exports;
var has = has$7;
var classof$5 = classofRaw$1;
var inheritIfRequired = inheritIfRequired$1;
var toPrimitive$1 = toPrimitive$4;
var fails$8 = fails$e;
var create = objectCreate;
var getOwnPropertyNames = objectGetOwnPropertyNames.f;
var getOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
var defineProperty = objectDefineProperty.f;
var trim = stringTrim.trim;
var NUMBER = 'Number';
var NativeNumber = global$1[NUMBER];
var NumberPrototype = NativeNumber.prototype; // Opera ~12 has broken Object#toString

var BROKEN_CLASSOF = classof$5(create(NumberPrototype)) == NUMBER; // `ToNumber` abstract operation
// https://tc39.es/ecma262/#sec-tonumber

var toNumber = function (argument) {
  var it = toPrimitive$1(argument, false);
  var first, third, radix, maxCode, digits, length, index, code;

  if (typeof it == 'string' && it.length > 2) {
    it = trim(it);
    first = it.charCodeAt(0);

    if (first === 43 || first === 45) {
      third = it.charCodeAt(2);
      if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix
    } else if (first === 48) {
      switch (it.charCodeAt(1)) {
        case 66:
        case 98:
          radix = 2;
          maxCode = 49;
          break;
        // fast equal of /^0b[01]+$/i

        case 79:
        case 111:
          radix = 8;
          maxCode = 55;
          break;
        // fast equal of /^0o[0-7]+$/i

        default:
          return +it;
      }

      digits = it.slice(2);
      length = digits.length;

      for (index = 0; index < length; index++) {
        code = digits.charCodeAt(index); // parseInt parses a string to a first unavailable symbol
        // but ToNumber should return NaN if a string contains unavailable symbols

        if (code < 48 || code > maxCode) return NaN;
      }

      return parseInt(digits, radix);
    }
  }

  return +it;
}; // `Number` constructor
// https://tc39.es/ecma262/#sec-number-constructor


if (isForced(NUMBER, !NativeNumber(' 0o1') || !NativeNumber('0b1') || NativeNumber('+0x1'))) {
  var NumberWrapper = function Number(value) {
    var it = arguments.length < 1 ? 0 : value;
    var dummy = this;
    return dummy instanceof NumberWrapper // check on 1..constructor(foo) case
    && (BROKEN_CLASSOF ? fails$8(function () {
      NumberPrototype.valueOf.call(dummy);
    }) : classof$5(dummy) != NUMBER) ? inheritIfRequired(new NativeNumber(toNumber(it)), dummy, NumberWrapper) : toNumber(it);
  };

  for (var keys = DESCRIPTORS ? getOwnPropertyNames(NativeNumber) : ( // ES3:
  'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' + // ES2015 (in case, if modules with ES2015 Number statics required before):
  'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' + 'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger,' + // ESNext
  'fromString,range').split(','), j = 0, key; keys.length > j; j++) {
    if (has(NativeNumber, key = keys[j]) && !has(NumberWrapper, key)) {
      defineProperty(NumberWrapper, key, getOwnPropertyDescriptor(NativeNumber, key));
    }
  }

  NumberWrapper.prototype = NumberPrototype;
  NumberPrototype.constructor = NumberWrapper;
  redefine$3(global$1, NUMBER, NumberWrapper);
}

var classof$4 = classofRaw$1; // `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es/no-array-isarray -- safe

var isArray$3 = Array.isArray || function isArray(arg) {
  return classof$4(arg) == 'Array';
};

var toPrimitive = toPrimitive$4;
var definePropertyModule = objectDefineProperty;
var createPropertyDescriptor = createPropertyDescriptor$3;

var createProperty$2 = function (object, key, value) {
  var propertyKey = toPrimitive(key);
  if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));else object[propertyKey] = value;
};

var fails$7 = fails$e;
var wellKnownSymbol$9 = wellKnownSymbol$b;
var V8_VERSION$1 = engineV8Version;
var SPECIES$4 = wellKnownSymbol$9('species');

var arrayMethodHasSpeciesSupport$3 = function (METHOD_NAME) {
  // We can't use this feature detection in V8 since it causes
  // deoptimization and serious performance degradation
  // https://github.com/zloirock/core-js/issues/677
  return V8_VERSION$1 >= 51 || !fails$7(function () {
    var array = [];
    var constructor = array.constructor = {};

    constructor[SPECIES$4] = function () {
      return {
        foo: 1
      };
    };

    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};

var $$a = _export;
var isObject$3 = isObject$a;
var isArray$2 = isArray$3;
var toAbsoluteIndex = toAbsoluteIndex$2;
var toLength$5 = toLength$7;
var toIndexedObject$1 = toIndexedObject$5;
var createProperty$1 = createProperty$2;
var wellKnownSymbol$8 = wellKnownSymbol$b;
var arrayMethodHasSpeciesSupport$2 = arrayMethodHasSpeciesSupport$3;
var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport$2('slice');
var SPECIES$3 = wellKnownSymbol$8('species');
var nativeSlice = [].slice;
var max$1 = Math.max; // `Array.prototype.slice` method
// https://tc39.es/ecma262/#sec-array.prototype.slice
// fallback for not array-like ES3 strings and DOM objects

$$a({
  target: 'Array',
  proto: true,
  forced: !HAS_SPECIES_SUPPORT$1
}, {
  slice: function slice(start, end) {
    var O = toIndexedObject$1(this);
    var length = toLength$5(O.length);
    var k = toAbsoluteIndex(start, length);
    var fin = toAbsoluteIndex(end === undefined ? length : end, length); // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible

    var Constructor, result, n;

    if (isArray$2(O)) {
      Constructor = O.constructor; // cross-realm fallback

      if (typeof Constructor == 'function' && (Constructor === Array || isArray$2(Constructor.prototype))) {
        Constructor = undefined;
      } else if (isObject$3(Constructor)) {
        Constructor = Constructor[SPECIES$3];
        if (Constructor === null) Constructor = undefined;
      }

      if (Constructor === Array || Constructor === undefined) {
        return nativeSlice.call(O, k, fin);
      }
    }

    result = new (Constructor === undefined ? Array : Constructor)(max$1(fin - k, 0));

    for (n = 0; k < fin; k++, n++) if (k in O) createProperty$1(result, n, O[k]);

    result.length = n;
    return result;
  }
});

var wellKnownSymbol$7 = wellKnownSymbol$b;
var TO_STRING_TAG$1 = wellKnownSymbol$7('toStringTag');
var test = {};
test[TO_STRING_TAG$1] = 'z';
var toStringTagSupport = String(test) === '[object z]';

var TO_STRING_TAG_SUPPORT$2 = toStringTagSupport;
var classofRaw = classofRaw$1;
var wellKnownSymbol$6 = wellKnownSymbol$b;
var TO_STRING_TAG = wellKnownSymbol$6('toStringTag'); // ES3 wrong here

var CORRECT_ARGUMENTS = classofRaw(function () {
  return arguments;
}()) == 'Arguments'; // fallback for IE11 Script Access Denied error

var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) {
    /* empty */
  }
}; // getting tag from ES6+ `Object.prototype.toString`


var classof$3 = TO_STRING_TAG_SUPPORT$2 ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null' // @@toStringTag case
  : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag // builtinTag case
  : CORRECT_ARGUMENTS ? classofRaw(O) // ES3 arguments fallback
  : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
};

var TO_STRING_TAG_SUPPORT$1 = toStringTagSupport;
var classof$2 = classof$3; // `Object.prototype.toString` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.tostring

var objectToString = TO_STRING_TAG_SUPPORT$1 ? {}.toString : function toString() {
  return '[object ' + classof$2(this) + ']';
};

var TO_STRING_TAG_SUPPORT = toStringTagSupport;
var redefine$2 = redefine$5.exports;
var toString = objectToString; // `Object.prototype.toString` method
// https://tc39.es/ecma262/#sec-object.prototype.tostring

if (!TO_STRING_TAG_SUPPORT) {
  redefine$2(Object.prototype, 'toString', toString, {
    unsafe: true
  });
}

var anObject$5 = anObject$b; // `RegExp.prototype.flags` getter implementation
// https://tc39.es/ecma262/#sec-get-regexp.prototype.flags

var regexpFlags$1 = function () {
  var that = anObject$5(this);
  var result = '';
  if (that.global) result += 'g';
  if (that.ignoreCase) result += 'i';
  if (that.multiline) result += 'm';
  if (that.dotAll) result += 's';
  if (that.unicode) result += 'u';
  if (that.sticky) result += 'y';
  return result;
};

var redefine$1 = redefine$5.exports;
var anObject$4 = anObject$b;
var fails$6 = fails$e;
var flags = regexpFlags$1;
var TO_STRING = 'toString';
var RegExpPrototype$1 = RegExp.prototype;
var nativeToString = RegExpPrototype$1[TO_STRING];
var NOT_GENERIC = fails$6(function () {
  return nativeToString.call({
    source: 'a',
    flags: 'b'
  }) != '/a/b';
}); // FF44- RegExp#toString has a wrong name

var INCORRECT_NAME = nativeToString.name != TO_STRING; // `RegExp.prototype.toString` method
// https://tc39.es/ecma262/#sec-regexp.prototype.tostring

if (NOT_GENERIC || INCORRECT_NAME) {
  redefine$1(RegExp.prototype, TO_STRING, function toString() {
    var R = anObject$4(this);
    var p = String(R.source);
    var rf = R.flags;
    var f = String(rf === undefined && R instanceof RegExp && !('flags' in RegExpPrototype$1) ? flags.call(R) : rf);
    return '/' + p + '/' + f;
  }, {
    unsafe: true
  });
}

var aFunction$2 = function (it) {
  if (typeof it != 'function') {
    throw TypeError(String(it) + ' is not a function');
  }

  return it;
};

var aFunction$1 = aFunction$2; // optional / simple context binding

var functionBindContext = function (fn, that, length) {
  aFunction$1(fn);
  if (that === undefined) return fn;

  switch (length) {
    case 0:
      return function () {
        return fn.call(that);
      };

    case 1:
      return function (a) {
        return fn.call(that, a);
      };

    case 2:
      return function (a, b) {
        return fn.call(that, a, b);
      };

    case 3:
      return function (a, b, c) {
        return fn.call(that, a, b, c);
      };
  }

  return function
    /* ...args */
  () {
    return fn.apply(that, arguments);
  };
};

var isObject$2 = isObject$a;
var isArray$1 = isArray$3;
var wellKnownSymbol$5 = wellKnownSymbol$b;
var SPECIES$2 = wellKnownSymbol$5('species'); // `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate

var arraySpeciesCreate$2 = function (originalArray, length) {
  var C;

  if (isArray$1(originalArray)) {
    C = originalArray.constructor; // cross-realm fallback

    if (typeof C == 'function' && (C === Array || isArray$1(C.prototype))) C = undefined;else if (isObject$2(C)) {
      C = C[SPECIES$2];
      if (C === null) C = undefined;
    }
  }

  return new (C === undefined ? Array : C)(length === 0 ? 0 : length);
};

var bind = functionBindContext;
var IndexedObject$1 = indexedObject;
var toObject$3 = toObject$5;
var toLength$4 = toLength$7;
var arraySpeciesCreate$1 = arraySpeciesCreate$2;
var push = [].push; // `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterOut }` methods implementation

var createMethod$1 = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var IS_FILTER_OUT = TYPE == 7;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject$3($this);
    var self = IndexedObject$1(O);
    var boundFunction = bind(callbackfn, that, 3);
    var length = toLength$4(self.length);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate$1;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_OUT ? create($this, 0) : undefined;
    var value, result;

    for (; length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);

      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3:
            return true;
          // some

          case 5:
            return value;
          // find

          case 6:
            return index;
          // findIndex

          case 2:
            push.call(target, value);
          // filter
        } else switch (TYPE) {
          case 4:
            return false;
          // every

          case 7:
            push.call(target, value);
          // filterOut
        }
      }
    }

    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

var arrayIteration = {
  // `Array.prototype.forEach` method
  // https://tc39.es/ecma262/#sec-array.prototype.foreach
  forEach: createMethod$1(0),
  // `Array.prototype.map` method
  // https://tc39.es/ecma262/#sec-array.prototype.map
  map: createMethod$1(1),
  // `Array.prototype.filter` method
  // https://tc39.es/ecma262/#sec-array.prototype.filter
  filter: createMethod$1(2),
  // `Array.prototype.some` method
  // https://tc39.es/ecma262/#sec-array.prototype.some
  some: createMethod$1(3),
  // `Array.prototype.every` method
  // https://tc39.es/ecma262/#sec-array.prototype.every
  every: createMethod$1(4),
  // `Array.prototype.find` method
  // https://tc39.es/ecma262/#sec-array.prototype.find
  find: createMethod$1(5),
  // `Array.prototype.findIndex` method
  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod$1(6),
  // `Array.prototype.filterOut` method
  // https://github.com/tc39/proposal-array-filtering
  filterOut: createMethod$1(7)
};

var $$9 = _export;
var $findIndex = arrayIteration.findIndex;
var addToUnscopables = addToUnscopables$2;
var FIND_INDEX = 'findIndex';
var SKIPS_HOLES = true; // Shouldn't skip holes

if (FIND_INDEX in []) Array(1)[FIND_INDEX](function () {
  SKIPS_HOLES = false;
}); // `Array.prototype.findIndex` method
// https://tc39.es/ecma262/#sec-array.prototype.findindex

$$9({
  target: 'Array',
  proto: true,
  forced: SKIPS_HOLES
}, {
  findIndex: function findIndex(callbackfn
  /* , that = undefined */
  ) {
    return $findIndex(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
}); // https://tc39.es/ecma262/#sec-array.prototype-@@unscopables

addToUnscopables(FIND_INDEX);

var isObject$1 = isObject$a;
var classof$1 = classofRaw$1;
var wellKnownSymbol$4 = wellKnownSymbol$b;
var MATCH$1 = wellKnownSymbol$4('match'); // `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp

var isRegexp = function (it) {
  var isRegExp;
  return isObject$1(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$1(it) == 'RegExp');
};

var isRegExp$1 = isRegexp;

var notARegexp = function (it) {
  if (isRegExp$1(it)) {
    throw TypeError("The method doesn't accept regular expressions");
  }

  return it;
};

var wellKnownSymbol$3 = wellKnownSymbol$b;
var MATCH = wellKnownSymbol$3('match');

var correctIsRegexpLogic = function (METHOD_NAME) {
  var regexp = /./;

  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) {
      /* empty */
    }
  }

  return false;
};

var $$8 = _export;
var notARegExp = notARegexp;
var requireObjectCoercible$4 = requireObjectCoercible$8;
var correctIsRegExpLogic = correctIsRegexpLogic; // `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes

$$8({
  target: 'String',
  proto: true,
  forced: !correctIsRegExpLogic('includes')
}, {
  includes: function includes(searchString
  /* , position = 0 */
  ) {
    return !!~String(requireObjectCoercible$4(this)).indexOf(notARegExp(searchString), arguments.length > 1 ? arguments[1] : undefined);
  }
});

var regexpStickyHelpers = {};

var fails$5 = fails$e; // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError,
// so we use an intermediate function.

function RE(s, f) {
  return RegExp(s, f);
}

regexpStickyHelpers.UNSUPPORTED_Y = fails$5(function () {
  // babel-minify transpiles RegExp('a', 'y') -> /a/y and it causes SyntaxError
  var re = RE('a', 'y');
  re.lastIndex = 2;
  return re.exec('abcd') != null;
});
regexpStickyHelpers.BROKEN_CARET = fails$5(function () {
  // https://bugzilla.mozilla.org/show_bug.cgi?id=773687
  var re = RE('^r', 'gy');
  re.lastIndex = 2;
  return re.exec('str') != null;
});

/* eslint-disable regexp/no-assertion-capturing-group, regexp/no-empty-group, regexp/no-lazy-ends -- testing */

/* eslint-disable regexp/no-useless-quantifier -- testing */


var regexpFlags = regexpFlags$1;
var stickyHelpers$1 = regexpStickyHelpers;
var shared = shared$4.exports;
var nativeExec = RegExp.prototype.exec;
var nativeReplace = shared('native-string-replace', String.prototype.replace);
var patchedExec = nativeExec;

var UPDATES_LAST_INDEX_WRONG = function () {
  var re1 = /a/;
  var re2 = /b*/g;
  nativeExec.call(re1, 'a');
  nativeExec.call(re2, 'a');
  return re1.lastIndex !== 0 || re2.lastIndex !== 0;
}();

var UNSUPPORTED_Y$1 = stickyHelpers$1.UNSUPPORTED_Y || stickyHelpers$1.BROKEN_CARET; // nonparticipating capturing group, copied from es5-shim's String#split patch.

var NPCG_INCLUDED = /()??/.exec('')[1] !== undefined;
var PATCH = UPDATES_LAST_INDEX_WRONG || NPCG_INCLUDED || UNSUPPORTED_Y$1;

if (PATCH) {
  patchedExec = function exec(str) {
    var re = this;
    var lastIndex, reCopy, match, i;
    var sticky = UNSUPPORTED_Y$1 && re.sticky;
    var flags = regexpFlags.call(re);
    var source = re.source;
    var charsAdded = 0;
    var strCopy = str;

    if (sticky) {
      flags = flags.replace('y', '');

      if (flags.indexOf('g') === -1) {
        flags += 'g';
      }

      strCopy = String(str).slice(re.lastIndex); // Support anchored sticky behavior.

      if (re.lastIndex > 0 && (!re.multiline || re.multiline && str[re.lastIndex - 1] !== '\n')) {
        source = '(?: ' + source + ')';
        strCopy = ' ' + strCopy;
        charsAdded++;
      } // ^(? + rx + ) is needed, in combination with some str slicing, to
      // simulate the 'y' flag.


      reCopy = new RegExp('^(?:' + source + ')', flags);
    }

    if (NPCG_INCLUDED) {
      reCopy = new RegExp('^' + source + '$(?!\\s)', flags);
    }

    if (UPDATES_LAST_INDEX_WRONG) lastIndex = re.lastIndex;
    match = nativeExec.call(sticky ? reCopy : re, strCopy);

    if (sticky) {
      if (match) {
        match.input = match.input.slice(charsAdded);
        match[0] = match[0].slice(charsAdded);
        match.index = re.lastIndex;
        re.lastIndex += match[0].length;
      } else re.lastIndex = 0;
    } else if (UPDATES_LAST_INDEX_WRONG && match) {
      re.lastIndex = re.global ? match.index + match[0].length : lastIndex;
    }

    if (NPCG_INCLUDED && match && match.length > 1) {
      // Fix browsers whose `exec` methods don't consistently return `undefined`
      // for NPCG, like IE8. NOTE: This doesn' work for /(.?)?/
      nativeReplace.call(match[0], reCopy, function () {
        for (i = 1; i < arguments.length - 2; i++) {
          if (arguments[i] === undefined) match[i] = undefined;
        }
      });
    }

    return match;
  };
}

var regexpExec$3 = patchedExec;

var $$7 = _export;
var exec = regexpExec$3; // `RegExp.prototype.exec` method
// https://tc39.es/ecma262/#sec-regexp.prototype.exec

$$7({
  target: 'RegExp',
  proto: true,
  forced: /./.exec !== exec
}, {
  exec: exec
});

var redefine = redefine$5.exports;
var regexpExec$2 = regexpExec$3;
var fails$4 = fails$e;
var wellKnownSymbol$2 = wellKnownSymbol$b;
var createNonEnumerableProperty = createNonEnumerableProperty$5;
var SPECIES$1 = wellKnownSymbol$2('species');
var RegExpPrototype = RegExp.prototype;
var REPLACE_SUPPORTS_NAMED_GROUPS = !fails$4(function () {
  // #replace needs built-in support for named groups.
  // #match works fine because it just return the exec results, even if it has
  // a "grops" property.
  var re = /./;

  re.exec = function () {
    var result = [];
    result.groups = {
      a: '7'
    };
    return result;
  };

  return ''.replace(re, '$<a>') !== '7';
}); // IE <= 11 replaces $0 with the whole match, as if it was $&
// https://stackoverflow.com/questions/6024666/getting-ie-to-replace-a-regex-with-the-literal-string-0

var REPLACE_KEEPS_$0 = function () {
  // eslint-disable-next-line regexp/prefer-escape-replacement-dollar-char -- required for testing
  return 'a'.replace(/./, '$0') === '$0';
}();

var REPLACE = wellKnownSymbol$2('replace'); // Safari <= 13.0.3(?) substitutes nth capture where n>m with an empty string

var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = function () {
  if (/./[REPLACE]) {
    return /./[REPLACE]('a', '$0') === '';
  }

  return false;
}(); // Chrome 51 has a buggy "split" implementation when RegExp#exec !== nativeExec
// Weex JS has frozen built-in prototypes, so use try / catch wrapper


var SPLIT_WORKS_WITH_OVERWRITTEN_EXEC = !fails$4(function () {
  // eslint-disable-next-line regexp/no-empty-group -- required for testing
  var re = /(?:)/;
  var originalExec = re.exec;

  re.exec = function () {
    return originalExec.apply(this, arguments);
  };

  var result = 'ab'.split(re);
  return result.length !== 2 || result[0] !== 'a' || result[1] !== 'b';
});

var fixRegexpWellKnownSymbolLogic = function (KEY, length, exec, sham) {
  var SYMBOL = wellKnownSymbol$2(KEY);
  var DELEGATES_TO_SYMBOL = !fails$4(function () {
    // String methods call symbol-named RegEp methods
    var O = {};

    O[SYMBOL] = function () {
      return 7;
    };

    return ''[KEY](O) != 7;
  });
  var DELEGATES_TO_EXEC = DELEGATES_TO_SYMBOL && !fails$4(function () {
    // Symbol-named RegExp methods call .exec
    var execCalled = false;
    var re = /a/;

    if (KEY === 'split') {
      // We can't use real regex here since it causes deoptimization
      // and serious performance degradation in V8
      // https://github.com/zloirock/core-js/issues/306
      re = {}; // RegExp[@@split] doesn't call the regex's exec method, but first creates
      // a new one. We need to return the patched regex when creating the new one.

      re.constructor = {};

      re.constructor[SPECIES$1] = function () {
        return re;
      };

      re.flags = '';
      re[SYMBOL] = /./[SYMBOL];
    }

    re.exec = function () {
      execCalled = true;
      return null;
    };

    re[SYMBOL]('');
    return !execCalled;
  });

  if (!DELEGATES_TO_SYMBOL || !DELEGATES_TO_EXEC || KEY === 'replace' && !(REPLACE_SUPPORTS_NAMED_GROUPS && REPLACE_KEEPS_$0 && !REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE) || KEY === 'split' && !SPLIT_WORKS_WITH_OVERWRITTEN_EXEC) {
    var nativeRegExpMethod = /./[SYMBOL];
    var methods = exec(SYMBOL, ''[KEY], function (nativeMethod, regexp, str, arg2, forceStringMethod) {
      var $exec = regexp.exec;

      if ($exec === regexpExec$2 || $exec === RegExpPrototype.exec) {
        if (DELEGATES_TO_SYMBOL && !forceStringMethod) {
          // The native String method already delegates to @@method (this
          // polyfilled function), leasing to infinite recursion.
          // We avoid it by directly calling the native @@method method.
          return {
            done: true,
            value: nativeRegExpMethod.call(regexp, str, arg2)
          };
        }

        return {
          done: true,
          value: nativeMethod.call(str, regexp, arg2)
        };
      }

      return {
        done: false
      };
    }, {
      REPLACE_KEEPS_$0: REPLACE_KEEPS_$0,
      REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE: REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE
    });
    var stringMethod = methods[0];
    var regexMethod = methods[1];
    redefine(String.prototype, KEY, stringMethod);
    redefine(RegExpPrototype, SYMBOL, length == 2 // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)
    // 21.2.5.11 RegExp.prototype[@@split](string, limit)
    ? function (string, arg) {
      return regexMethod.call(string, this, arg);
    } // 21.2.5.6 RegExp.prototype[@@match](string)
    // 21.2.5.9 RegExp.prototype[@@search](string)
    : function (string) {
      return regexMethod.call(string, this);
    });
  }

  if (sham) createNonEnumerableProperty(RegExpPrototype[SYMBOL], 'sham', true);
};

var anObject$3 = anObject$b;
var aFunction = aFunction$2;
var wellKnownSymbol$1 = wellKnownSymbol$b;
var SPECIES = wellKnownSymbol$1('species'); // `SpeciesConstructor` abstract operation
// https://tc39.es/ecma262/#sec-speciesconstructor

var speciesConstructor$1 = function (O, defaultConstructor) {
  var C = anObject$3(O).constructor;
  var S;
  return C === undefined || (S = anObject$3(C)[SPECIES]) == undefined ? defaultConstructor : aFunction(S);
};

var toInteger$1 = toInteger$4;
var requireObjectCoercible$3 = requireObjectCoercible$8; // `String.prototype.{ codePointAt, at }` methods implementation

var createMethod = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = String(requireObjectCoercible$3($this));
    var position = toInteger$1(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = S.charCodeAt(position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var stringMultibyte = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod(true)
};

var charAt = stringMultibyte.charAt; // `AdvanceStringIndex` abstract operation
// https://tc39.es/ecma262/#sec-advancestringindex

var advanceStringIndex$3 = function (S, index, unicode) {
  return index + (unicode ? charAt(S, index).length : 1);
};

var classof = classofRaw$1;
var regexpExec$1 = regexpExec$3; // `RegExpExec` abstract operation
// https://tc39.es/ecma262/#sec-regexpexec

var regexpExecAbstract = function (R, S) {
  var exec = R.exec;

  if (typeof exec === 'function') {
    var result = exec.call(R, S);

    if (typeof result !== 'object') {
      throw TypeError('RegExp exec method returned something other than an Object or null');
    }

    return result;
  }

  if (classof(R) !== 'RegExp') {
    throw TypeError('RegExp#exec called on incompatible receiver');
  }

  return regexpExec$1.call(R, S);
};

var fixRegExpWellKnownSymbolLogic$2 = fixRegexpWellKnownSymbolLogic;
var isRegExp = isRegexp;
var anObject$2 = anObject$b;
var requireObjectCoercible$2 = requireObjectCoercible$8;
var speciesConstructor = speciesConstructor$1;
var advanceStringIndex$2 = advanceStringIndex$3;
var toLength$3 = toLength$7;
var callRegExpExec = regexpExecAbstract;
var regexpExec = regexpExec$3;
var stickyHelpers = regexpStickyHelpers;
var UNSUPPORTED_Y = stickyHelpers.UNSUPPORTED_Y;
var arrayPush = [].push;
var min$1 = Math.min;
var MAX_UINT32 = 0xFFFFFFFF; // @@split logic

fixRegExpWellKnownSymbolLogic$2('split', 2, function (SPLIT, nativeSplit, maybeCallNative) {
  var internalSplit;

  if ('abbc'.split(/(b)*/)[1] == 'c' || // eslint-disable-next-line regexp/no-empty-group -- required for testing
  'test'.split(/(?:)/, -1).length != 4 || 'ab'.split(/(?:ab)*/).length != 2 || '.'.split(/(.?)(.?)/).length != 4 || // eslint-disable-next-line regexp/no-assertion-capturing-group, regexp/no-empty-group -- required for testing
  '.'.split(/()()/).length > 1 || ''.split(/.?/).length) {
    // based on es5-shim implementation, need to rework it
    internalSplit = function (separator, limit) {
      var string = String(requireObjectCoercible$2(this));
      var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
      if (lim === 0) return [];
      if (separator === undefined) return [string]; // If `separator` is not a regex, use native split

      if (!isRegExp(separator)) {
        return nativeSplit.call(string, separator, lim);
      }

      var output = [];
      var flags = (separator.ignoreCase ? 'i' : '') + (separator.multiline ? 'm' : '') + (separator.unicode ? 'u' : '') + (separator.sticky ? 'y' : '');
      var lastLastIndex = 0; // Make `global` and avoid `lastIndex` issues by working with a copy

      var separatorCopy = new RegExp(separator.source, flags + 'g');
      var match, lastIndex, lastLength;

      while (match = regexpExec.call(separatorCopy, string)) {
        lastIndex = separatorCopy.lastIndex;

        if (lastIndex > lastLastIndex) {
          output.push(string.slice(lastLastIndex, match.index));
          if (match.length > 1 && match.index < string.length) arrayPush.apply(output, match.slice(1));
          lastLength = match[0].length;
          lastLastIndex = lastIndex;
          if (output.length >= lim) break;
        }

        if (separatorCopy.lastIndex === match.index) separatorCopy.lastIndex++; // Avoid an infinite loop
      }

      if (lastLastIndex === string.length) {
        if (lastLength || !separatorCopy.test('')) output.push('');
      } else output.push(string.slice(lastLastIndex));

      return output.length > lim ? output.slice(0, lim) : output;
    }; // Chakra, V8

  } else if ('0'.split(undefined, 0).length) {
    internalSplit = function (separator, limit) {
      return separator === undefined && limit === 0 ? [] : nativeSplit.call(this, separator, limit);
    };
  } else internalSplit = nativeSplit;

  return [// `String.prototype.split` method
  // https://tc39.es/ecma262/#sec-string.prototype.split
  function split(separator, limit) {
    var O = requireObjectCoercible$2(this);
    var splitter = separator == undefined ? undefined : separator[SPLIT];
    return splitter !== undefined ? splitter.call(separator, O, limit) : internalSplit.call(String(O), separator, limit);
  }, // `RegExp.prototype[@@split]` method
  // https://tc39.es/ecma262/#sec-regexp.prototype-@@split
  //
  // NOTE: This cannot be properly polyfilled in engines that don't support
  // the 'y' flag.
  function (regexp, limit) {
    var res = maybeCallNative(internalSplit, regexp, this, limit, internalSplit !== nativeSplit);
    if (res.done) return res.value;
    var rx = anObject$2(regexp);
    var S = String(this);
    var C = speciesConstructor(rx, RegExp);
    var unicodeMatching = rx.unicode;
    var flags = (rx.ignoreCase ? 'i' : '') + (rx.multiline ? 'm' : '') + (rx.unicode ? 'u' : '') + (UNSUPPORTED_Y ? 'g' : 'y'); // ^(? + rx + ) is needed, in combination with some S slicing, to
    // simulate the 'y' flag.

    var splitter = new C(UNSUPPORTED_Y ? '^(?:' + rx.source + ')' : rx, flags);
    var lim = limit === undefined ? MAX_UINT32 : limit >>> 0;
    if (lim === 0) return [];
    if (S.length === 0) return callRegExpExec(splitter, S) === null ? [S] : [];
    var p = 0;
    var q = 0;
    var A = [];

    while (q < S.length) {
      splitter.lastIndex = UNSUPPORTED_Y ? 0 : q;
      var z = callRegExpExec(splitter, UNSUPPORTED_Y ? S.slice(q) : S);
      var e;

      if (z === null || (e = min$1(toLength$3(splitter.lastIndex + (UNSUPPORTED_Y ? q : 0)), S.length)) === p) {
        q = advanceStringIndex$2(S, q, unicodeMatching);
      } else {
        A.push(S.slice(p, q));
        if (A.length === lim) return A;

        for (var i = 1; i <= z.length - 1; i++) {
          A.push(z[i]);
          if (A.length === lim) return A;
        }

        q = p = e;
      }
    }

    A.push(S.slice(p));
    return A;
  }];
}, UNSUPPORTED_Y);

var $$6 = _export; // `Number.isNaN` method
// https://tc39.es/ecma262/#sec-number.isnan

$$6({
  target: 'Number',
  stat: true
}, {
  isNaN: function isNaN(number) {
    // eslint-disable-next-line no-self-compare -- NaN check
    return number != number;
  }
});

var $$5 = _export;
var fails$3 = fails$e;
var isArray = isArray$3;
var isObject = isObject$a;
var toObject$2 = toObject$5;
var toLength$2 = toLength$7;
var createProperty = createProperty$2;
var arraySpeciesCreate = arraySpeciesCreate$2;
var arrayMethodHasSpeciesSupport$1 = arrayMethodHasSpeciesSupport$3;
var wellKnownSymbol = wellKnownSymbol$b;
var V8_VERSION = engineV8Version;
var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF;
var MAXIMUM_ALLOWED_INDEX_EXCEEDED = 'Maximum allowed index exceeded'; // We can't use this feature detection in V8 since it causes
// deoptimization and serious performance degradation
// https://github.com/zloirock/core-js/issues/679

var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails$3(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});
var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport$1('concat');

var isConcatSpreadable = function (O) {
  if (!isObject(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : isArray(O);
};

var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !SPECIES_SUPPORT; // `Array.prototype.concat` method
// https://tc39.es/ecma262/#sec-array.prototype.concat
// with adding support of @@isConcatSpreadable and @@species

$$5({
  target: 'Array',
  proto: true,
  forced: FORCED
}, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  concat: function concat(arg) {
    var O = toObject$2(this);
    var A = arraySpeciesCreate(O, 0);
    var n = 0;
    var i, k, length, len, E;

    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];

      if (isConcatSpreadable(E)) {
        len = toLength$2(E.length);
        if (n + len > MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);

        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
      } else {
        if (n >= MAX_SAFE_INTEGER) throw TypeError(MAXIMUM_ALLOWED_INDEX_EXCEEDED);
        createProperty(A, n++, E);
      }
    }

    A.length = n;
    return A;
  }
});

function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }

  return target;
}

function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

var Language = /*#__PURE__*/function () {
  // eslint-disable-next-line max-params
  function Language(language, months, monthsAbbr, days) {
    var rtl = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
    var ymd = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
    var yearSuffix = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : '';

    _classCallCheck(this, Language);

    this.language = language;
    this.months = months;
    this.monthsAbbr = monthsAbbr;
    this.days = days;
    this.rtl = rtl;
    this.ymd = ymd;
    this.yearSuffix = yearSuffix;
  }
  /* eslint-disable no-underscore-dangle */


  _createClass(Language, [{
    key: "language",
    get: function get() {
      return this._language;
    },
    set: function set(language) {
      if (typeof language !== 'string') {
        throw new TypeError('Language must be a string');
      }

      this._language = language;
    }
  }, {
    key: "months",
    get: function get() {
      return this._months;
    },
    set: function set(months) {
      if (months.length !== 12) {
        throw new RangeError("There must be 12 months for ".concat(this.language, " language"));
      }

      this._months = months;
    }
  }, {
    key: "monthsAbbr",
    get: function get() {
      return this._monthsAbbr;
    },
    set: function set(monthsAbbr) {
      if (monthsAbbr.length !== 12) {
        throw new RangeError("There must be 12 abbreviated months for ".concat(this.language, " language"));
      }

      this._monthsAbbr = monthsAbbr;
    }
  }, {
    key: "days",
    get: function get() {
      return this._days;
    },
    set: function set(days) {
      if (days.length !== 7) {
        throw new RangeError("There must be 7 days for ".concat(this.language, " language"));
      }

      this._days = days;
    }
  }, {
    key: "getDaysStartingOn",
    value: function getDaysStartingOn(firstDayOfWeek) {
      var firstDays = this._days.slice(firstDayOfWeek);

      var lastDays = this._days.slice(0, firstDayOfWeek);

      return firstDays.concat(lastDays);
    }
  }, {
    key: "getMonthByAbbrName",
    value: function getMonthByAbbrName(name) {
      var monthValue = this._monthsAbbr.findIndex(function (month) {
        return month === name;
      }) + 1;
      return monthValue < 10 ? "0".concat(monthValue) : "".concat(monthValue);
    }
  }, {
    key: "getMonthByName",
    value: function getMonthByName(name) {
      var monthValue = this._months.findIndex(function (month) {
        return month === name;
      }) + 1;
      return monthValue < 10 ? "0".concat(monthValue) : "".concat(monthValue);
    }
  }]);

  return Language;
}();

var en = new Language('English', ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'], ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'], ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']);

var calendarSlots = ['beforeCalendarHeaderDay', 'calendarFooterDay', 'beforeCalendarHeaderMonth', 'calendarFooterMonth', 'beforeCalendarHeaderYear', 'calendarFooterYear', 'nextIntervalBtn', 'prevIntervalBtn'];

var fails$2 = fails$e;

var arrayMethodIsStrict$1 = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails$2(function () {
    // eslint-disable-next-line no-useless-call,no-throw-literal -- required for testing
    method.call(null, argument || function () {
      throw 1;
    }, 1);
  });
};

var $$4 = _export;
var IndexedObject = indexedObject;
var toIndexedObject = toIndexedObject$5;
var arrayMethodIsStrict = arrayMethodIsStrict$1;
var nativeJoin = [].join;
var ES3_STRINGS = IndexedObject != Object;
var STRICT_METHOD = arrayMethodIsStrict('join', ','); // `Array.prototype.join` method
// https://tc39.es/ecma262/#sec-array.prototype.join

$$4({
  target: 'Array',
  proto: true,
  forced: ES3_STRINGS || !STRICT_METHOD
}, {
  join: function join(separator) {
    return nativeJoin.call(toIndexedObject(this), separator === undefined ? ',' : separator);
  }
});

var fixRegExpWellKnownSymbolLogic$1 = fixRegexpWellKnownSymbolLogic;
var anObject$1 = anObject$b;
var toLength$1 = toLength$7;
var requireObjectCoercible$1 = requireObjectCoercible$8;
var advanceStringIndex$1 = advanceStringIndex$3;
var regExpExec$1 = regexpExecAbstract; // @@match logic

fixRegExpWellKnownSymbolLogic$1('match', 1, function (MATCH, nativeMatch, maybeCallNative) {
  return [// `String.prototype.match` method
  // https://tc39.es/ecma262/#sec-string.prototype.match
  function match(regexp) {
    var O = requireObjectCoercible$1(this);
    var matcher = regexp == undefined ? undefined : regexp[MATCH];
    return matcher !== undefined ? matcher.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));
  }, // `RegExp.prototype[@@match]` method
  // https://tc39.es/ecma262/#sec-regexp.prototype-@@match
  function (regexp) {
    var res = maybeCallNative(nativeMatch, regexp, this);
    if (res.done) return res.value;
    var rx = anObject$1(regexp);
    var S = String(this);
    if (!rx.global) return regExpExec$1(rx, S);
    var fullUnicode = rx.unicode;
    rx.lastIndex = 0;
    var A = [];
    var n = 0;
    var result;

    while ((result = regExpExec$1(rx, S)) !== null) {
      var matchStr = String(result[0]);
      A[n] = matchStr;
      if (matchStr === '') rx.lastIndex = advanceStringIndex$1(S, toLength$1(rx.lastIndex), fullUnicode);
      n++;
    }

    return n === 0 ? null : A;
  }];
});

var toObject$1 = toObject$5;
var floor = Math.floor;
var replace = ''.replace;
var SUBSTITUTION_SYMBOLS = /\$([$&'`]|\d{1,2}|<[^>]*>)/g;
var SUBSTITUTION_SYMBOLS_NO_NAMED = /\$([$&'`]|\d{1,2})/g; // https://tc39.es/ecma262/#sec-getsubstitution

var getSubstitution$1 = function (matched, str, position, captures, namedCaptures, replacement) {
  var tailPos = position + matched.length;
  var m = captures.length;
  var symbols = SUBSTITUTION_SYMBOLS_NO_NAMED;

  if (namedCaptures !== undefined) {
    namedCaptures = toObject$1(namedCaptures);
    symbols = SUBSTITUTION_SYMBOLS;
  }

  return replace.call(replacement, symbols, function (match, ch) {
    var capture;

    switch (ch.charAt(0)) {
      case '$':
        return '$';

      case '&':
        return matched;

      case '`':
        return str.slice(0, position);

      case "'":
        return str.slice(tailPos);

      case '<':
        capture = namedCaptures[ch.slice(1, -1)];
        break;

      default:
        // \d\d?
        var n = +ch;
        if (n === 0) return match;

        if (n > m) {
          var f = floor(n / 10);
          if (f === 0) return match;
          if (f <= m) return captures[f - 1] === undefined ? ch.charAt(1) : captures[f - 1] + ch.charAt(1);
          return match;
        }

        capture = captures[n - 1];
    }

    return capture === undefined ? '' : capture;
  });
};

var fixRegExpWellKnownSymbolLogic = fixRegexpWellKnownSymbolLogic;
var anObject = anObject$b;
var toLength = toLength$7;
var toInteger = toInteger$4;
var requireObjectCoercible = requireObjectCoercible$8;
var advanceStringIndex = advanceStringIndex$3;
var getSubstitution = getSubstitution$1;
var regExpExec = regexpExecAbstract;
var max = Math.max;
var min = Math.min;

var maybeToString = function (it) {
  return it === undefined ? it : String(it);
}; // @@replace logic


fixRegExpWellKnownSymbolLogic('replace', 2, function (REPLACE, nativeReplace, maybeCallNative, reason) {
  var REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE = reason.REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE;
  var REPLACE_KEEPS_$0 = reason.REPLACE_KEEPS_$0;
  var UNSAFE_SUBSTITUTE = REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE ? '$' : '$0';
  return [// `String.prototype.replace` method
  // https://tc39.es/ecma262/#sec-string.prototype.replace
  function replace(searchValue, replaceValue) {
    var O = requireObjectCoercible(this);
    var replacer = searchValue == undefined ? undefined : searchValue[REPLACE];
    return replacer !== undefined ? replacer.call(searchValue, O, replaceValue) : nativeReplace.call(String(O), searchValue, replaceValue);
  }, // `RegExp.prototype[@@replace]` method
  // https://tc39.es/ecma262/#sec-regexp.prototype-@@replace
  function (regexp, replaceValue) {
    if (!REGEXP_REPLACE_SUBSTITUTES_UNDEFINED_CAPTURE && REPLACE_KEEPS_$0 || typeof replaceValue === 'string' && replaceValue.indexOf(UNSAFE_SUBSTITUTE) === -1) {
      var res = maybeCallNative(nativeReplace, regexp, this, replaceValue);
      if (res.done) return res.value;
    }

    var rx = anObject(regexp);
    var S = String(this);
    var functionalReplace = typeof replaceValue === 'function';
    if (!functionalReplace) replaceValue = String(replaceValue);
    var global = rx.global;

    if (global) {
      var fullUnicode = rx.unicode;
      rx.lastIndex = 0;
    }

    var results = [];

    while (true) {
      var result = regExpExec(rx, S);
      if (result === null) break;
      results.push(result);
      if (!global) break;
      var matchStr = String(result[0]);
      if (matchStr === '') rx.lastIndex = advanceStringIndex(S, toLength(rx.lastIndex), fullUnicode);
    }

    var accumulatedResult = '';
    var nextSourcePosition = 0;

    for (var i = 0; i < results.length; i++) {
      result = results[i];
      var matched = String(result[0]);
      var position = max(min(toInteger(result.index), S.length), 0);
      var captures = []; // NOTE: This is equivalent to
      //   captures = result.slice(1).map(maybeToString)
      // but for some reason `nativeSlice.call(result, 1, result.length)` (called in
      // the slice polyfill when slicing native arrays) "doesn't work" in safari 9 and
      // causes a crash (https://pastebin.com/N21QzeQA) when trying to debug it.

      for (var j = 1; j < result.length; j++) captures.push(maybeToString(result[j]));

      var namedCaptures = result.groups;

      if (functionalReplace) {
        var replacerArgs = [matched].concat(captures, position, S);
        if (namedCaptures !== undefined) replacerArgs.push(namedCaptures);
        var replacement = String(replaceValue.apply(undefined, replacerArgs));
      } else {
        replacement = getSubstitution(matched, S, position, captures, namedCaptures, replaceValue);
      }

      if (position >= nextSourcePosition) {
        accumulatedResult += S.slice(nextSourcePosition, position) + replacement;
        nextSourcePosition = position + matched.length;
      }
    }

    return accumulatedResult + S.slice(nextSourcePosition);
  }];
});

var getParsedDate = function getParsedDate(_ref) {
  var formatStr = _ref.formatStr,
      dateStr = _ref.dateStr,
      translation = _ref.translation;
  var splitter = formatStr.match(/-|\/|\s|\./) || ['-'];
  var df = formatStr.split(splitter[0]);
  var ds = dateStr.split(splitter[0]);
  var ymd = [new Date().getFullYear(), '01', '01'];

  for (var i = 0; i < df.length; i += 1) {
    if (/yyyy/i.test(df[i])) {
      ymd[0] = ds[i];
    } else if (/mmmm/i.test(df[i])) {
      ymd[1] = translation.getMonthByName(ds[i]);
    } else if (/mmm/i.test(df[i])) {
      ymd[1] = translation.getMonthByAbbrName(ds[i]);
    } else if (/mm/i.test(df[i])) {
      ymd[1] = ds[i];
    } else if (/m/i.test(df[i])) {
      ymd[1] = ds[i];
    } else if (/dd/i.test(df[i])) {
      ymd[2] = ds[i];
    } else if (/d/i.test(df[i])) {
      var tmp = ds[i].replace(/st|rd|nd|th/g, '');
      ymd[2] = tmp < 10 ? "0".concat(tmp) : "".concat(tmp);
    }
  }

  return ymd;
};

var utils = {
  /**
   * @type {Boolean}
   */
  useUtc: false,

  /**
   * Returns the full year, using UTC or not
   * @param {Date} date
   */
  getFullYear: function getFullYear(date) {
    return this.useUtc ? date.getUTCFullYear() : date.getFullYear();
  },

  /**
   * Returns the month, using UTC or not
   * @param {Date} date
   */
  getMonth: function getMonth(date) {
    return this.useUtc ? date.getUTCMonth() : date.getMonth();
  },

  /**
   * Returns the number of days in the month, using UTC or not
   * @param {Date} date
   */
  getDaysInMonth: function getDaysInMonth(date) {
    return this.daysInMonth(this.getFullYear(date), this.getMonth(date));
  },

  /**
   * Returns the date, using UTC or not
   * @param {Date} date
   */
  getDate: function getDate(date) {
    return this.useUtc ? date.getUTCDate() : date.getDate();
  },

  /**
   * Returns the day, using UTC or not
   * @param {Date} date
   */
  getDay: function getDay(date) {
    return this.useUtc ? date.getUTCDay() : date.getDay();
  },

  /**
   * Returns the hours, using UTC or not
   * @param {Date} date
   */
  getHours: function getHours(date) {
    return this.useUtc ? date.getUTCHours() : date.getHours();
  },

  /**
   * Returns the minutes, using UTC or not
   * @param {Date} date
   */
  getMinutes: function getMinutes(date) {
    return this.useUtc ? date.getUTCMinutes() : date.getMinutes();
  },

  /**
   * Sets the full year, using UTC or not
   * @param {Date} date
   * @param {String, Number} value
   */
  setFullYear: function setFullYear(date, value) {
    return this.useUtc ? date.setUTCFullYear(value) : date.setFullYear(value);
  },

  /**
   * Sets the month, using UTC or not
   * @param {Date} date
   * @param {String, Number} value
   */
  setMonth: function setMonth(date, value) {
    return this.useUtc ? date.setUTCMonth(value) : date.setMonth(value);
  },

  /**
   * Sets the date, using UTC or not
   * @param {Date} date
   * @param {String, Number} value
   */
  setDate: function setDate(date, value) {
    return this.useUtc ? date.setUTCDate(value) : date.setDate(value);
  },

  /**
   * Check if date1 is equivalent to date2, without comparing the time
   * @see https://stackoverflow.com/a/6202196/4455925
   * @param {Date} date1
   * @param {Date} date2
   */
  compareDates: function compareDates(date1, date2) {
    var d1 = new Date(date1.valueOf());
    var d2 = new Date(date2.valueOf());
    this.resetDateTime(d1);
    this.resetDateTime(d2);
    return d1.valueOf() === d2.valueOf();
  },

  /**
   * Validates a date object
   * @param {Date} date - an object instantiated with the new Date constructor
   * @return {Boolean}
   */
  isValidDate: function isValidDate(date) {
    if (Object.prototype.toString.call(date) !== '[object Date]') {
      return false;
    }

    return !Number.isNaN(date.valueOf());
  },

  /**
   * Return abbreviated week day name
   * @param {Date} date
   * @param {Array} days
   * @return {String}
   */
  getDayNameAbbr: function getDayNameAbbr(date, days) {
    if (_typeof(date) !== 'object') {
      throw TypeError('Invalid Type');
    }

    return days[this.getDay(date)];
  },

  /**
   * Return day number from abbreviated week day name
   * @param {String} abbr
   * @return {Number}
   */
  getDayFromAbbr: function getDayFromAbbr(abbr) {
    for (var i = 0; i < en.days.length; i += 1) {
      if (abbr.toLowerCase() === en.days[i].toLowerCase()) {
        return i;
      }
    }

    throw TypeError('Invalid week day');
  },

  /**
   * Return name of the month
   * @param {Number|Date} month
   * @param {Array} months
   * @return {String}
   */
  getMonthName: function getMonthName(month, months) {
    if (!months) {
      throw Error('missing 2nd parameter Months array');
    }

    if (_typeof(month) === 'object') {
      return months[this.getMonth(month)];
    }

    if (typeof month === 'number') {
      return months[month];
    }

    throw TypeError('Invalid type');
  },

  /**
   * Return an abbreviated version of the month
   * @param {Number|Date} month
   * @param {Array} monthsAbbr
   * @return {String}
   */
  getMonthNameAbbr: function getMonthNameAbbr(month, monthsAbbr) {
    if (!monthsAbbr) {
      throw Error('missing 2nd parameter Months array');
    }

    if (_typeof(month) === 'object') {
      return monthsAbbr[this.getMonth(month)];
    }

    if (typeof month === 'number') {
      return monthsAbbr[month];
    }

    throw TypeError('Invalid type');
  },

  /**
   * Alternative get total number of days in month
   * @param {Number} year
   * @param {Number} month
   * @return {Number}
   */
  // eslint-disable-next-line complexity
  daysInMonth: function daysInMonth(year, month) {
    if (/8|3|5|10/.test(month.toString())) {
      return 30;
    }

    if (month === 1) {
      return !(year % 4) && year % 100 || !(year % 400) ? 29 : 28;
    }

    return 31;
  },

  /**
   * Get nth suffix for date
   * @param {Number} day
   * @return {String}
   */
  // eslint-disable-next-line complexity
  getNthSuffix: function getNthSuffix(day) {
    switch (day) {
      case 1:
      case 21:
      case 31:
        return 'st';

      case 2:
      case 22:
        return 'nd';

      case 3:
      case 23:
        return 'rd';

      default:
        return 'th';
    }
  },

  /**
   * Formats date object
   * @param {Date} date
   * @param {String} formatStr
   * @param {Object} translation
   * @return {String}
   */
  formatDate: function formatDate(date, formatStr) {
    var translation = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : en;
    var year = this.getFullYear(date);
    var month = this.getMonth(date) + 1;
    var day = this.getDate(date);
    var matches = {
      dd: "0".concat(day).slice(-2),
      d: day,
      yyyy: year,
      yy: String(year).slice(2),
      MMMM: this.getMonthName(this.getMonth(date), translation.months),
      MMM: this.getMonthNameAbbr(this.getMonth(date), translation.monthsAbbr),
      MM: "0".concat(month).slice(-2),
      M: month,
      o: this.getNthSuffix(this.getDate(date)),
      E: this.getDayNameAbbr(date, translation.days)
    };
    var REGEX_FORMAT = /y{4}|y{2}|M{1,4}(?![aäe])|d{1,2}|o|E(?![eéi])/g;
    return formatStr.replace(REGEX_FORMAT, function (match) {
      return matches[match] || match;
    });
  },

  /**
   * makes date parseable
   * to use with international dates
   * @param {String} dateStr
   * @param {String|Function} formatStr
   * @param {Object} translation
   * @param {Function} parser
   * @return {Date | String}
   */
  // eslint-disable-next-line max-params,complexity,max-statements
  parseDate: function parseDate(dateStr, formatStr) {
    var translation = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : en;
    var parser = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

    if (!(dateStr && formatStr)) {
      return dateStr;
    }

    if (typeof formatStr === 'function') {
      if (!parser || typeof parser !== 'function') {
        throw new Error('Parser needs to be a function if you are using a custom formatter');
      }

      return parser(dateStr);
    }

    var ymd = getParsedDate({
      formatStr: formatStr,
      dateStr: dateStr,
      translation: translation
    });
    var dat = "".concat(ymd.join('-')).concat(this.getTime());

    if (Number.isNaN(Date.parse(dat))) {
      return dateStr;
    }

    return dat;
  },
  getTime: function getTime() {
    var time = 'T00:00:00';

    if (this.useUtc) {
      return "".concat(time, "Z");
    }

    return time;
  },

  /**
   * Creates an array of dates for each day in between two dates.
   * @param {Date} start
   * @param {Date} end
   * @return {Array}
   */
  createDateArray: function createDateArray(start, end) {
    var dates = [];
    var startTemp = start;

    while (startTemp <= end) {
      dates.push(new Date(startTemp));
      startTemp = this.setDate(new Date(startTemp), this.getDate(new Date(startTemp)) + 1);
    }

    return dates;
  },

  /**
   * Remove hours/minutes/seconds/milliseconds from a date object
   * @param {Date} date
   * @return {Date}
   */
  resetDateTime: function resetDateTime(date) {
    return new Date(this.useUtc ? date.setUTCHours(0, 0, 0, 0) : date.setHours(0, 0, 0, 0));
  },

  /**
   * Return a new date object with hours/minutes/seconds/milliseconds removed.
   * Defaults to today's date, if no parameter is provided
   * @param {Date=} date
   * @return {Date}
   */
  getNewDateObject: function getNewDateObject(date) {
    return date ? this.resetDateTime(new Date(date)) : this.resetDateTime(new Date());
  }
};
var makeDateUtils = (function (useUtc) {
  return _objectSpread2(_objectSpread2({}, utils), {}, {
    useUtc: useUtc
  });
});

var script$b = {
  props: {
    autofocus: {
      type: Boolean,
      default: false
    },
    bootstrapStyling: {
      type: Boolean,
      default: false
    },
    clearButton: {
      type: Boolean,
      default: false
    },
    clearButtonIcon: {
      type: String,
      default: ''
    },
    calendarButton: {
      type: Boolean,
      default: false
    },
    calendarButtonIcon: {
      type: String,
      default: ''
    },
    calendarButtonIconContent: {
      type: String,
      default: ''
    },
    disabled: {
      type: Boolean,
      default: false
    },
    format: {
      type: [String, Function],
      default: 'dd MMM yyyy'
    },
    id: {
      type: String,
      default: null
    },
    inline: {
      type: Boolean,
      default: false
    },
    inputClass: {
      type: [String, Object, Array],
      default: null
    },
    maxlength: {
      type: [Number, String],
      default: null
    },
    name: {
      type: String,
      default: null
    },
    openDate: {
      type: [String, Date, Number],
      default: null,
      validator: function validator(val) {
        return val === null || val instanceof Date || typeof val === 'string' || typeof val === 'number';
      }
    },
    parser: {
      type: Function,
      default: null
    },
    pattern: {
      type: String,
      default: null
    },
    placeholder: {
      type: String,
      default: null
    },
    refName: {
      type: String,
      default: ''
    },
    required: {
      type: Boolean,
      default: false
    },
    showCalendarOnButtonClick: {
      type: Boolean,
      default: false
    },
    showCalendarOnFocus: {
      type: Boolean,
      default: false
    },
    tabindex: {
      type: [Number, String],
      default: null
    },
    typeable: {
      type: Boolean,
      default: false
    },
    useUtc: {
      type: Boolean,
      default: false
    }
  }
};

function normalizeComponent(template, style, script, scopeId, isFunctionalTemplate, moduleIdentifier /* server only */, shadowMode, createInjector, createInjectorSSR, createInjectorShadow) {
    if (typeof shadowMode !== 'boolean') {
        createInjectorSSR = createInjector;
        createInjector = shadowMode;
        shadowMode = false;
    }
    // Vue.extend constructor export interop.
    const options = typeof script === 'function' ? script.options : script;
    // render functions
    if (template && template.render) {
        options.render = template.render;
        options.staticRenderFns = template.staticRenderFns;
        options._compiled = true;
        // functional template
        if (isFunctionalTemplate) {
            options.functional = true;
        }
    }
    // scopedId
    if (scopeId) {
        options._scopeId = scopeId;
    }
    let hook;
    if (moduleIdentifier) {
        // server build
        hook = function (context) {
            // 2.3 injection
            context =
                context || // cached call
                    (this.$vnode && this.$vnode.ssrContext) || // stateful
                    (this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext); // functional
            // 2.2 with runInNewContext: true
            if (!context && typeof __VUE_SSR_CONTEXT__ !== 'undefined') {
                context = __VUE_SSR_CONTEXT__;
            }
            // inject component styles
            if (style) {
                style.call(this, createInjectorSSR(context));
            }
            // register component module identifier for async chunk inference
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        // used by ssr in case component is cached and beforeCreate
        // never gets called
        options._ssrRegister = hook;
    }
    else if (style) {
        hook = shadowMode
            ? function (context) {
                style.call(this, createInjectorShadow(context, this.$root.$options.shadowRoot));
            }
            : function (context) {
                style.call(this, createInjector(context));
            };
    }
    if (hook) {
        if (options.functional) {
            // register for functional component in vue file
            const originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        }
        else {
            // inject component registration as beforeCreate hook
            const existing = options.beforeCreate;
            options.beforeCreate = existing ? [].concat(existing, hook) : [hook];
        }
    }
    return script;
}

/* script */
const __vue_script__$b = script$b;

/* template */

  /* style */
  const __vue_inject_styles__$b = undefined;
  /* scoped */
  const __vue_scope_id__$b = undefined;
  /* module identifier */
  const __vue_module_identifier__$b = undefined;
  /* functional template */
  const __vue_is_functional_template__$b = undefined;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$b = /*#__PURE__*/normalizeComponent(
    {},
    __vue_inject_styles__$b,
    __vue_script__$b,
    __vue_scope_id__$b,
    __vue_is_functional_template__$b,
    __vue_module_identifier__$b,
    false,
    undefined,
    undefined,
    undefined
  );

var script$a = {
  name: 'DateInput',
  mixins: [__vue_component__$b],
  props: {
    isOpen: {
      type: Boolean,
      default: false
    },
    selectedDate: {
      type: Date,
      default: null
    },
    translation: {
      type: Object,
      default: function _default() {
        return {};
      }
    }
  },
  data: function data() {
    return {
      input: null,
      isInputFocused: false,
      shouldToggleOnFocus: false,
      shouldToggleOnClick: true,
      parsedDate: null,
      typedDate: '',
      utils: makeDateUtils(this.useUtc)
    };
  },
  computed: {
    computedInputClass: function computedInputClass() {
      if (this.bootstrapStyling) {
        if (typeof this.inputClass === 'string') {
          return [this.inputClass, 'form-control'].join(' ');
        }

        return _objectSpread2({
          'form-control': true
        }, this.inputClass);
      }

      return this.inputClass;
    },
    formattedDate: function formattedDate() {
      if (!this.selectedDate) {
        return null;
      }

      return typeof this.format === 'function' ? this.format(new Date(this.selectedDate)) : this.utils.formatDate(new Date(this.selectedDate), this.format, this.translation);
    },
    formattedValue: function formattedValue() {
      if (!this.selectedDate) {
        return null;
      }

      if (this.typedDate.length) {
        return this.typedDate;
      }

      return this.formattedDate;
    }
  },
  watch: {
    showCalendarOnFocus: {
      immediate: true,
      handler: function handler(showCalendarOnFocus) {
        if (showCalendarOnFocus) {
          this.shouldToggleOnFocus = !this.isOpen;
        }
      }
    },
    isOpen: function isOpen(_isOpen, wasOpen) {
      var _this = this;

      this.$nextTick(function () {
        if (_this.showCalendarOnFocus) {
          if (_isOpen) {
            _this.shouldToggleOnFocus = false;
          }

          if (wasOpen && !_this.isInputFocused) {
            _this.shouldToggleOnFocus = true;
          }
        }
      });
    }
  },
  mounted: function mounted() {
    this.input = this.$el.querySelector('input');
  },
  methods: {
    /**
     * Emits a `clear-date` event
     */
    clearDate: function clearDate() {
      this.input.value = '';
      this.$emit('clear-date');
    },

    /**
     * Formats a typed date, or clears it if invalid
     */
    formatTypedDate: function formatTypedDate() {
      if (Number.isNaN(this.parsedDate)) {
        this.input.value = '';
        this.typedDate = '';
      } else {
        this.typedDate = this.formattedDate;
      }
    },

    /**
     * Validate typedDate and emit a `blur` event
     */
    handleInputBlur: function handleInputBlur() {
      if (this.showCalendarOnFocus && !this.isOpen) {
        this.shouldToggleOnFocus = true;
      }

      if (this.typeable) {
        this.formatTypedDate();
      }

      this.isInputFocused = false;
      this.$emit('blur');
    },

    /**
     * Resets `shouldToggleOnFocus` to true
     */
    handleButtonFocus: function handleButtonFocus() {
      if (this.showCalendarOnFocus) {
        this.shouldToggleOnFocus = true;
      }
    },

    /**
     * Clears the calendar when the `delete` or `backspace` key is pressed
     */
    handleDelete: function handleDelete() {
      if (!this.typeable && this.selectedDate) {
        this.clearDate();
      }
    },

    /**
     * Toggles the calendar (unless `show-calendar-on-button-click` is true)
     */
    handleInputClick: function handleInputClick() {
      if (this.showCalendarOnButtonClick) return;

      if (this.shouldToggleOnClick) {
        this.toggle();
      }
    },

    /**
     * Emits a `focus` event and opens the calendar when `show-calendar-on-focus` is true
     */
    handleInputFocus: function handleInputFocus() {
      var _this2 = this;

      this.isInputFocused = true;

      if (!this.isOpen && this.shouldToggleOnFocus) {
        this.shouldToggleOnClick = false;
      }

      if (this.shouldToggleOnFocus && !this.isOpen) {
        this.$emit('open');
        setTimeout(function () {
          _this2.shouldToggleOnClick = true;
        }, 300);
      }

      this.$emit('focus');
    },

    /**
     * Opens the calendar, or sets the focus to the next focusable element down
     */
    handleKeydownDown: function handleKeydownDown() {
      if (!this.isOpen) {
        this.$emit('open');
      }

      if (!this.typeable) {
        return;
      }

      this.$emit('set-focus', ['prev', 'up', 'next', 'tabbableCell']);
    },

    /**
     * Formats a typed date and closes the calendar
     */
    handleKeydownEnter: function handleKeydownEnter() {
      if (!this.typeable) {
        return;
      }

      this.formatTypedDate();

      if (this.isOpen) {
        this.$emit('close');
      }
    },

    /**
     * Closes the calendar
     */
    handleKeydownEscape: function handleKeydownEscape() {
      if (this.isOpen) {
        this.$emit('close');
      }
    },

    /**
     * Prevents scrolling when not typeable
     */
    handleKeydownSpace: function handleKeydownSpace(event) {
      if (!this.typeable) {
        event.preventDefault();
      }
    },

    /**
     * Parses a typed date and submits it, if valid
     * @param  {object}  event Used to exclude certain keystrokes
     */
    handleKeyup: function handleKeyup(event) {
      if (!this.typeable || ['Shift', 'Tab', 'ArrowUp', 'ArrowDown', 'ArrowLeft', 'ArrowRight'].includes(event.key)) {
        return;
      }

      if (this.input.value === '') {
        this.$emit('typed-date', null);
        return;
      }

      this.parsedDate = Date.parse(this.utils.parseDate(this.input.value, this.format, this.translation, this.parser));

      if (!Number.isNaN(this.parsedDate)) {
        this.typedDate = this.input.value;
        this.$emit('typed-date', new Date(this.parsedDate));
      }
    },

    /**
     * Toggles the calendar unless a typed date has been entered or `show-calendar-on-button-click` is true
     */
    handleKeyupSpace: function handleKeyupSpace(event) {
      if (this.typeable) {
        if (this.input.value === '') {
          this.toggle();
        }

        return;
      }

      event.preventDefault();

      if (!this.showCalendarOnButtonClick) {
        this.toggle();
      }
    },

    /**
     * Opens or closes the calendar
     */
    toggle: function toggle(calendarButton) {
      if (this.isOpen) {
        this.$emit('set-focus', [calendarButton || 'input']);
      }

      this.$emit(this.isOpen ? 'close' : 'open');
    }
  }
};

/* script */
const __vue_script__$a = script$a;

/* template */
var __vue_render__$7 = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "div",
    { class: { "input-group": _vm.bootstrapStyling } },
    [
      _vm._t("beforeDateInput"),
      _vm._v(" "),
      _vm.calendarButton
        ? _c(
            "button",
            {
              ref: "calendarButton",
              staticClass: "vdp-datepicker__calendar-button",
              class: { "btn input-group-prepend": _vm.bootstrapStyling },
              attrs: {
                "data-test-calendar-button": "",
                disabled: _vm.disabled,
                type: "button",
              },
              on: {
                click: function ($event) {
                  return _vm.toggle("calendarButton")
                },
                focus: _vm.handleButtonFocus,
              },
            },
            [
              _c(
                "span",
                { class: { "input-group-text": _vm.bootstrapStyling } },
                [
                  _vm._t("calendarBtn", [
                    _c("i", { class: _vm.calendarButtonIcon }, [
                      _vm._v(
                        "\n          " +
                          _vm._s(_vm.calendarButtonIconContent) +
                          "\n          "
                      ),
                      !_vm.calendarButtonIcon
                        ? _c("span", [_vm._v("…")])
                        : _vm._e(),
                    ]),
                  ]),
                ],
                2
              ),
            ]
          )
        : _vm._e(),
      _vm._v(" "),
      _c("input", {
        ref: _vm.refName,
        class: _vm.computedInputClass,
        attrs: {
          id: _vm.id,
          autocomplete: "off",
          autofocus: _vm.autofocus,
          "clear-button": _vm.clearButton,
          "data-test-input": "",
          disabled: _vm.disabled,
          maxlength: _vm.maxlength,
          name: _vm.name,
          pattern: _vm.pattern,
          placeholder: _vm.placeholder,
          readonly: !_vm.typeable,
          required: _vm.required,
          tabindex: _vm.tabindex,
          type: _vm.inline ? "hidden" : null,
        },
        domProps: { value: _vm.formattedValue },
        on: {
          blur: _vm.handleInputBlur,
          click: _vm.handleInputClick,
          focus: _vm.handleInputFocus,
          keydown: [
            function ($event) {
              if (
                !$event.type.indexOf("key") &&
                _vm._k(
                  $event.keyCode,
                  "backspace",
                  undefined,
                  $event.key,
                  undefined
                )
              ) {
                return null
              }
              return _vm.handleDelete($event)
            },
            function ($event) {
              if (
                !$event.type.indexOf("key") &&
                _vm._k($event.keyCode, "delete", [8, 46], $event.key, [
                  "Backspace",
                  "Delete",
                  "Del",
                ])
              ) {
                return null
              }
              return _vm.handleDelete($event)
            },
            function ($event) {
              if (
                !$event.type.indexOf("key") &&
                _vm._k($event.keyCode, "down", 40, $event.key, [
                  "Down",
                  "ArrowDown",
                ])
              ) {
                return null
              }
              $event.preventDefault();
              return _vm.handleKeydownDown($event)
            },
            function ($event) {
              if (
                !$event.type.indexOf("key") &&
                _vm._k($event.keyCode, "enter", 13, $event.key, "Enter")
              ) {
                return null
              }
              $event.preventDefault();
              return _vm.handleKeydownEnter($event)
            },
            function ($event) {
              if (
                !$event.type.indexOf("key") &&
                _vm._k($event.keyCode, "esc", 27, $event.key, ["Esc", "Escape"])
              ) {
                return null
              }
              $event.preventDefault();
              return _vm.handleKeydownEscape($event)
            },
            function ($event) {
              if (
                !$event.type.indexOf("key") &&
                _vm._k($event.keyCode, "space", 32, $event.key, [
                  " ",
                  "Spacebar",
                ])
              ) {
                return null
              }
              return _vm.handleKeydownSpace($event)
            },
          ],
          keyup: [
            function ($event) {
              return _vm.handleKeyup($event)
            },
            function ($event) {
              if (
                !$event.type.indexOf("key") &&
                _vm._k($event.keyCode, "space", 32, $event.key, [
                  " ",
                  "Spacebar",
                ])
              ) {
                return null
              }
              return _vm.handleKeyupSpace($event)
            },
          ],
        },
      }),
      _vm._v(" "),
      _vm.clearButton && _vm.selectedDate
        ? _c(
            "button",
            {
              staticClass: "vdp-datepicker__clear-button",
              class: { "btn input-group-append": _vm.bootstrapStyling },
              attrs: {
                "data-test-clear-button": "",
                disabled: _vm.disabled,
                type: "button",
              },
              on: { click: _vm.clearDate },
            },
            [
              _c(
                "span",
                { class: { "input-group-text": _vm.bootstrapStyling } },
                [
                  _vm._t("clearBtn", [
                    _c("i", { class: _vm.clearButtonIcon }, [
                      !_vm.clearButtonIcon
                        ? _c("span", [_vm._v("×")])
                        : _vm._e(),
                    ]),
                  ]),
                ],
                2
              ),
            ]
          )
        : _vm._e(),
      _vm._v(" "),
      _vm._t("afterDateInput"),
    ],
    2
  )
};
var __vue_staticRenderFns__$7 = [];
__vue_render__$7._withStripped = true;

  /* style */
  const __vue_inject_styles__$a = undefined;
  /* scoped */
  const __vue_scope_id__$a = undefined;
  /* module identifier */
  const __vue_module_identifier__$a = undefined;
  /* functional template */
  const __vue_is_functional_template__$a = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$a = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$7, staticRenderFns: __vue_staticRenderFns__$7 },
    __vue_inject_styles__$a,
    __vue_script__$a,
    __vue_scope_id__$a,
    __vue_is_functional_template__$a,
    __vue_module_identifier__$a,
    false,
    undefined,
    undefined,
    undefined
  );

var $$3 = _export;
var toObject = toObject$5;
var nativeKeys = objectKeys$1;
var fails$1 = fails$e;
var FAILS_ON_PRIMITIVES = fails$1(function () {
  nativeKeys(1);
}); // `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys

$$3({
  target: 'Object',
  stat: true,
  forced: FAILS_ON_PRIMITIVES
}, {
  keys: function keys(it) {
    return nativeKeys(toObject(it));
  }
});

var cellUtils = {
  configExists: function configExists(obj) {
    return typeof obj !== 'undefined' && Object.keys(obj).length > 0;
  },
  isDefined: function isDefined(obj, prop) {
    return this.configExists(obj) && typeof obj[prop] !== 'undefined';
  },
  hasArray: function hasArray(obj, prop) {
    return this.isDefined(obj, prop) && obj[prop].length > 0;
  },
  hasDate: function hasDate(obj, prop) {
    return this.isDefined(obj, prop) && this.utils.isValidDate(obj[prop]);
  },
  dayMonthYear: function dayMonthYear(obj, prop) {
    var utils = this.utils;
    var hasDate = this.hasDate(obj, prop);

    if (!hasDate) {
      return {
        day: undefined,
        month: undefined,
        year: undefined
      };
    }

    var d = obj[prop];
    return {
      day: utils.getDate(d),
      month: utils.getMonth(d),
      year: utils.getFullYear(d)
    };
  }
};
var makeCellUtils = (function (utils) {
  return _objectSpread2(_objectSpread2({}, cellUtils), {}, {
    utils: utils
  });
});

var DisabledDate = /*#__PURE__*/function () {
  function DisabledDate(utils, disabledDates) {
    _classCallCheck(this, DisabledDate);

    this._utils = utils;
    this._disabledDates = disabledDates;
  }

  _createClass(DisabledDate, [{
    key: "config",
    get: function get() {
      var disabledDates = this._disabledDates;
      var utils = makeCellUtils(this._utils);
      return {
        exists: utils.configExists(disabledDates),
        to: utils.dayMonthYear(disabledDates, 'to'),
        from: utils.dayMonthYear(disabledDates, 'from'),
        has: {
          customPredictor: utils.isDefined(disabledDates, 'customPredictor'),
          daysOfMonth: utils.hasArray(disabledDates, 'daysOfMonth'),
          daysOfWeek: utils.hasArray(disabledDates, 'days'),
          from: utils.hasDate(disabledDates, 'from'),
          ranges: utils.hasArray(disabledDates, 'ranges'),
          specificDates: utils.hasArray(disabledDates, 'dates'),
          to: utils.hasDate(disabledDates, 'to')
        }
      };
    }
  }, {
    key: "daysInMonth",
    value: function daysInMonth(date) {
      var utils = this._utils;
      var month = utils.getMonth(date);
      var year = utils.getFullYear(date);
      return utils.daysInMonth(year, month);
    }
  }, {
    key: "isDateDisabledVia",
    value: function isDateDisabledVia(date) {
      var _this = this;

      var disabledDates = this._disabledDates;
      var has = this.config.has;
      return {
        to: function to() {
          return has.to && date < disabledDates.to;
        },
        from: function from() {
          return has.from && date > disabledDates.from;
        },
        range: function range() {
          if (!has.ranges) return false;
          var ranges = disabledDates.ranges;
          var u = makeCellUtils(_this._utils);
          return ranges.some(function (thisRange) {
            var hasFrom = u.isDefined(thisRange, 'from');
            var hasTo = u.isDefined(thisRange, 'to');
            return hasFrom && hasTo && date < thisRange.to && date > thisRange.from;
          });
        },
        customPredictor: function customPredictor() {
          return has.customPredictor && disabledDates.customPredictor(date);
        },
        specificDate: function specificDate() {
          if (!has.specificDates) return false;
          return disabledDates.dates.some(function (d) {
            return _this._utils.compareDates(date, d);
          });
        },
        daysOfWeek: function daysOfWeek() {
          if (!has.daysOfWeek) return false;
          return disabledDates.days.indexOf(_this._utils.getDay(date)) !== -1;
        },
        daysOfMonth: function daysOfMonth() {
          if (!has.daysOfMonth) return false;
          return disabledDates.daysOfMonth.indexOf(_this._utils.getDate(date)) !== -1;
        }
      };
    }
  }, {
    key: "isMonthDisabledVia",
    value: function isMonthDisabledVia(date) {
      var _this$config = this.config,
          _from = _this$config.from,
          has = _this$config.has,
          _to = _this$config.to;

      var month = this._utils.getMonth(date);

      var year = this._utils.getFullYear(date);

      return {
        to: function to() {
          var isYearInPast = has.to && year < _to.year;

          if (isYearInPast) {
            return true;
          }

          return has.to && month < _to.month && year <= _to.year;
        },
        from: function from() {
          var isYearInFuture = has.from && year > _from.year;

          if (isYearInFuture) {
            return true;
          }

          return has.from && month > _from.month && year >= _from.year;
        }
      };
    }
  }, {
    key: "isYearDisabledVia",
    value: function isYearDisabledVia(date) {
      var _this$config2 = this.config,
          _from2 = _this$config2.from,
          has = _this$config2.has,
          _to2 = _this$config2.to;

      var year = this._utils.getFullYear(date);

      return {
        to: function to() {
          return has.to && year < _to2.year;
        },
        from: function from() {
          return has.from && year > _from2.year;
        }
      };
    }
    /**
     * Checks if the given date should be disabled
     * @param {Date} date
     * @return {Boolean}
     */
    // eslint-disable-next-line complexity,max-statements

  }, {
    key: "isDateDisabled",
    value: function isDateDisabled(date) {
      if (!this.config.exists) return false;
      var isDisabledVia = this.isDateDisabledVia(date);
      return isDisabledVia.to() || isDisabledVia.from() || isDisabledVia.range() || isDisabledVia.specificDate() || isDisabledVia.daysOfWeek() || isDisabledVia.daysOfMonth() || isDisabledVia.customPredictor();
    }
    /**
     * Checks if the given month should be disabled
     * @param {Date} date
     * @return {Boolean}
     */
    // eslint-disable-next-line complexity,max-statements

  }, {
    key: "isMonthDisabled",
    value: function isMonthDisabled(date) {
      var config = this.config;
      var isDisabledVia = this.isMonthDisabledVia(date);

      if (!config.exists) {
        return false;
      }

      if (isDisabledVia.to() || isDisabledVia.from()) {
        return true;
      } // now we have to check each day of the month


      for (var i = 1; i <= this.daysInMonth(date); i += 1) {
        var dayDate = new Date(date);
        dayDate.setDate(i); // if at least one day of this month is NOT disabled,
        // we can conclude that this month SHOULD be selectable

        if (!this.isDateDisabled(dayDate)) {
          return false;
        }
      }

      return true;
    }
    /**
     * Checks if the given year should be disabled
     * @param {Date} date
     * @return {Boolean}
     */
    // eslint-disable-next-line complexity,max-statements

  }, {
    key: "isYearDisabled",
    value: function isYearDisabled(date) {
      var config = this.config;
      var isDisabledVia = this.isYearDisabledVia(date);

      if (!config.exists) {
        return false;
      }

      if (isDisabledVia.to() || isDisabledVia.from()) {
        return true;
      } // now we have to check each month of the year


      for (var i = 0; i < 12; i += 1) {
        var monthDate = new Date(date);
        monthDate.setMonth(i); // if at least one month of this year is NOT disabled,
        // we can conclude that this year SHOULD be selectable

        if (!this.isMonthDisabled(monthDate)) {
          return false;
        }
      }

      return true;
    }
  }, {
    key: "getEarliestPossibleDate",
    value: function getEarliestPossibleDate(date) {
      if (!date) {
        return null;
      }

      var utils = this._utils;

      if (this.isDateDisabled(date)) {
        var nextDate = new Date(utils.getFullYear(date), utils.getMonth(date), utils.getDate(date) + 1);
        return this.getEarliestPossibleDate(nextDate);
      }

      return date;
    }
  }, {
    key: "getLatestPossibleDate",
    value: function getLatestPossibleDate(date) {
      if (!date) {
        return null;
      }

      var utils = this._utils;

      if (this.isDateDisabled(date)) {
        var nextDate = new Date(utils.getFullYear(date), utils.getMonth(date), utils.getDate(date) - 1);
        return this.getLatestPossibleDate(nextDate);
      }

      return date;
    }
  }]);

  return DisabledDate;
}();

var fails = fails$e;
var whitespaces = whitespaces$2;
var non = '\u200B\u0085\u180E'; // check that a method works with the correct list
// of whitespaces and has a correct name

var stringTrimForced = function (METHOD_NAME) {
  return fails(function () {
    return !!whitespaces[METHOD_NAME]() || non[METHOD_NAME]() != non || whitespaces[METHOD_NAME].name !== METHOD_NAME;
  });
};

var $$2 = _export;
var $trim = stringTrim.trim;
var forcedStringTrimMethod = stringTrimForced; // `String.prototype.trim` method
// https://tc39.es/ecma262/#sec-string.prototype.trim

$$2({
  target: 'String',
  proto: true,
  forced: forcedStringTrimMethod('trim')
}, {
  trim: function trim() {
    return $trim(this);
  }
});

var $$1 = _export;
var $filter = arrayIteration.filter;
var arrayMethodHasSpeciesSupport = arrayMethodHasSpeciesSupport$3;
var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter'); // `Array.prototype.filter` method
// https://tc39.es/ecma262/#sec-array.prototype.filter
// with adding support of @@species

$$1({
  target: 'Array',
  proto: true,
  forced: !HAS_SPECIES_SUPPORT
}, {
  filter: function filter(callbackfn
  /* , thisArg */
  ) {
    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var script$9 = {
  data: function data() {
    return {
      allElements: [],
      focus: {
        delay: 0,
        refs: []
      },
      inlineTabbableCell: null,
      isActive: false,
      isRevertingToOpenDate: false,
      navElements: [],
      navElementsFocusedIndex: 0,
      resetTabbableCell: false,
      tabbableCell: null,
      transitionName: ''
    };
  },
  computed: {
    fallbackElementsToFocus: function fallbackElementsToFocus() {
      var elements = ['tabbableCell', 'prev', 'next'];

      if (this.typeable) {
        elements.unshift('input');
      }

      return elements;
    },
    focusedDateTimestamp: function focusedDateTimestamp() {
      var pageDate = new Date(this.pageTimestamp);

      if (this.hasClass(this.tabbableCell, 'day')) {
        return this.utils.setDate(pageDate, this.tabbableCell.innerHTML.trim());
      }

      if (this.hasClass(this.tabbableCell, 'month')) {
        return this.utils.setMonth(pageDate, this.tabbableCellId);
      }

      var fullYear = this.utils.getFullYear(pageDate) - 1;
      return this.utils.setFullYear(pageDate, fullYear + this.tabbableCellId);
    },
    tabbableCellId: function tabbableCellId() {
      return this.tabbableCell && Number(this.tabbableCell.getAttribute('data-id'));
    }
  },
  methods: {
    /**
     * Returns true, unless tabbing should be focus-trapped
     * @return {Boolean}
     */
    allowNormalTabbing: function allowNormalTabbing(event) {
      if (!this.isOpen) {
        return true;
      }

      return this.isTabbingAwayFromInlineDatepicker(event);
    },

    /**
     * Focuses the first non-disabled element found in the `focus.refs` array and sets `navElementsFocusedIndex`
     */
    applyFocus: function applyFocus() {
      var focusRefs = [].concat(_toConsumableArray(this.focus.refs), _toConsumableArray(this.fallbackElementsToFocus));

      for (var i = 0; i < focusRefs.length; i += 1) {
        var element = this.getElementByRef(focusRefs[i]);

        if (element && !element.getAttribute('disabled')) {
          element.focus();
          this.setNavElementsFocusedIndex();
          break;
        }
      }
    },

    /**
     * Ensures the most recently focused tabbable cell is focused when tabbing backwards to an inline calendar
     * If no element has previously been focused, the tabbable cell is reset and focused
     */
    focusInlineTabbableCell: function focusInlineTabbableCell() {
      if (this.inlineTabbableCell) {
        this.inlineTabbableCell.focus();
        return;
      }

      this.resetTabbableCell = true;
      this.setTabbableCell();
      this.tabbableCell.focus();
      this.resetTabbableCell = false;
    },

    /**
     * Returns the currently focused cell element, if there is one...
     */
    getActiveCell: function getActiveCell() {
      var isActiveElementACell = this.hasClass(document.activeElement, 'cell');
      var isOnSameView = this.hasClass(document.activeElement, this.view);

      if (isActiveElementACell && isOnSameView && !this.resetTabbableCell) {
        return document.activeElement;
      }

      return null;
    },

    /**
     * Finds an element by its `ref` attribute
     * @param {string} ref        The `ref` name of the wanted element
     * @returns {HTMLElement|Vue} A Vue element
     */
    // eslint-disable-next-line complexity,max-statements
    getElementByRef: function getElementByRef(ref) {
      if (ref === 'tabbableCell') {
        return this.tabbableCell;
      }

      if (ref === 'input') {
        return this.$refs.dateInput && this.$refs.dateInput.$refs[this.refName];
      }

      if (ref === 'calendarButton') {
        return this.$refs.dateInput.$refs.calendarButton;
      }

      if (ref === 'openDate') {
        return this.$refs.picker.$refs.cells.$refs.openDate[0];
      }

      if (this.showHeader) {
        if (ref === 'up') {
          return this.$refs.picker && this.$refs.picker.$refs.up.$el;
        }

        return this.$refs.picker && this.$refs.picker.$refs.pickerHeader && this.$refs.picker.$refs.pickerHeader.$refs[ref];
      }

      return null;
    },

    /**
     * Returns an array of all HTML elements which should be focus-trapped in the calendarFooter slot
     * @returns {Array}   An array of HTML elements
     */
    getElementsFromCalendarFooter: function getElementsFromCalendarFooter() {
      var footerSlotIndex = this.hasSlot('beforeCalendarHeader') ? 2 : 1;
      return this.getFocusableElements(this.$refs.view.children[footerSlotIndex]);
    },

    /**
     * Returns an array of all HTML elements which should be focus-trapped in the specified slot
     * @returns {Array}   An array of HTML elements
     */
    getElementsFromSlot: function getElementsFromSlot(slotName) {
      if (!this.hasSlot(slotName)) {
        return [];
      }

      if (slotName === 'beforeCalendarHeader') {
        return this.getFocusableElements(this.$refs.view.children[0]);
      }

      if (slotName === 'calendarFooter') {
        return this.getElementsFromCalendarFooter();
      }

      var isBeforeHeader = slotName.indexOf('beforeCalendarHeader') > -1;
      var picker = this.$refs.picker.$el;
      var index = isBeforeHeader ? 0 : picker.children.length - 1;
      return this.getFocusableElements(picker.children[index]);
    },

    /**
     * Returns an array of all HTML elements which should be focus-trapped in the header
     * @returns {Array}   An array of HTML elements
     */
    getElementsFromHeader: function getElementsFromHeader() {
      var view = this.ucFirst(this.view);
      var beforeCalendarSlotName = "beforeCalendarHeader".concat(view);
      var picker = this.$refs.picker.$el;
      var index = this.hasSlot(beforeCalendarSlotName) ? 1 : 0;
      var fragment = picker.children[index];
      return this.showHeader ? this.getFocusableElements(fragment) : [];
    },

    /**
     * Returns an array of focusable elements in a given HTML fragment
     * @param   {Element} fragment The HTML fragment to search
     * @returns {Array}
     */
    getFocusableElements: function getFocusableElements(fragment) {
      var navNodeList = fragment.querySelectorAll('button:enabled, [href], input:not([type=hidden]), select:enabled, textarea:enabled, [tabindex]:not([tabindex="-1"])');
      return _toConsumableArray(Array.prototype.slice.call(navNodeList));
    },

    /**
     * Returns the input element (when typeable)
     * @returns {Element}
     */
    getInputField: function getInputField() {
      if (!this.typeable || this.inline) {
        return null;
      }

      return this.$refs.dateInput.$refs[this.refName];
    },

    /**
     * Sets `datepickerId` (as a global) and keeps track of focusable elements
     */
    handleFocusIn: function handleFocusIn() {
      document.datepickerId = this.datepickerId;
      this.isActive = true;
      this.setInlineTabbableCell();
      this.setAllElements();
      this.setNavElements();
    },

    /**
     * Sets the datepicker's `isActive` state to false
     */
    handleFocusOut: function handleFocusOut() {
      this.isActive = false;
    },

    /**
     * Returns true if the user has arrowed to a new page
     * @return {Boolean}
     */
    hasArrowedToNewPage: function hasArrowedToNewPage() {
      return this.focus.refs && this.focus.refs[0] === 'arrow-to-cell';
    },

    /**
     * Returns true if the calendar has been passed the given slot
     * @param  {String} slotName The name of the slot
     * @return {Boolean}
     */
    hasSlot: function hasSlot(slotName) {
      return !!this.$slots[slotName];
    },

    /**
     * Returns true if the user is tabbing away from an inline datepicker
     * @return {Boolean}
     */
    isTabbingAwayFromInlineDatepicker: function isTabbingAwayFromInlineDatepicker(event) {
      if (!this.inline) {
        return false;
      }

      if (this.isTabbingAwayFromFirstNavElement(event)) {
        this.tabAwayFromFirstElement();
        return true;
      }

      if (this.isTabbingAwayFromLastNavElement(event)) {
        this.tabAwayFromLastElement();
        return true;
      }

      return false;
    },

    /**
     * Used for inline calendars; returns true if the user tabs backwards from the first focusable element
     * @param  {object}  event Used to determine whether we are tabbing forwards or backwards
     * @return {Boolean}
     */
    isTabbingAwayFromFirstNavElement: function isTabbingAwayFromFirstNavElement(event) {
      if (!event.shiftKey) {
        return false;
      }

      var firstNavElement = this.navElements[0];
      return document.activeElement === firstNavElement;
    },

    /**
     * Used for inline calendars; returns true if the user tabs forwards from the last focusable element
     * @param  {object}  event Used to determine whether we are tabbing forwards or backwards
     * @return {Boolean}
     */
    isTabbingAwayFromLastNavElement: function isTabbingAwayFromLastNavElement(event) {
      if (event.shiftKey) {
        return false;
      }

      var lastNavElement = this.navElements[this.navElements.length - 1];
      return document.activeElement === lastNavElement;
    },

    /**
     * Resets the focus to the open date
     */
    resetFocusToOpenDate: function resetFocusToOpenDate() {
      this.focus.refs = ['openDate'];
      this.setTransitionAndFocusDelay(this.focusedDateTimestamp, this.computedOpenDate);

      if (!this.isMinimumView) {
        this.isRevertingToOpenDate = true;
        this.view = this.minimumView;
      }

      this.setPageDate(this.computedOpenDate);
      this.reviewFocus();
    },

    /**
     * Sets the correct focus on next tick
     */
    reviewFocus: function reviewFocus() {
      var _this = this;

      if (this.hasArrowedToNewPage()) {
        return;
      }

      this.tabbableCell = null;
      this.resetTabbableCell = true;
      this.$nextTick(function () {
        _this.setNavElements();

        setTimeout(function () {
          _this.applyFocus();
        }, _this.focus.delay);
        _this.resetTabbableCell = false;
      });
    },

    /**
     * Stores the current tabbableCell of an inline datepicker
     * N.B. This is used when tabbing back (shift + tab) to an inline calendar from further down the page
     */
    setInlineTabbableCell: function setInlineTabbableCell() {
      if (!this.inline) {
        return;
      }

      this.inlineTabbableCell = this.tabbableCell;
    },

    /**
     * Sets the direction of the slide transition and whether or not to delay application of the focus
     * @param {Date|Number} startDate     The date from which to measure
     * @param {Date|Number} endDate       Is this before or after the startDate? And is it on the same page?
     */
    setTransitionAndFocusDelay: function setTransitionAndFocusDelay(startDate, endDate) {
      var startPageDate = this.utils.setDate(new Date(startDate), 1);
      var endPageDate = this.utils.setDate(new Date(endDate), 1);
      var isInTheFuture = startPageDate < endPageDate;

      if (this.isMinimumView) {
        this.focus.delay = isInTheFuture ? this.slideDuration : 0;
      } else {
        this.focus.delay = 0;
      }

      this.setTransitionName(endDate - startDate);
    },

    /**
     * Records all focusable elements (so that we know whether any element in the datepicker is focused)
     */
    setAllElements: function setAllElements() {
      this.allElements = this.getFocusableElements(this.$refs.datepicker);

      if (this.appendToBody) {
        this.allElements = this.allElements.concat(this.getFocusableElements(this.$refs.popup.$el));
      }
    },

    /**
     * Set the focus
     * @param {Array} refs An array of `refs` to focus (in order of preference)
     */
    setFocus: function setFocus(refs) {
      this.focus.refs = refs;
      this.applyFocus();
    },

    /**
     * Determines which elements in datepicker should be focus-trapped
     */
    setNavElements: function setNavElements() {
      if (!this.view) return;
      this.updateTabbableCell();
      var view = this.ucFirst(this.view);
      this.navElements = [this.getElementsFromSlot('beforeDateInput'), this.getInputField(), this.getElementsFromSlot('afterDateInput'), this.getElementsFromSlot('beforeCalendarHeader'), this.getElementsFromSlot("beforeCalendarHeader".concat(view)), this.getElementsFromHeader(), this.tabbableCell, this.getElementsFromSlot("calendarFooter".concat(view)), this.getElementsFromSlot('calendarFooter')].filter(function (item) {
        return !!item;
      }).reduce(function (acc, val) {
        return acc.concat(val);
      }, []);
    },

    /**
     * Keeps track of the currently focused index in the navElements array
     */
    setNavElementsFocusedIndex: function setNavElementsFocusedIndex() {
      for (var i = 0; i < this.navElements.length; i += 1) {
        if (document.activeElement === this.navElements[i]) {
          this.navElementsFocusedIndex = i;
          return;
        }
      }

      this.navElementsFocusedIndex = 0;
    },

    /**
     * Sets the focus-trapped cell in the picker
     */
    // eslint-disable-next-line complexity
    setTabbableCell: function setTabbableCell() {
      if (!this.$refs.picker || !this.$refs.picker.$refs.cells) {
        return;
      }

      var pickerCells = this.$refs.picker.$refs.cells.$el;
      this.tabbableCell = this.getActiveCell() || pickerCells.querySelector('button.selected:not(.muted):enabled') || pickerCells.querySelector('button.open:not(.muted):enabled') || pickerCells.querySelector('button.today:not(.muted):enabled') || pickerCells.querySelector('button.cell:not(.muted):enabled');
    },

    /**
     * Sets the direction of the slide transition
     * @param {Number} plusOrMinus Positive for the future; negative for the past
     */
    setTransitionName: function setTransitionName(plusOrMinus) {
      var isInTheFuture = plusOrMinus > 0;

      if (this.isRtl) {
        this.transitionName = isInTheFuture ? 'slide-left' : 'slide-right';
      } else {
        this.transitionName = isInTheFuture ? 'slide-right' : 'slide-left';
      }
    },

    /**
     * Focuses the first focusable element in the datepicker, so that the previous element on the page will be tabbed to
     */
    tabAwayFromFirstElement: function tabAwayFromFirstElement() {
      var firstElement = this.allElements[0];
      firstElement.focus();
      this.tabbableCell = this.inlineTabbableCell;
    },

    /**
     * Focuses the last focusable element in the datepicker, so that the next element on the page will be tabbed to
     */
    tabAwayFromLastElement: function tabAwayFromLastElement() {
      var lastElement = this.allElements[this.allElements.length - 1];
      lastElement.focus();
      this.tabbableCell = this.inlineTabbableCell;
    },

    /**
     * Tab backwards through the focus-trapped elements
     */
    tabBackwards: function tabBackwards() {
      this.navElementsFocusedIndex -= 1;

      if (this.navElementsFocusedIndex < 0) {
        this.navElementsFocusedIndex = this.navElements.length - 1;
      }

      this.navElements[this.navElementsFocusedIndex].focus();
    },

    /**
     * Tab forwards through the focus-trapped elements
     */
    tabForwards: function tabForwards() {
      this.navElementsFocusedIndex += 1;

      if (this.navElementsFocusedIndex >= this.navElements.length) {
        this.navElementsFocusedIndex = 0;
      }

      this.navElements[this.navElementsFocusedIndex].focus();
    },

    /**
     * Tab through the focus-trapped elements
     * @param event
     */
    tabThroughNavigation: function tabThroughNavigation(event) {
      if (this.allowNormalTabbing(event)) {
        return;
      }

      event.preventDefault();

      if (event.shiftKey) {
        this.tabBackwards();
      } else {
        this.tabForwards();
      }
    },

    /**
     * Special cases for when tabbing to an inline datepicker
     */
    tabToCorrectInlineCell: function tabToCorrectInlineCell() {
      var _this2 = this;

      var lastElement = this.allElements[this.allElements.length - 1];
      var isACell = this.hasClass(lastElement, 'cell');
      var isLastElementFocused = document.activeElement === lastElement; // If there are no focusable elements in the footer slots and the inline datepicker has been tabbed to (backwards)

      if (isACell && isLastElementFocused) {
        this.focusInlineTabbableCell();
        return;
      } // If `show-header` is false and the inline datepicker has been tabbed to (forwards)


      this.$nextTick(function () {
        var isFirstCell = document.activeElement.getAttribute('data-id') === '0';

        if (isFirstCell) {
          _this2.focusInlineTabbableCell();
        }
      });
    },

    /**
     * Update which cell in the picker should be focus-trapped
     */
    updateTabbableCell: function updateTabbableCell() {
      var isActiveElementACell = this.hasClass(document.activeElement, 'cell');
      var needToUpdate = !this.tabbableCell || isActiveElementACell;

      if (needToUpdate) {
        this.setTabbableCell();
      }
    }
  }
};

/* script */
const __vue_script__$9 = script$9;

/* template */

  /* style */
  const __vue_inject_styles__$9 = undefined;
  /* scoped */
  const __vue_scope_id__$9 = undefined;
  /* module identifier */
  const __vue_module_identifier__$9 = undefined;
  /* functional template */
  const __vue_is_functional_template__$9 = undefined;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$9 = /*#__PURE__*/normalizeComponent(
    {},
    __vue_inject_styles__$9,
    __vue_script__$9,
    __vue_scope_id__$9,
    __vue_is_functional_template__$9,
    __vue_module_identifier__$9,
    false,
    undefined,
    undefined,
    undefined
  );

// https://tc39.es/ecma262/#sec-math.sign
// eslint-disable-next-line es/no-math-sign -- safe

var mathSign = Math.sign || function sign(x) {
  // eslint-disable-next-line no-self-compare -- NaN check
  return (x = +x) == 0 || x != x ? x : x < 0 ? -1 : 1;
};

var $ = _export;
var sign = mathSign; // `Math.sign` method
// https://tc39.es/ecma262/#sec-math.sign

$({
  target: 'Math',
  stat: true
}, {
  sign: sign
});

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var script$8 = {
  name: 'PickerHeader',
  props: {
    bootstrapStyling: {
      type: Boolean,
      default: false
    },
    isNextDisabled: {
      type: Boolean,
      required: true
    },
    isPreviousDisabled: {
      type: Boolean,
      required: true
    },
    isRtl: {
      type: Boolean,
      required: true
    }
  },
  data: function data() {
    return {
      previousPage: {
        incrementBy: -1,
        focusRefs: ['prev']
      },
      nextPage: {
        incrementBy: 1,
        focusRefs: ['next']
      }
    };
  },
  methods: {
    /**
     * Changes the page, or sets focus to the adjacent button
     */
    arrowLeftPrev: function arrowLeftPrev() {
      if (this.isRtl) {
        this.$emit('set-focus', ['up', 'next', 'tabbableCell']);
        return;
      }

      this.$emit('page-change', this.previousPage);
    },

    /**
     * Changes the page, or sets focus to the adjacent button
     */
    arrowRightPrev: function arrowRightPrev() {
      if (this.isRtl) {
        this.$emit('page-change', this.previousPage);
        return;
      }

      this.$emit('set-focus', ['up', 'next', 'tabbableCell']);
    },

    /**
     * Changes the page, or sets focus to the adjacent button
     */
    arrowLeftNext: function arrowLeftNext() {
      if (this.isRtl) {
        this.$emit('page-change', this.nextPage);
        return;
      }

      this.$emit('set-focus', ['up', 'prev', 'tabbableCell']);
    },

    /**
     * Changes the page, or sets focus to the adjacent button
     */
    arrowRightNext: function arrowRightNext() {
      if (this.isRtl) {
        this.$emit('set-focus', ['up', 'prev', 'tabbableCell']);
        return;
      }

      this.$emit('page-change', this.nextPage);
    },
    focusTabbableCell: function focusTabbableCell() {
      this.$emit('set-focus', ['tabbableCell']);
    }
  }
};

/* script */
const __vue_script__$8 = script$8;

/* template */
var __vue_render__$6 = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "header",
    [
      _c(
        "button",
        {
          ref: "prev",
          staticClass: "prev",
          class: { btn: _vm.bootstrapStyling, rtl: _vm.isRtl },
          attrs: {
            "data-test-previous-button": "",
            disabled: _vm.isPreviousDisabled,
            type: "button",
          },
          on: {
            click: function ($event) {
              $event.stopPropagation();
              return _vm.$emit("page-change", _vm.previousPage)
            },
            keydown: [
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "down", 40, $event.key, [
                    "Down",
                    "ArrowDown",
                  ])
                ) {
                  return null
                }
                $event.preventDefault();
                return _vm.focusTabbableCell($event)
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "up", 38, $event.key, [
                    "Up",
                    "ArrowUp",
                  ])
                ) {
                  return null
                }
                $event.preventDefault();
                return _vm.$emit("focus-input")
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "left", 37, $event.key, [
                    "Left",
                    "ArrowLeft",
                  ])
                ) {
                  return null
                }
                if ("button" in $event && $event.button !== 0) {
                  return null
                }
                $event.preventDefault();
                return _vm.arrowLeftPrev($event)
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "right", 39, $event.key, [
                    "Right",
                    "ArrowRight",
                  ])
                ) {
                  return null
                }
                if ("button" in $event && $event.button !== 2) {
                  return null
                }
                $event.preventDefault();
                return _vm.arrowRightPrev($event)
              },
            ],
          },
        },
        [
          _vm._t("prevIntervalBtn", [
            _c("span", { staticClass: "default" }, [_vm._v("<")]),
          ]),
        ],
        2
      ),
      _vm._v(" "),
      _vm._t("default"),
      _vm._v(" "),
      _c(
        "button",
        {
          ref: "next",
          staticClass: "next",
          class: { btn: _vm.bootstrapStyling, rtl: _vm.isRtl },
          attrs: {
            "data-test-next-button": "",
            disabled: _vm.isNextDisabled,
            type: "button",
          },
          on: {
            click: function ($event) {
              $event.stopPropagation();
              return _vm.$emit("page-change", _vm.nextPage)
            },
            keydown: [
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "down", 40, $event.key, [
                    "Down",
                    "ArrowDown",
                  ])
                ) {
                  return null
                }
                $event.preventDefault();
                return _vm.focusTabbableCell($event)
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "up", 38, $event.key, [
                    "Up",
                    "ArrowUp",
                  ])
                ) {
                  return null
                }
                $event.preventDefault();
                return _vm.$emit("focus-input")
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "left", 37, $event.key, [
                    "Left",
                    "ArrowLeft",
                  ])
                ) {
                  return null
                }
                if ("button" in $event && $event.button !== 0) {
                  return null
                }
                $event.preventDefault();
                return _vm.arrowLeftNext($event)
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "right", 39, $event.key, [
                    "Right",
                    "ArrowRight",
                  ])
                ) {
                  return null
                }
                if ("button" in $event && $event.button !== 2) {
                  return null
                }
                $event.preventDefault();
                return _vm.arrowRightNext($event)
              },
            ],
          },
        },
        [
          _vm._t("nextIntervalBtn", [
            _c("span", { staticClass: "default" }, [_vm._v(">")]),
          ]),
        ],
        2
      ),
    ],
    2
  )
};
var __vue_staticRenderFns__$6 = [];
__vue_render__$6._withStripped = true;

  /* style */
  const __vue_inject_styles__$8 = undefined;
  /* scoped */
  const __vue_scope_id__$8 = undefined;
  /* module identifier */
  const __vue_module_identifier__$8 = undefined;
  /* functional template */
  const __vue_is_functional_template__$8 = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$8 = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$6, staticRenderFns: __vue_staticRenderFns__$6 },
    __vue_inject_styles__$8,
    __vue_script__$8,
    __vue_scope_id__$8,
    __vue_is_functional_template__$8,
    __vue_module_identifier__$8,
    false,
    undefined,
    undefined,
    undefined
  );

var script$7 = {
  components: {
    PickerHeader: __vue_component__$8
  },
  inheritAttrs: false,
  props: {
    bootstrapStyling: {
      type: Boolean,
      default: false
    },
    disabledDates: {
      type: Object,
      default: function _default() {
        return {};
      }
    },
    isRtl: {
      type: Boolean,
      default: false
    },
    isTypeable: {
      type: Boolean,
      default: false
    },
    isUpDisabled: {
      type: Boolean,
      default: false
    },
    isMinimumView: {
      type: Boolean,
      default: true
    },
    openDate: {
      type: [String, Date, Number],
      default: null,
      validator: function validator(val) {
        return val === null || val instanceof Date || typeof val === 'string' || typeof val === 'number';
      }
    },
    pageDate: {
      type: Date,
      default: null
    },
    selectedDate: {
      type: Date,
      default: null
    },
    showHeader: {
      type: Boolean,
      default: true
    },
    slideDuration: {
      type: Number,
      default: 250
    },
    tabbableCellId: {
      type: Number,
      default: null
    },
    transitionName: {
      type: String,
      default: ''
    },
    translation: {
      type: Object,
      default: function _default() {
        return {};
      }
    },
    useUtc: {
      type: Boolean,
      default: false
    },
    view: {
      type: String,
      default: 'day'
    }
  },
  data: function data() {
    return {
      utils: makeDateUtils(this.useUtc)
    };
  },
  computed: {
    /**
     * A look-up object created from 'disabledDates' prop
     * @return {Object}
     */
    disabledConfig: function disabledConfig() {
      return new DisabledDate(this.utils, this.disabledDates).config;
    },
    earliestPossibleDate: function earliestPossibleDate() {
      return new DisabledDate(this.utils, this.disabledDates).getEarliestPossibleDate(this.disabledDates.to);
    },
    latestPossibleDate: function latestPossibleDate() {
      return new DisabledDate(this.utils, this.disabledDates).getLatestPossibleDate(this.disabledDates.from);
    },

    /**
     * Returns the current page's full year as an integer.
     * @return {Number}
     */
    pageYear: function pageYear() {
      return this.utils.getFullYear(this.pageDate);
    }
  },
  methods: {
    /**
     * Used when an arrow key press would cause the focus to land on a disabled date
     * @param {Object} options
     */
    addMoreSteps: function addMoreSteps(options) {
      if (options.stepsRemaining <= 0 && Math.abs(options.delta) > 1) {
        return Math.abs(options.delta);
      }

      return options.stepsRemaining;
    },

    /**
     * Changes the page up or down
     * @param {Number} incrementBy
     * @param {[String]} focusRefs
     */
    changePage: function changePage(_ref) {
      var incrementBy = _ref.incrementBy,
          focusRefs = _ref.focusRefs;
      var pageDate = this.pageDate,
          utils = this.utils;
      var units = this.view === 'year' ? incrementBy * this.yearRange : incrementBy;
      this.$emit('set-transition-name', incrementBy);

      if (this.view === 'day') {
        utils.setMonth(pageDate, utils.getMonth(pageDate) + units);
      } else {
        utils.setFullYear(pageDate, utils.getFullYear(pageDate) + units);
      }

      this.$emit('page-change', {
        focusRefs: focusRefs,
        pageDate: pageDate
      });
    },

    /**
     * Changes the page and focuses the cell that is being 'arrowed' to
     * @param {Object} options
     */
    changePageAndSetFocus: function changePageAndSetFocus(options) {
      var _this = this;

      var delta = options.delta;
      var isPageDisabled = delta > 0 && this.isNextDisabled || delta < 0 && this.isPreviousDisabled;

      if (isPageDisabled) {
        return;
      }

      this.changePage({
        incrementBy: Math.sign(delta),
        focusRefs: ['arrow-to-cell']
      });
      this.$nextTick(function () {
        _this.setFocusOnNewPage(options);
      });
    },

    /**
     * Focuses the input field, if typeable
     */
    focusInput: function focusInput() {
      if (this.isTypeable) {
        this.$emit('set-focus', ['input']);
      }
    },

    /**
     * Returns the element that should be focused when navigating via an arrow key
     * @param  {HTMLButtonElement} currentElement  The element currently being iterated on
     * @param  {Number}            delta           The number of cells that the focus should move
     * @param  {Number}            stepsRemaining  The number of steps remaining in the iteration
     * @return {HTMLButtonElement | void}
     */
    // eslint-disable-next-line complexity,max-statements
    getElement: function getElement(_ref2) {
      var currentElement = _ref2.currentElement,
          delta = _ref2.delta,
          stepsRemaining = _ref2.stepsRemaining;
      var element = this.getElementSibling(currentElement, delta);
      var options = {
        currentElement: element,
        delta: delta,
        stepsRemaining: stepsRemaining - 1
      };

      if (!element) {
        return this.changePageAndSetFocus(options);
      }

      if (this.isBeyondPossibleDate(options)) {
        return this.firstOrLastPossibleDate(options);
      }

      if (this.isMutedOrDisabled(element)) {
        options.stepsRemaining = this.addMoreSteps(options);
        return this.getElement(options);
      }

      if (stepsRemaining > 1 && options.currentElement) {
        return this.getElement(options);
      }

      return element;
    },

    /**
     * Returns the element directly next to the currentElement
     * @param  {HTMLButtonElement} currentElement The element currently being iterated on
     * @param  {Number}            delta          The number of cells that the focus should move
     * @return {HTMLButtonElement}
     */
    getElementSibling: function getElementSibling(currentElement, delta) {
      var isNext = delta > 0;
      return isNext ? currentElement.nextElementSibling : currentElement.previousElementSibling;
    },

    /**
     * Returns the first or last cell, depending on the direction of the search
     * @param  {Number} delta The number of cells that the focus should move
     * @return {HTMLButtonElement}
     */
    getFirstOrLastElement: function getFirstOrLastElement(delta) {
      var isNext = delta > 0;
      var elements = this.$refs.cells.$el.children;
      return isNext ? elements[0] : elements[elements.length - 1];
    },

    /**
     * Returns the first or last non-disabled date, depending on the direction of the search
     * @param  {HTMLButtonElement} currentElement  The element currently being iterated on
     * @param  {Number}            delta           The number of cells that the focus should move
     */
    firstOrLastPossibleDate: function firstOrLastPossibleDate(_ref3) {
      var currentElement = _ref3.currentElement,
          delta = _ref3.delta;

      if (delta > 0) {
        return this.getElementSibling(currentElement, -1);
      }

      return this.getElementSibling(currentElement, 1);
    },

    /**
     * Moves the focused cell up/down/left/right
     * @param {Object}
     */
    handleArrow: function handleArrow(_ref4) {
      var delta = _ref4.delta;
      var stepsRemaining = Math.abs(delta);
      var options = {
        currentElement: document.activeElement,
        delta: delta,
        stepsRemaining: stepsRemaining
      };
      this.setFocusToAvailableCell(options);
    },

    /**
     * Determines which transition to use (for edge dates) and emits a 'select' event
     * @param {Object} cell
     */
    select: function select(cell) {
      if (cell.isPreviousMonth) {
        this.$emit('set-transition-name', -1);
      }

      if (cell.isNextMonth) {
        this.$emit('set-transition-name', 1);
      }

      this.$emit('select', cell);
    },

    /**
     * Returns true if the given element cannot be focused
     * @param  {HTMLButtonElement} currentElement  The element currently being iterated on
     * @param  {Number}            delta           The number of cells that the focus should move
     * @return {Boolean}
     */
    isBeyondPossibleDate: function isBeyondPossibleDate(_ref5) {
      var currentElement = _ref5.currentElement,
          delta = _ref5.delta;

      if (delta > 0 && this.latestPossibleDate) {
        return this.isDatePossible(currentElement, delta);
      }

      if (delta < 0 && this.earliestPossibleDate) {
        return this.isDatePossible(currentElement, delta);
      }

      return false;
    },

    /**
     * Returns true if the current element's date is NOT possible, given the `disabled-dates`
     * @param  {HTMLButtonElement} element The element in question
     * @param  {Number}            delta   Used to determine direction of travel
     * @return {Boolean}
     */
    isDatePossible: function isDatePossible(element, delta) {
      var cellId = element.getAttribute('data-id');
      var cellDate = new Date(this.cells[cellId].timestamp);

      if (delta > 0) {
        return cellDate > this.latestPossibleDate;
      }

      return cellDate < this.earliestPossibleDate;
    },

    /**
     * Returns true if the given element cannot be focused
     * @param  {HTMLButtonElement} element The element in question
     * @return {Boolean}
     */
    isMutedOrDisabled: function isMutedOrDisabled(element) {
      var isMuted = element.classList.value.split(' ').includes('muted');
      var isDisabled = element.disabled;
      return isMuted || isDisabled;
    },

    /**
     * Sets the focus on the correct cell following a page change
     * @param {Object} options
     */
    setFocusOnNewPage: function setFocusOnNewPage(_ref6) {
      var _this2 = this;

      var delta = _ref6.delta,
          stepsRemaining = _ref6.stepsRemaining;
      var currentElement = this.getFirstOrLastElement(delta);
      var options = {
        currentElement: currentElement,
        delta: delta,
        stepsRemaining: stepsRemaining
      };

      if (stepsRemaining <= 0) {
        if (this.isMutedOrDisabled(currentElement)) {
          options.stepsRemaining = Math.abs(options.delta);
          setTimeout(function () {
            _this2.setFocusToAvailableCell(options);
          }, this.slideDuration);
          return;
        }

        setTimeout(function () {
          currentElement.focus();
        }, this.slideDuration);
        return;
      }

      setTimeout(function () {
        _this2.setFocusToAvailableCell(options);
      }, this.slideDuration);
    },

    /**
     * Sets the focus on the next focusable cell when an arrow key is pressed
     * @param {Object} options
     */
    setFocusToAvailableCell: function setFocusToAvailableCell(options) {
      var element = this.getElement(options);

      if (element) {
        element.focus();
      }
    }
  }
};

/* script */
const __vue_script__$7 = script$7;

/* template */

  /* style */
  const __vue_inject_styles__$7 = undefined;
  /* scoped */
  const __vue_scope_id__$7 = undefined;
  /* module identifier */
  const __vue_module_identifier__$7 = undefined;
  /* functional template */
  const __vue_is_functional_template__$7 = undefined;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$7 = /*#__PURE__*/normalizeComponent(
    {},
    __vue_inject_styles__$7,
    __vue_script__$7,
    __vue_scope_id__$7,
    __vue_is_functional_template__$7,
    __vue_module_identifier__$7,
    false,
    undefined,
    undefined,
    undefined
  );

var HighlightedDate = /*#__PURE__*/function () {
  function HighlightedDate(utils, disabledDates, highlighted) {
    _classCallCheck(this, HighlightedDate);

    this._utils = utils;
    this._disabledDates = disabledDates;
    this._highlighted = highlighted;
  }

  _createClass(HighlightedDate, [{
    key: "config",
    get: function get() {
      var highlightedDates = this._highlighted;
      var utils = makeCellUtils(this._utils);
      return {
        exists: utils.configExists(highlightedDates),
        to: utils.dayMonthYear(highlightedDates, 'to'),
        from: utils.dayMonthYear(highlightedDates, 'from'),
        has: {
          customPredictor: utils.isDefined(highlightedDates, 'customPredictor'),
          daysOfMonth: utils.hasArray(highlightedDates, 'daysOfMonth'),
          daysOfWeek: utils.hasArray(highlightedDates, 'days'),
          from: utils.hasDate(highlightedDates, 'from'),
          specificDates: utils.hasArray(highlightedDates, 'dates'),
          to: utils.hasDate(highlightedDates, 'to'),
          includeDisabled: utils.isDefined(highlightedDates, 'includeDisabled') && highlightedDates.includeDisabled
        }
      };
    }
  }, {
    key: "isDateDisabled",
    value: function isDateDisabled(date) {
      var utils = this._utils;
      var disabledDates = this._disabledDates;
      return new DisabledDate(utils, disabledDates).isDateDisabled(date);
    }
  }, {
    key: "isHighlightingNotPossible",
    value: function isHighlightingNotPossible(date) {
      var config = this.config;
      if (!config.exists) return false;
      return !config.has.includeDisabled && this.isDateDisabled(date);
    }
  }, {
    key: "isDateHighlightedVia",
    value: function isDateHighlightedVia(date) {
      var _this = this;

      var highlightedDates = this._highlighted;
      var has = this.config.has;
      return {
        to: function to() {
          return has.to && date <= highlightedDates.to;
        },
        from: function from() {
          return has.from && date >= highlightedDates.from;
        },
        customPredictor: function customPredictor() {
          return has.customPredictor && highlightedDates.customPredictor(date);
        },
        specificDate: function specificDate() {
          if (!has.specificDates) return false;
          return highlightedDates.dates.some(function (d) {
            return _this._utils.compareDates(date, d);
          });
        },
        daysOfWeek: function daysOfWeek() {
          if (!has.daysOfWeek) return false;
          return highlightedDates.days.indexOf(_this._utils.getDay(date)) !== -1;
        },
        daysOfMonth: function daysOfMonth() {
          if (!has.daysOfMonth) return false;
          return highlightedDates.daysOfMonth.indexOf(_this._utils.getDate(date)) !== -1;
        }
      };
    } // eslint-disable-next-line complexity,max-statements

  }, {
    key: "isDateHighlighted",
    value: function isDateHighlighted(date) {
      if (this.isHighlightingNotPossible(date)) return false;
      var isHighlightedVia = this.isDateHighlightedVia(date);
      return isHighlightedVia.to() && isHighlightedVia.from() || isHighlightedVia.specificDate() || isHighlightedVia.daysOfWeek() || isHighlightedVia.daysOfMonth() || isHighlightedVia.customPredictor();
    }
  }]);

  return HighlightedDate;
}();

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var script$6 = {
  name: 'PickerCells',
  props: {
    bootstrapStyling: {
      type: Boolean,
      default: false
    },
    cells: {
      type: Array,
      required: true
    },
    isRtl: {
      type: Boolean,
      default: false
    },
    showEdgeDates: {
      type: Boolean,
      default: true
    },
    tabbableCellId: {
      type: Number,
      default: null
    },
    view: {
      type: String,
      validator: function validator(val) {
        return ['day', 'month', 'year'].includes(val);
      },
      required: true
    }
  },
  computed: {
    /**
     * The number of columns in the picker
     * @return {Number}
     */
    columns: function columns() {
      return this.view === 'day' ? 7 : 3;
    }
  },
  methods: {
    /**
     * Set the classes for a specific cell
     * @return {Array}
     */
    // eslint-disable-next-line complexity
    cellClasses: function cellClasses(cell) {
      return ['cell', this.view, {
        'btn': this.bootstrapStyling,
        'disabled': cell.isDisabled,
        'highlight-start': cell.isHighlightStart,
        'highlight-end': cell.isHighlightEnd,
        'highlighted': cell.isHighlighted,
        'muted': cell.isPreviousMonth || cell.isNextMonth,
        'open': cell.isOpenDate,
        'sat': cell.isSaturday,
        'sun': cell.isSunday,
        'selected': this.showEdgeDates ? cell.isSelected : cell.isSelected && !cell.isPreviousMonth && !cell.isNextMonth,
        'today': this.showEdgeDates ? cell.isToday : cell.isToday && !cell.isPreviousMonth && !cell.isNextMonth,
        'weekend': cell.isWeekend
      }];
    },

    /**
     * Emits an `arrow` event
     */
    handleArrow: function handleArrow(cellId, delta) {
      this.$emit('arrow', {
        cellId: cellId,
        delta: delta
      });
    }
  }
};

/* script */
const __vue_script__$6 = script$6;

/* template */
var __vue_render__$5 = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "div",
    { staticClass: "picker-cells", attrs: { "data-test-picker-cells": "" } },
    _vm._l(_vm.cells, function (cell, id) {
      return _c(
        "button",
        {
          key: cell.timestamp,
          ref: cell.isOpenDate ? "openDate" : null,
          refInFor: true,
          class: _vm.cellClasses(cell),
          attrs: {
            "data-id": id,
            "data-test-tabbable-cell": id === _vm.tabbableCellId,
            "data-test-open-date": cell.isOpenDate,
            "data-test-today-cell": cell.isToday,
            disabled: cell.isDisabled,
            type: "button",
          },
          on: {
            click: function ($event) {
              return _vm.$emit("select", cell)
            },
            keydown: [
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "up", 38, $event.key, [
                    "Up",
                    "ArrowUp",
                  ])
                ) {
                  return null
                }
                $event.preventDefault();
                return _vm.handleArrow(id, -_vm.columns)
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "down", 40, $event.key, [
                    "Down",
                    "ArrowDown",
                  ])
                ) {
                  return null
                }
                $event.preventDefault();
                return _vm.handleArrow(id, _vm.columns)
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "left", 37, $event.key, [
                    "Left",
                    "ArrowLeft",
                  ])
                ) {
                  return null
                }
                if ("button" in $event && $event.button !== 0) {
                  return null
                }
                $event.preventDefault();
                return _vm.handleArrow(id, _vm.isRtl ? 1 : -1)
              },
              function ($event) {
                if (
                  !$event.type.indexOf("key") &&
                  _vm._k($event.keyCode, "right", 39, $event.key, [
                    "Right",
                    "ArrowRight",
                  ])
                ) {
                  return null
                }
                if ("button" in $event && $event.button !== 2) {
                  return null
                }
                $event.preventDefault();
                return _vm.handleArrow(id, _vm.isRtl ? -1 : 1)
              },
            ],
          },
        },
        [_vm._t("default", null, { cell: cell })],
        2
      )
    }),
    0
  )
};
var __vue_staticRenderFns__$5 = [];
__vue_render__$5._withStripped = true;

  /* style */
  const __vue_inject_styles__$6 = undefined;
  /* scoped */
  const __vue_scope_id__$6 = undefined;
  /* module identifier */
  const __vue_module_identifier__$6 = undefined;
  /* functional template */
  const __vue_is_functional_template__$6 = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$6 = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$5, staticRenderFns: __vue_staticRenderFns__$5 },
    __vue_inject_styles__$6,
    __vue_script__$6,
    __vue_scope_id__$6,
    __vue_is_functional_template__$6,
    __vue_module_identifier__$6,
    false,
    undefined,
    undefined,
    undefined
  );

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var script$5 = {
  name: 'UpButton',
  props: {
    isDisabled: {
      type: Boolean,
      default: false
    },
    isRtl: {
      type: Boolean,
      required: true
    }
  }
};

/* script */
const __vue_script__$5 = script$5;

/* template */
var __vue_render__$4 = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "button",
    {
      staticClass: "vdp-datepicker__up",
      attrs: {
        "data-test-up-button": "",
        disabled: _vm.isDisabled,
        type: "button",
      },
      on: {
        click: function ($event) {
          return _vm.$emit("select")
        },
        keydown: [
          function ($event) {
            if (
              !$event.type.indexOf("key") &&
              _vm._k($event.keyCode, "down", 40, $event.key, [
                "Down",
                "ArrowDown",
              ])
            ) {
              return null
            }
            $event.preventDefault();
            return _vm.$emit("set-focus", ["tabbableCell"])
          },
          function ($event) {
            if (
              !$event.type.indexOf("key") &&
              _vm._k($event.keyCode, "up", 38, $event.key, ["Up", "ArrowUp"])
            ) {
              return null
            }
            $event.preventDefault();
            return _vm.$emit("focus-input")
          },
          function ($event) {
            if (
              !$event.type.indexOf("key") &&
              _vm._k($event.keyCode, "left", 37, $event.key, [
                "Left",
                "ArrowLeft",
              ])
            ) {
              return null
            }
            if ("button" in $event && $event.button !== 0) {
              return null
            }
            $event.preventDefault();
            return _vm.$emit("set-focus", [_vm.isRtl ? "next" : "prev"])
          },
          function ($event) {
            if (
              !$event.type.indexOf("key") &&
              _vm._k($event.keyCode, "right", 39, $event.key, [
                "Right",
                "ArrowRight",
              ])
            ) {
              return null
            }
            if ("button" in $event && $event.button !== 2) {
              return null
            }
            $event.preventDefault();
            return _vm.$emit("set-focus", [_vm.isRtl ? "prev" : "next"])
          },
        ],
      },
    },
    [_vm._t("default")],
    2
  )
};
var __vue_staticRenderFns__$4 = [];
__vue_render__$4._withStripped = true;

  /* style */
  const __vue_inject_styles__$5 = undefined;
  /* scoped */
  const __vue_scope_id__$5 = undefined;
  /* module identifier */
  const __vue_module_identifier__$5 = undefined;
  /* functional template */
  const __vue_is_functional_template__$5 = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$5 = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$4, staticRenderFns: __vue_staticRenderFns__$4 },
    __vue_inject_styles__$5,
    __vue_script__$5,
    __vue_scope_id__$5,
    __vue_is_functional_template__$5,
    __vue_module_identifier__$5,
    false,
    undefined,
    undefined,
    undefined
  );

var script$4 = {
  name: 'PickerDay',
  components: {
    PickerCells: __vue_component__$6,
    UpButton: __vue_component__$5
  },
  mixins: [__vue_component__$7],
  props: {
    dayCellContent: {
      type: Function,
      default: function _default(day) {
        return day.date;
      }
    },
    firstDayOfWeek: {
      type: String,
      default: 'sun'
    },
    highlighted: {
      type: Object,
      default: function _default() {
        return {};
      }
    },
    showFullMonthName: {
      type: Boolean,
      default: false
    },
    showEdgeDates: {
      type: Boolean,
      default: true
    }
  },
  computed: {
    /**
     * Sets an array with all days to show this month
     * @return {Array}
     */
    cells: function cells() {
      var days = [];
      var daysInCalendar = this.daysFromPrevMonth + this.daysInMonth + this.daysFromNextMonth;
      var dObj = this.firstCellDate();

      for (var i = 0; i < daysInCalendar; i += 1) {
        days.push(this.makeDay(i, dObj));
        this.utils.setDate(dObj, this.utils.getDate(dObj) + 1);
      }

      return days;
    },

    /**
     * Gets the name of the month the current page is on
     * @return {String}
     */
    currMonthName: function currMonthName() {
      var monthName = this.showFullMonthName ? this.translation.months : this.translation.monthsAbbr;
      return this.utils.getMonthNameAbbr(this.pageMonth, monthName);
    },

    /**
     * Gets the name of the year that current page is on
     * @return {String}
     */
    currYearName: function currYearName() {
      var yearSuffix = this.translation.yearSuffix;
      return "".concat(this.pageYear).concat(yearSuffix);
    },

    /**
     * Returns an array of day names
     * @return {String[]}
     */
    daysOfWeek: function daysOfWeek() {
      return this.translation.getDaysStartingOn(this.firstDayOfWeekNumber);
    },

    /**
     * Returns the number of days in this month
     * @return {String[]}
     */
    daysInMonth: function daysInMonth() {
      return this.utils.getDaysInMonth(this.pageDate);
    },

    /**
     * Calculates how many days to show from the previous month
     * @return {number}
     */
    daysFromPrevMonth: function daysFromPrevMonth() {
      var firstOfMonthDayNumber = this.utils.getDay(this.pageDate);
      return (7 - this.firstDayOfWeekNumber + firstOfMonthDayNumber) % 7;
    },

    /**
     * Calculates how many days to show from the next month
     * @return {number}
     */
    daysFromNextMonth: function daysFromNextMonth() {
      var daysThisAndPrevMonth = this.daysFromPrevMonth + this.daysInMonth;
      return Math.ceil(daysThisAndPrevMonth / 7) * 7 - daysThisAndPrevMonth;
    },

    /**
     * Returns first-day-of-week as a number (Sunday is 0)
     * @return {Number}
     */
    firstDayOfWeekNumber: function firstDayOfWeekNumber() {
      return this.utils.getDayFromAbbr(this.firstDayOfWeek);
    },

    /**
     * The first day of the next page's month.
     * @return {Date}
     */
    firstOfNextMonth: function firstOfNextMonth() {
      var d = new Date(this.pageDate);
      return new Date(this.utils.setMonth(d, this.utils.getMonth(d) + 1));
    },

    /**
     * A look-up object created from 'highlighted' prop
     * @return {Object}
     */
    highlightedConfig: function highlightedConfig() {
      return new HighlightedDate(this.utils, this.disabledDates, this.highlighted).config;
    },

    /**
     * Is the next month disabled?
     * @return {Boolean}
     */
    isNextDisabled: function isNextDisabled() {
      if (!this.disabledConfig.has.from) {
        return false;
      }

      return this.disabledConfig.from.month <= this.pageMonth && this.disabledConfig.from.year <= this.pageYear;
    },

    /**
     * Is the previous month disabled?
     * @return {Boolean}
     */
    isPreviousDisabled: function isPreviousDisabled() {
      if (!this.disabledConfig.has.to) {
        return false;
      }

      return this.disabledConfig.to.month >= this.pageMonth && this.disabledConfig.to.year >= this.pageYear;
    },

    /**
     * Returns the current page's month as an integer.
     * @return {Number}
     */
    pageMonth: function pageMonth() {
      return this.utils.getMonth(this.pageDate);
    },

    /**
     * Display the current page's month & year as the title.
     * @return {String}
     */
    pageTitleDay: function pageTitleDay() {
      return this.translation.ymd ? "".concat(this.currYearName, " ").concat(this.currMonthName) : "".concat(this.currMonthName, " ").concat(this.currYearName);
    }
  },
  methods: {
    /**
     * Set up a new date object to the first day of the current 'page'
     * @return Date
     */
    firstCellDate: function firstCellDate() {
      var d = this.pageDate;
      var firstOfMonth = this.useUtc ? new Date(Date.UTC(d.getUTCFullYear(), d.getUTCMonth(), 1)) : new Date(d.getFullYear(), d.getMonth(), 1, d.getHours(), d.getMinutes());
      return new Date(firstOfMonth.setDate(firstOfMonth.getDate() - this.daysFromPrevMonth));
    },

    /**
     * Whether a day is disabled
     * @param {Date} date to check if disabled
     * @return {Boolean}
     */
    isDisabledDate: function isDisabledDate(date) {
      return new DisabledDate(this.utils, this.disabledDates).isDateDisabled(date);
    },

    /**
     * Whether a day is highlighted
     * (only if it is not disabled already except when highlighted.includeDisabled is true)
     * @param {Date} date to check if highlighted
     * @return {Boolean}
     */
    isHighlightedDate: function isHighlightedDate(date) {
      var dateWithoutTime = this.utils.resetDateTime(date);
      return new HighlightedDate(this.utils, this.disabledDates, this.highlighted).isDateHighlighted(dateWithoutTime);
    },

    /**
     * Whether a day is highlighted and it is the last date
     * in the highlighted range of dates
     * @param {Date} date end highlight
     * @return {Boolean}
     */
    isHighlightEnd: function isHighlightEnd(date) {
      var config = this.highlightedConfig;
      return this.isHighlightedDate(date) && config.to.year === this.utils.getFullYear(date) && config.to.month === this.utils.getMonth(date) && config.to.day === this.utils.getDate(date);
    },

    /**
     * Whether a day is highlighted and it is the first date
     * in the highlighted range of dates
     * @param {Date} date start highlight
     * @return {Boolean}
     */
    isHighlightStart: function isHighlightStart(date) {
      var config = this.highlightedConfig;
      return this.isHighlightedDate(date) && config.from.year === this.utils.getFullYear(date) && config.from.month === this.utils.getMonth(date) && config.from.day === this.utils.getDate(date);
    },

    /**
     * Whether a day is selected
     * @param {Date} dObj to check if selected
     * @return {Boolean}
     */
    isSelectedDate: function isSelectedDate(dObj) {
      return this.selectedDate && this.utils.compareDates(this.selectedDate, dObj);
    },

    /**
     * Defines the objects within the days array
     * @param  {id}  id
     * @param  {Date}  dObj
     * @return {Object}
     */
    // eslint-disable-next-line complexity
    makeDay: function makeDay(id, dObj) {
      var isNextMonth = dObj >= this.firstOfNextMonth;
      var isPreviousMonth = dObj < this.pageDate;
      var isSaturday = this.utils.getDay(dObj) === 6;
      var isSunday = this.utils.getDay(dObj) === 0;
      var showDate = this.showEdgeDates || !(isPreviousMonth || isNextMonth);
      return {
        date: showDate ? this.utils.getDate(dObj) : '',
        timestamp: dObj.valueOf(),
        isSelected: this.isSelectedDate(dObj),
        isDisabled: showDate ? this.isDisabledDate(dObj) : true,
        isHighlighted: this.isHighlightedDate(dObj),
        isHighlightStart: this.isHighlightStart(dObj),
        isHighlightEnd: this.isHighlightEnd(dObj),
        isOpenDate: this.openDate && this.utils.compareDates(dObj, this.openDate),
        isToday: this.utils.compareDates(dObj, new Date()),
        isWeekend: isSaturday || isSunday,
        isSaturday: isSaturday,
        isSunday: isSunday,
        isPreviousMonth: isPreviousMonth,
        isNextMonth: isNextMonth
      };
    }
  }
};

/* script */
const __vue_script__$4 = script$4;

/* template */
var __vue_render__$3 = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "div",
    [
      _vm.$slots.beforeCalendarHeaderDay
        ? _c("div", [_vm._t("beforeCalendarHeaderDay")], 2)
        : _vm._e(),
      _vm._v(" "),
      _vm.showHeader
        ? _c(
            "PickerHeader",
            {
              ref: "pickerHeader",
              attrs: {
                "bootstrap-styling": _vm.bootstrapStyling,
                "is-next-disabled": _vm.isNextDisabled,
                "is-previous-disabled": _vm.isPreviousDisabled,
                "is-rtl": _vm.isRtl,
              },
              on: {
                "focus-input": _vm.focusInput,
                "page-change": function ($event) {
                  return _vm.changePage($event)
                },
                "set-focus": function ($event) {
                  return _vm.$emit("set-focus", $event)
                },
              },
            },
            [
              _vm._t("prevIntervalBtn", null, { slot: "prevIntervalBtn" }),
              _vm._v(" "),
              _c(
                "UpButton",
                {
                  ref: "up",
                  class: { btn: _vm.bootstrapStyling },
                  attrs: {
                    "is-disabled": _vm.isUpDisabled,
                    "is-rtl": _vm.isRtl,
                  },
                  on: {
                    "focus-input": _vm.focusInput,
                    select: function ($event) {
                      return _vm.$emit("set-view", "month")
                    },
                    "set-focus": function ($event) {
                      return _vm.$emit("set-focus", $event)
                    },
                  },
                },
                [_vm._v("\n      " + _vm._s(_vm.pageTitleDay) + "\n    ")]
              ),
              _vm._v(" "),
              _vm._t("nextIntervalBtn", null, { slot: "nextIntervalBtn" }),
            ],
            2
          )
        : _vm._e(),
      _vm._v(" "),
      _c("div", [
        _c(
          "div",
          { staticClass: "day-header" },
          _vm._l(_vm.daysOfWeek, function (day) {
            return _c("span", { key: day }, [
              _vm._v("\n        " + _vm._s(day) + "\n      "),
            ])
          }),
          0
        ),
        _vm._v(" "),
        _c(
          "div",
          { staticClass: "cells-wrapper" },
          [
            _c(
              "Transition",
              { attrs: { name: _vm.transitionName } },
              [
                _c("PickerCells", {
                  key: _vm.pageTitleDay,
                  ref: "cells",
                  attrs: {
                    "bootstrap-styling": _vm.bootstrapStyling,
                    cells: _vm.cells,
                    "is-rtl": _vm.isRtl,
                    "show-edge-dates": _vm.showEdgeDates,
                    "tabbable-cell-id": _vm.tabbableCellId,
                    view: "day",
                  },
                  on: {
                    arrow: function ($event) {
                      return _vm.handleArrow($event)
                    },
                    select: function ($event) {
                      return _vm.select($event)
                    },
                  },
                  scopedSlots: _vm._u(
                    [
                      {
                        key: "default",
                        fn: function (ref) {
                          var cell = ref.cell;
                          return [
                            _vm._t(
                              "dayCellContent",
                              [
                                _vm._v(
                                  "\n            " +
                                    _vm._s(_vm.dayCellContent(cell)) +
                                    "\n          "
                                ),
                              ],
                              { cell: cell }
                            ),
                          ]
                        },
                      },
                    ],
                    null,
                    true
                  ),
                }),
              ],
              1
            ),
          ],
          1
        ),
      ]),
      _vm._v(" "),
      _vm.$slots.calendarFooterDay
        ? _c("div", [_vm._t("calendarFooterDay")], 2)
        : _vm._e(),
    ],
    1
  )
};
var __vue_staticRenderFns__$3 = [];
__vue_render__$3._withStripped = true;

  /* style */
  const __vue_inject_styles__$4 = undefined;
  /* scoped */
  const __vue_scope_id__$4 = undefined;
  /* module identifier */
  const __vue_module_identifier__$4 = undefined;
  /* functional template */
  const __vue_is_functional_template__$4 = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$4 = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$3, staticRenderFns: __vue_staticRenderFns__$3 },
    __vue_inject_styles__$4,
    __vue_script__$4,
    __vue_scope_id__$4,
    __vue_is_functional_template__$4,
    __vue_module_identifier__$4,
    false,
    undefined,
    undefined,
    undefined
  );

var script$3 = {
  name: 'PickerMonth',
  components: {
    PickerCells: __vue_component__$6,
    UpButton: __vue_component__$5
  },
  mixins: [__vue_component__$7],
  computed: {
    /**
     * Sets an array with all months to show this year
     * @return {Array}
     */
    cells: function cells() {
      var d = this.pageDate;
      var months = []; // set up a new date object to the beginning of the current 'page'

      var dObj = this.useUtc ? new Date(Date.UTC(d.getUTCFullYear(), 0, d.getUTCDate())) : new Date(d.getFullYear(), 0, d.getDate(), d.getHours(), d.getMinutes());
      var todayMonth = new Date(this.utils.setDate(this.utils.getNewDateObject(), 1));

      for (var i = 0; i < 12; i += 1) {
        months.push({
          month: this.utils.getMonthName(i, this.translation.months),
          timestamp: dObj.valueOf(),
          isDisabled: this.isDisabledMonth(dObj),
          isOpenDate: this.isOpenMonth(dObj),
          isSelected: this.isSelectedMonth(dObj),
          isToday: this.utils.compareDates(dObj, todayMonth)
        });
        this.utils.setMonth(dObj, this.utils.getMonth(dObj) + 1);
      }

      return months;
    },

    /**
     * Is the next year disabled?
     * @return {Boolean}
     */
    isNextDisabled: function isNextDisabled() {
      if (!this.disabledConfig.has.from) {
        return false;
      }

      return this.disabledConfig.from.year <= this.pageYear;
    },

    /**
     * Is the previous year disabled?
     * @return {Boolean}
     */
    isPreviousDisabled: function isPreviousDisabled() {
      if (!this.disabledConfig.has.to) {
        return false;
      }

      return this.disabledConfig.to.year >= this.pageYear;
    },

    /**
     * Display the current page's year as the title.
     * @return {String}
     */
    pageTitleMonth: function pageTitleMonth() {
      var yearSuffix = this.translation.yearSuffix;
      return "".concat(this.pageYear).concat(yearSuffix);
    }
  },
  methods: {
    /**
     * Whether a month is disabled
     * @param {Date} date
     * @return {Boolean}
     */
    isDisabledMonth: function isDisabledMonth(date) {
      return new DisabledDate(this.utils, this.disabledDates).isMonthDisabled(date);
    },

    /**
     * Should the calendar open on this month?
     * @return {Boolean}
     */
    isOpenMonth: function isOpenMonth(date) {
      if (!this.openDate) {
        return false;
      }

      var openDateMonth = this.utils.getMonth(this.openDate);
      var openDateYear = this.utils.getFullYear(this.openDate);
      var thisDateMonth = this.utils.getMonth(date);
      var thisDateYear = this.utils.getFullYear(date);
      return openDateMonth === thisDateMonth && openDateYear === thisDateYear;
    },

    /**
     * Whether the selected date is in this month
     * @param {Date} date
     * @return {Boolean}
     */
    isSelectedMonth: function isSelectedMonth(date) {
      var month = this.utils.getMonth(date);
      var year = this.utils.getFullYear(date);
      return this.selectedDate && year === this.utils.getFullYear(this.selectedDate) && month === this.utils.getMonth(this.selectedDate);
    }
  }
};

/* script */
const __vue_script__$3 = script$3;

/* template */
var __vue_render__$2 = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "div",
    [
      _vm.$slots.beforeCalendarHeaderMonth
        ? _c("div", [_vm._t("beforeCalendarHeaderMonth")], 2)
        : _vm._e(),
      _vm._v(" "),
      _vm.showHeader
        ? _c(
            "PickerHeader",
            {
              ref: "pickerHeader",
              attrs: {
                "bootstrap-styling": _vm.bootstrapStyling,
                "is-next-disabled": _vm.isNextDisabled,
                "is-previous-disabled": _vm.isPreviousDisabled,
                "is-rtl": _vm.isRtl,
              },
              on: {
                "focus-input": _vm.focusInput,
                "page-change": function ($event) {
                  return _vm.changePage($event)
                },
                "set-focus": function ($event) {
                  return _vm.$emit("set-focus", $event)
                },
              },
            },
            [
              _vm._t("prevIntervalBtn", null, { slot: "prevIntervalBtn" }),
              _vm._v(" "),
              _c(
                "UpButton",
                {
                  ref: "up",
                  class: { btn: _vm.bootstrapStyling },
                  attrs: {
                    "is-disabled": _vm.isUpDisabled,
                    "is-rtl": _vm.isRtl,
                  },
                  on: {
                    "focus-input": _vm.focusInput,
                    select: function ($event) {
                      return _vm.$emit("set-view", "year")
                    },
                    "set-focus": function ($event) {
                      return _vm.$emit("set-focus", $event)
                    },
                  },
                },
                [_vm._v("\n      " + _vm._s(_vm.pageTitleMonth) + "\n    ")]
              ),
              _vm._v(" "),
              _vm._t("nextIntervalBtn", null, { slot: "nextIntervalBtn" }),
            ],
            2
          )
        : _vm._e(),
      _vm._v(" "),
      _c(
        "div",
        { staticClass: "cells-wrapper" },
        [
          _c(
            "Transition",
            { attrs: { name: _vm.transitionName } },
            [
              _c("PickerCells", {
                key: _vm.pageTitleMonth,
                ref: "cells",
                attrs: {
                  "bootstrap-styling": _vm.bootstrapStyling,
                  cells: _vm.cells,
                  "is-rtl": _vm.isRtl,
                  "tabbable-cell-id": _vm.tabbableCellId,
                  view: "month",
                },
                on: {
                  arrow: function ($event) {
                    return _vm.handleArrow($event)
                  },
                  select: function ($event) {
                    return _vm.select($event)
                  },
                },
                scopedSlots: _vm._u([
                  {
                    key: "default",
                    fn: function (ref) {
                      var cell = ref.cell;
                      return [
                        _vm._v("\n        " + _vm._s(cell.month) + "\n      "),
                      ]
                    },
                  },
                ]),
              }),
            ],
            1
          ),
        ],
        1
      ),
      _vm._v(" "),
      _vm.$slots.calendarFooterMonth
        ? _c("div", [_vm._t("calendarFooterMonth")], 2)
        : _vm._e(),
    ],
    1
  )
};
var __vue_staticRenderFns__$2 = [];
__vue_render__$2._withStripped = true;

  /* style */
  const __vue_inject_styles__$3 = undefined;
  /* scoped */
  const __vue_scope_id__$3 = undefined;
  /* module identifier */
  const __vue_module_identifier__$3 = undefined;
  /* functional template */
  const __vue_is_functional_template__$3 = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$3 = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$2, staticRenderFns: __vue_staticRenderFns__$2 },
    __vue_inject_styles__$3,
    __vue_script__$3,
    __vue_scope_id__$3,
    __vue_is_functional_template__$3,
    __vue_module_identifier__$3,
    false,
    undefined,
    undefined,
    undefined
  );

var script$2 = {
  name: 'PickerYear',
  components: {
    PickerCells: __vue_component__$6,
    UpButton: __vue_component__$5
  },
  mixins: [__vue_component__$7],
  props: {
    yearRange: {
      type: Number,
      default: 10
    }
  },
  computed: {
    /**
     * Sets an array with all years to show this decade (or yearRange)
     * @return {Array}
     */
    // eslint-disable-next-line complexity,max-statements
    cells: function cells() {
      var d = this.pageDate;
      var years = [];
      var year = this.useUtc ? Math.floor(d.getUTCFullYear() / this.yearRange) * this.yearRange : Math.floor(d.getFullYear() / this.yearRange) * this.yearRange; // set up a new date object to the beginning of the current 'page'

      var dObj = this.useUtc ? new Date(Date.UTC(year, d.getUTCMonth(), d.getUTCDate())) : new Date(year, d.getMonth(), d.getDate(), d.getHours(), d.getMinutes());
      var todayYear = this.utils.getFullYear(this.utils.getNewDateObject());

      for (var i = 0; i < this.yearRange; i += 1) {
        years.push({
          year: this.utils.getFullYear(dObj),
          timestamp: dObj.valueOf(),
          isDisabled: this.isDisabledYear(dObj),
          isOpenDate: this.isOpenYear(dObj),
          isSelected: this.isSelectedYear(dObj),
          isToday: dObj.getFullYear() === todayYear
        });
        this.utils.setFullYear(dObj, this.utils.getFullYear(dObj) + 1);
      } // Fill any remaining cells with blanks to position trailing cells correctly when rtl


      var cellsInGrid = Math.ceil(this.yearRange / 3) * 3;

      for (var _i = years.length; _i < cellsInGrid; _i += 1) {
        years.push({
          id: _i,
          isDisabled: true
        });
      }

      return years;
    },

    /**
     * Is the next decade disabled?
     * @return {Boolean}
     */
    isNextDisabled: function isNextDisabled() {
      if (!this.disabledConfig.has.from) {
        return false;
      }

      return this.disabledConfig.from.year <= this.pageDecadeEnd;
    },

    /**
     * Is the previous decade disabled?
     * @return {Boolean}
     */
    isPreviousDisabled: function isPreviousDisabled() {
      if (!this.disabledConfig.has.to) {
        return false;
      }

      return this.disabledConfig.to.year >= this.pageDecadeStart;
    },

    /**
     * The year at which the current yearRange starts
     * @return {Number}
     */
    pageDecadeStart: function pageDecadeStart() {
      return Math.floor(this.pageYear / this.yearRange) * this.yearRange;
    },

    /**
     * The year at which the current yearRange ends
     * @return {Number}
     */
    pageDecadeEnd: function pageDecadeEnd() {
      return this.pageDecadeStart + this.yearRange - 1;
    },

    /**
     * Display the current page's decade (or year range) as the title.
     * @return {String}
     */
    pageTitleYear: function pageTitleYear() {
      var yearSuffix = this.translation.yearSuffix;
      return "".concat(this.pageDecadeStart, " - ").concat(this.pageDecadeEnd).concat(yearSuffix);
    }
  },
  methods: {
    /**
     * Whether a year is disabled
     * @param {Date} date
     * @return {Boolean}
     */
    isDisabledYear: function isDisabledYear(date) {
      return new DisabledDate(this.utils, this.disabledDates).isYearDisabled(date);
    },

    /**
     * Should the calendar open on this year?
     * @return {Boolean}
     */
    isOpenYear: function isOpenYear(date) {
      if (!this.openDate) {
        return false;
      }

      var openDateYear = this.utils.getFullYear(this.openDate);
      var thisDateYear = this.utils.getFullYear(date);
      return openDateYear === thisDateYear;
    },

    /**
     * Whether the selected date is in this year
     * @param {Date} date
     * @return {Boolean}
     */
    isSelectedYear: function isSelectedYear(date) {
      var year = this.utils.getFullYear(date);
      return this.selectedDate && year === this.utils.getFullYear(this.selectedDate);
    }
  }
};

/* script */
const __vue_script__$2 = script$2;

/* template */
var __vue_render__$1 = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "div",
    [
      _vm.$slots.beforeCalendarHeaderYear
        ? _c("div", [_vm._t("beforeCalendarHeaderYear")], 2)
        : _vm._e(),
      _vm._v(" "),
      _vm.showHeader
        ? _c(
            "PickerHeader",
            {
              ref: "pickerHeader",
              attrs: {
                "bootstrap-styling": _vm.bootstrapStyling,
                "is-next-disabled": _vm.isNextDisabled,
                "is-previous-disabled": _vm.isPreviousDisabled,
                "is-rtl": _vm.isRtl,
              },
              on: {
                "focus-input": _vm.focusInput,
                "page-change": function ($event) {
                  return _vm.changePage($event)
                },
                "set-focus": function ($event) {
                  return _vm.$emit("set-focus", $event)
                },
              },
            },
            [
              _vm._t("prevIntervalBtn", null, { slot: "prevIntervalBtn" }),
              _vm._v(" "),
              _c(
                "UpButton",
                {
                  ref: "up",
                  class: { btn: _vm.bootstrapStyling },
                  attrs: { "is-disabled": true, "is-rtl": _vm.isRtl },
                },
                [_vm._v("\n      " + _vm._s(_vm.pageTitleYear) + "\n    ")]
              ),
              _vm._v(" "),
              _vm._t("nextIntervalBtn", null, { slot: "nextIntervalBtn" }),
            ],
            2
          )
        : _vm._e(),
      _vm._v(" "),
      _c(
        "div",
        { staticClass: "cells-wrapper" },
        [
          _c(
            "Transition",
            { attrs: { name: _vm.transitionName } },
            [
              _c("PickerCells", {
                key: _vm.pageTitleYear,
                ref: "cells",
                attrs: {
                  "bootstrap-styling": _vm.bootstrapStyling,
                  cells: _vm.cells,
                  "is-rtl": _vm.isRtl,
                  "tabbable-cell-id": _vm.tabbableCellId,
                  view: "year",
                },
                on: {
                  arrow: function ($event) {
                    return _vm.handleArrow($event)
                  },
                  select: function ($event) {
                    return _vm.select($event)
                  },
                },
                scopedSlots: _vm._u([
                  {
                    key: "default",
                    fn: function (ref) {
                      var cell = ref.cell;
                      return [
                        _vm._v("\n        " + _vm._s(cell.year) + "\n      "),
                      ]
                    },
                  },
                ]),
              }),
            ],
            1
          ),
        ],
        1
      ),
      _vm._v(" "),
      _vm.$slots.calendarFooterYear
        ? _c("div", [_vm._t("calendarFooterYear")], 2)
        : _vm._e(),
    ],
    1
  )
};
var __vue_staticRenderFns__$1 = [];
__vue_render__$1._withStripped = true;

  /* style */
  const __vue_inject_styles__$2 = undefined;
  /* scoped */
  const __vue_scope_id__$2 = undefined;
  /* module identifier */
  const __vue_module_identifier__$2 = undefined;
  /* functional template */
  const __vue_is_functional_template__$2 = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$2 = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__$1, staticRenderFns: __vue_staticRenderFns__$1 },
    __vue_inject_styles__$2,
    __vue_script__$2,
    __vue_scope_id__$2,
    __vue_is_functional_template__$2,
    __vue_module_identifier__$2,
    false,
    undefined,
    undefined,
    undefined
  );

/* eslint no-param-reassign: 0 */

/**
 * get the hidden element width, height
 * @param {HTMLElement} element dom
 */
function getPopupElementSize(element) {
  var originalDisplay = element.style.display;
  var originalVisibility = element.style.visibility;
  element.style.display = 'block';
  element.style.visibility = 'hidden';
  var styles = window.getComputedStyle(element);
  var width = element.offsetWidth + parseInt(styles.marginLeft, 10) + parseInt(styles.marginRight, 10);
  var height = element.offsetHeight + parseInt(styles.marginTop, 10) + parseInt(styles.marginBottom, 10);
  element.style.display = originalDisplay;
  element.style.visibility = originalVisibility;
  return {
    width: width,
    height: height
  };
}
/**
 * get the popup position
 * @param {Element} el element
 * @param {Element} elRelative relative element
 * @param {Number} targetWidth target element's width
 * @param {Number} targetHeight target element's height
 * @param {Boolean} appendToBody
 * @param {String} fixedPosition
 * @param {Boolean} rtl
 */
// eslint-disable-next-line complexity,max-statements

function getRelativePosition(_ref) {
  var el = _ref.el,
      elRelative = _ref.elRelative,
      targetWidth = _ref.targetWidth,
      targetHeight = _ref.targetHeight,
      appendToBody = _ref.appendToBody,
      fixedPosition = _ref.fixedPosition,
      rtl = _ref.rtl;
  var left = 0;
  var top = 0;
  var offsetX = 0;
  var offsetY = 0;
  var relativeRect = elRelative.getBoundingClientRect();
  var documentWidth = document.documentElement.clientWidth;
  var documentHeight = document.documentElement.clientHeight;

  if (appendToBody) {
    offsetX = window.pageXOffset + relativeRect.left;
    offsetY = window.pageYOffset + relativeRect.top;
  }

  var calendarBounding = el.getBoundingClientRect();
  var outOfBoundsRight = calendarBounding.right > window.innerWidth;
  var outOfBoundsBottom = calendarBounding.bottom > window.innerHeight;
  var fixedPositionRight = fixedPosition && fixedPosition.indexOf('right') !== -1;
  var fixedPositionTop = fixedPosition && fixedPosition.indexOf('top') !== -1;

  var setLeft = function setLeft() {
    left = offsetX;
  };

  var setRight = function setRight() {
    left = offsetX + relativeRect.width - targetWidth;
  };

  var setBottom = function setBottom() {
    top = offsetY + relativeRect.height;
  };

  var setTop = function setTop() {
    top = offsetY - targetHeight;
  };

  if (fixedPosition === '') {
    if (outOfBoundsRight || rtl) {
      setRight();
    } else {
      setLeft();
    }

    if (outOfBoundsBottom) {
      setTop();
    } else {
      setBottom();
    }

    var hasRelativeWidth = documentWidth - relativeRect.left < targetWidth && relativeRect.right < targetWidth;
    var hasRelativeHeight = relativeRect.top <= targetHeight && documentHeight - relativeRect.bottom <= targetHeight;

    if (hasRelativeWidth) {
      left = offsetX - relativeRect.left + 1;
    }

    if (hasRelativeHeight) {
      top = offsetY + documentHeight - relativeRect.top - targetHeight;
    }
  } else {
    if (fixedPositionRight) {
      setRight();
    } else {
      setLeft();
    }

    if (fixedPositionTop) {
      setTop();
    } else {
      setBottom();
    }
  }

  return {
    left: "".concat(left, "px"),
    top: "".concat(top, "px")
  };
}

var script$1 = {
  name: 'Popup',
  props: {
    appendToBody: {
      type: Boolean,
      default: true
    },
    fixedPosition: {
      type: String,
      default: ''
    },
    inline: {
      type: Boolean,
      default: false
    },
    rtl: {
      type: Boolean,
      default: false
    },
    visible: {
      type: Boolean,
      default: false
    }
  },
  data: function data() {
    return {
      popupRect: null
    };
  },
  watch: {
    visible: {
      immediate: true,
      handler: function handler(val) {
        if (val) {
          this.displayPopup();
        }
      }
    }
  },
  mounted: function mounted() {
    if (this.inline) {
      return;
    }

    if (this.appendToBody) {
      document.body.appendChild(this.$el);
    }
  },
  beforeDestroy: function beforeDestroy() {
    if (this.inline) {
      return;
    }

    if (this.appendToBody && this.$el.parentNode) {
      this.$el.parentNode.removeChild(this.$el);
    }
  },
  methods: {
    /**
     * Adjusts the popup's `top` style attribute when `append-to-body` is true
     */
    setTopStyle: function setTopStyle() {
      if (this.appendToBody) {
        var relativeRect = this.$parent.$el.getBoundingClientRect();
        this.$el.style.top = "".concat(relativeRect.bottom + window.scrollY, "px");
      }
    },

    /**
     * Sets the `left` and `top` style attributes of the popup
     */
    displayPopup: function displayPopup() {
      if (this.inline || !this.visible) return;
      this.setTopStyle();
      var popup = this.$el;
      var relativeElement = this.$parent.$el;

      if (!this.popupRect) {
        this.popupRect = getPopupElementSize(popup);
      }

      var _this$popupRect = this.popupRect,
          width = _this$popupRect.width,
          height = _this$popupRect.height;

      var _getRelativePosition = getRelativePosition({
        el: popup,
        elRelative: relativeElement,
        targetWidth: width,
        targetHeight: height,
        appendToBody: this.appendToBody,
        fixedPosition: this.fixedPosition,
        rtl: this.rtl
      }),
          left = _getRelativePosition.left,
          top = _getRelativePosition.top;

      this.$el.style.left = left;
      this.$el.style.top = top;
    }
  },
  render: function render() {
    return this.$slots.default;
  }
};

/* script */
const __vue_script__$1 = script$1;

/* template */

  /* style */
  const __vue_inject_styles__$1 = undefined;
  /* scoped */
  const __vue_scope_id__$1 = undefined;
  /* module identifier */
  const __vue_module_identifier__$1 = undefined;
  /* functional template */
  const __vue_is_functional_template__$1 = undefined;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__$1 = /*#__PURE__*/normalizeComponent(
    {},
    __vue_inject_styles__$1,
    __vue_script__$1,
    __vue_scope_id__$1,
    __vue_is_functional_template__$1,
    __vue_module_identifier__$1,
    false,
    undefined,
    undefined,
    undefined
  );

var script = {
  name: 'Datepicker',
  components: {
    DateInput: __vue_component__$a,
    PickerDay: __vue_component__$4,
    PickerMonth: __vue_component__$3,
    PickerYear: __vue_component__$2,
    Popup: __vue_component__$1
  },
  mixins: [__vue_component__$b, __vue_component__$9],
  props: {
    appendToBody: {
      type: Boolean,
      default: false
    },
    calendarClass: {
      type: [String, Object, Array],
      default: ''
    },
    dayCellContent: {
      type: Function,
      default: function _default(day) {
        return day.date;
      }
    },
    disabledDates: {
      type: Object,
      default: function _default() {
        return {};
      }
    },
    firstDayOfWeek: {
      type: String,
      default: 'sun'
    },
    fixedPosition: {
      type: String,
      default: '',
      validator: function validator(val) {
        var possibleValues = ['', 'bottom', 'bottom-left', 'bottom-right', 'top', 'top-left', 'top-right'];
        return possibleValues.includes(val);
      }
    },
    fullMonthName: {
      type: Boolean,
      default: false
    },
    highlighted: {
      type: Object,
      default: function _default() {
        return {};
      }
    },
    initialView: {
      type: String,
      default: ''
    },
    language: {
      type: Object,
      default: function _default() {
        return en;
      }
    },
    maximumView: {
      type: String,
      default: 'year'
    },
    minimumView: {
      type: String,
      default: 'day'
    },
    showEdgeDates: {
      type: Boolean,
      default: true
    },
    showHeader: {
      type: Boolean,
      default: true
    },
    value: {
      type: [String, Date, Number],
      default: '',
      validator: function validator(val) {
        return val === null || val instanceof Date || typeof val === 'string' || typeof val === 'number';
      }
    },
    wrapperClass: {
      type: [String, Object, Array],
      default: ''
    },
    yearPickerRange: {
      type: Number,
      default: 10
    }
  },
  data: function data() {
    var utils = makeDateUtils(this.useUtc);
    var startDate = utils.getNewDateObject(this.openDate || null);
    var pageTimestamp = utils.setDate(startDate, 1);
    return {
      calendarHeight: 0,
      calendarSlots: calendarSlots,
      isClickOutside: false,

      /*
       * Vue cannot observe changes to a Date Object so date must be stored as a timestamp
       * This represents the first day of the current viewing month
       * {Number}
       */
      pageTimestamp: pageTimestamp,

      /*
       * Selected Date
       * {Date}
       */
      selectedDate: null,
      slideDuration: 250,
      utils: utils,
      view: ''
    };
  },
  computed: {
    computedInitialView: function computedInitialView() {
      return this.initialView || this.minimumView;
    },
    computedOpenDate: function computedOpenDate() {
      var openDateOrToday = this.openDate ? new Date(this.openDate) : this.utils.getNewDateObject();
      var openDate = this.selectedDate || openDateOrToday; // If the `minimum-view` is `month` or `year`, convert `openDate` accordingly

      return this.minimumView === 'day' ? openDate : new Date(this.utils.setDate(openDate, 1));
    },
    datepickerId: function datepickerId() {
      return "vdp-".concat(Math.random().toString(36).slice(-10));
    },
    isInline: function isInline() {
      return !!this.inline;
    },
    isOpen: function isOpen() {
      return this.view !== '';
    },
    isMinimumView: function isMinimumView() {
      return this.view === this.minimumView;
    },
    isRtl: function isRtl() {
      return this.translation.rtl;
    },
    isUpDisabled: function isUpDisabled() {
      return !this.allowedToShowView(this.nextView.up);
    },
    nextView: function nextView() {
      var _this = this;

      var views = ['day', 'month', 'year'];

      var isCurrentView = function isCurrentView(view) {
        return view === _this.view;
      };

      var viewIndex = views.findIndex(isCurrentView);

      var nextViewDown = function nextViewDown(index) {
        return index <= 0 ? undefined : views[index - 1];
      };

      var nextViewUp = function nextViewUp(index) {
        if (index < 0) {
          return undefined;
        }

        if (index === views.length - 1) {
          return 'decade';
        }

        return views[index + 1];
      };

      return {
        up: nextViewUp(viewIndex),
        down: nextViewDown(viewIndex)
      };
    },
    pageDate: function pageDate() {
      return new Date(this.pageTimestamp);
    },
    picker: function picker() {
      var view = this.view || this.computedInitialView;
      return "Picker".concat(this.ucFirst(view));
    },
    pickerClasses: function pickerClasses() {
      return [this.calendarClass, this.isInline && 'vdp-datepicker__calendar--inline', this.isRtl && this.appendToBody && 'rtl'];
    },
    translation: function translation() {
      return this.language;
    }
  },
  watch: {
    initialView: function initialView() {
      if (this.isOpen) {
        this.setInitialView();
      }
    },
    isActive: function isActive(hasJustBecomeActive) {
      if (hasJustBecomeActive && this.inline) {
        this.setNavElementsFocusedIndex();
        this.tabToCorrectInlineCell();
      }
    },
    openDate: function openDate() {
      this.setPageDate();
    },
    value: function value(_value) {
      var parsedValue = this.parseValue(_value);
      this.setValue(parsedValue);
    },
    view: function view(newView, oldView) {
      this.handleViewChange(newView, oldView);
    }
  },
  mounted: function mounted() {
    this.init();
    document.addEventListener('click', this.handleClickOutside);
  },
  beforeDestroy: function beforeDestroy() {
    document.removeEventListener('click', this.handleClickOutside);
  },
  methods: {
    /**
     * Are we allowed to show a specific picker view?
     * @param {String} view
     * @return {Boolean}
     */
    allowedToShowView: function allowedToShowView(view) {
      var views = ['day', 'month', 'year'];
      var minimumViewIndex = views.indexOf(this.minimumView);
      var maximumViewIndex = views.indexOf(this.maximumView);
      var viewIndex = views.indexOf(view);
      return viewIndex >= minimumViewIndex && viewIndex <= maximumViewIndex;
    },

    /**
     * Clear the selected date
     */
    clearDate: function clearDate() {
      if (!this.selectedDate) {
        return;
      }

      this.selectedDate = null;
      this.focus.refs = ['input'];
      this.close();
      this.setPageDate();
      this.$emit('selected', null);
      this.$emit('input', null);
      this.$emit('cleared');
    },

    /**
     * Close the calendar
     */
    close: function close() {
      if (this.isInline) {
        return;
      }

      this.view = '';

      if (this.showCalendarOnFocus) {
        this.$refs.dateInput.shouldToggleOnClick = true;
      }

      if (this.isClickOutside) {
        this.isClickOutside = false;
      } else {
        this.reviewFocus();
      }

      this.$emit('closed');
    },

    /**
     * Closes the calendar when no element within it has focus
     */
    handleClickOutside: function handleClickOutside() {
      if (document.datepickerId !== this.datepickerId) {
        return;
      }

      var isFocused = this.allElements.includes(document.activeElement);

      if (!isFocused && this.isOpen) {
        this.isClickOutside = true;
        this.close();
      }
    },

    /**
     * Emits a 'blur' event
     */
    handleInputBlur: function handleInputBlur() {
      this.$emit('blur');
    },

    /**
     * Emits a 'focus' event
     */
    handleInputFocus: function handleInputFocus() {
      this.$emit('focus');
    },

    /**
     * Set the new pageDate, focus the relevant element and emit a `changed-<view>` event
     */
    handlePageChange: function handlePageChange(_ref) {
      var focusRefs = _ref.focusRefs,
          pageDate = _ref.pageDate;
      this.setPageDate(pageDate);
      this.focus.refs = focusRefs;
      this.focus.delay = this.slideDuration;
      this.reviewFocus();
      this.$emit("changed-".concat(this.nextView.up), pageDate);
    },

    /**
     * Set the date, or go to the next view down
     */
    // eslint-disable-next-line max-statements,complexity
    handleSelect: function handleSelect(cell) {
      if (this.allowedToShowView(this.nextView.down)) {
        this.showNextViewDown(cell);
        return;
      }

      this.$refs.dateInput.typedDate = '';
      this.selectDate(cell.timestamp);
      this.focus.delay = cell.isNextMonth ? this.slideDuration : 0;
      this.focus.refs = this.isInline ? ['tabbableCell'] : ['input'];
      this.close();

      if (this.showCalendarOnFocus && !this.inline) {
        this.$refs.dateInput.shouldToggleOnClick = true;
      } else {
        this.reviewFocus();
      }
    },

    /**
     * Set the date from a 'typed-date' event
     * @param {Date} date
     */
    handleTypedDate: function handleTypedDate(date) {
      if (this.selectedDate) {
        this.setTransitionAndFocusDelay(this.selectedDate, date);
      }

      this.selectDate(date ? date.valueOf() : null);
      this.reviewFocus();
    },

    /**
     * Focus the relevant element when the view changes
     * @param {String} newView
     * @param {String} oldView
     */
    handleViewChange: function handleViewChange(newView, oldView) {
      var isClosing = newView === '';
      var isOpeningInline = oldView === '' && this.isInline;

      if (isClosing || isOpeningInline) {
        return;
      }

      if (!this.isRevertingToOpenDate) {
        this.setViewChangeFocusRefs(newView, oldView);
        this.reviewFocus();
      }

      this.isRevertingToOpenDate = false;
    },

    /**
     * Returns true if element has the given className
     * @param   {HTMLElement} element
     * @param   {String}      className
     * @returns {Boolean}
     */
    hasClass: function hasClass(element, className) {
      return element && element.className.split(' ').includes(className);
    },

    /**
     * Initiate the component
     */
    init: function init() {
      if (this.value) {
        var parsedValue = this.parseValue(this.value);
        var isDateDisabled = parsedValue && this.isDateDisabled(parsedValue);

        if (isDateDisabled) {
          parsedValue = null;
          this.$emit('input', parsedValue);
        }

        this.setValue(parsedValue);
      }

      if (this.isInline) {
        this.setInitialView();
      }

      this.setSlideDuration();
    },

    /**
     * Returns true if a date is disabled
     * @param {Date} date
     */
    isDateDisabled: function isDateDisabled(date) {
      return new DisabledDate(this.utils, this.disabledDates).isDateDisabled(date);
    },

    /**
     * Returns true if we should reset the focus to computedOpenDate
     * @returns {Boolean}
     */
    isResetFocus: function isResetFocus() {
      if (!this.isOpen) {
        return false;
      }

      var isOpenCellFocused = this.hasClass(document.activeElement, 'cell') && !this.hasClass(document.activeElement, 'open');
      return !this.isMinimumView || isOpenCellFocused;
    },

    /**
     * Opens the calendar with the relevant view: 'day', 'month', or 'year'
     */
    open: function open() {
      if (this.disabled || this.isInline) {
        return;
      }

      this.setInitialView();
      this.reviewFocus();
      this.$emit('opened');
    },

    /**
     * Parse a datepicker value from string/number to date
     * @param   {Date|String|Number|null} date
     * @returns {Date}
     */
    parseValue: function parseValue(date) {
      var dateTemp = date;

      if (typeof dateTemp === 'string' || typeof dateTemp === 'number') {
        var parsed = new Date(dateTemp);
        dateTemp = Number.isNaN(parsed.valueOf()) ? null : parsed;
      }

      return dateTemp;
    },

    /**
     * Focus the open date, or close the calendar if already focused
     */
    resetOrClose: function resetOrClose() {
      if (this.isResetFocus()) {
        this.resetFocusToOpenDate();
        return;
      }

      if (this.isOpen) {
        this.focus.refs = ['input'];
        this.close();
      }
    },

    /**
     * Select the date
     * @param {Number} timestamp
     */
    selectDate: function selectDate(timestamp) {
      if (!timestamp) {
        this.selectedDate = null;
        return;
      }

      var date = new Date(timestamp);
      this.selectedDate = date;
      this.setPageDate(date);
      this.$emit('selected', date);
      this.$emit('input', date);
    },

    /**
     * Sets the initial picker page view: day, month or year
     */
    setInitialView: function setInitialView() {
      var initialView = this.computedInitialView;

      if (!this.allowedToShowView(initialView)) {
        throw new Error("initialView '".concat(this.initialView, "' cannot be rendered based on minimum '").concat(this.minimumView, "' and maximum '").concat(this.maximumView, "'"));
      }

      this.setView(initialView);
    },

    /**
     * Sets the date that the calendar should open on
     */
    setPageDate: function setPageDate(date) {
      var dateTemp = date;

      if (!dateTemp) {
        if (this.computedOpenDate) {
          dateTemp = new Date(this.computedOpenDate);
        } else {
          dateTemp = new Date();
        }

        dateTemp = this.utils.resetDateTime(dateTemp);
      }

      this.pageTimestamp = this.utils.setDate(new Date(dateTemp), 1);
    },

    /**
     * Sets the slide duration in milliseconds by looking up the stylesheet
     */
    setSlideDuration: function setSlideDuration() {
      if (!this.$refs.picker || !this.$refs.picker.$refs.cells) {
        return;
      }

      var cells = this.$refs.picker.$refs.cells.$el;
      var durationInSecs = window.getComputedStyle(cells).transitionDuration;
      this.slideDuration = parseFloat(durationInSecs) * 1000;
    },

    /**
     * Set the datepicker value
     * @param {Date|String|Number|null} date
     */
    setValue: function setValue(date) {
      if (!date) {
        this.selectedDate = null;
        this.setPageDate();
        return;
      }

      this.selectedDate = date;
      this.setPageDate(date);
    },

    /**
     * Set the picker view
     * @param {String} view
     */
    setView: function setView(view) {
      if (this.allowedToShowView(view)) {
        this.view = view;
      }
    },

    /**
     * Sets the array of `refs` that might be focused following a view change
     * @param {String} newView The view being changed to
     * @param {String} oldView The previous view
     */
    setViewChangeFocusRefs: function setViewChangeFocusRefs(newView, oldView) {
      if (oldView === '') {
        this.focus.refs = [];
        return;
      }

      var views = ['day', 'month', 'year'];

      var isNewView = function isNewView(view) {
        return view === newView;
      };

      var isOldView = function isOldView(view) {
        return view === oldView;
      };

      var newViewIndex = views.findIndex(isNewView);
      var oldViewIndex = views.findIndex(isOldView);
      var isViewChangeUp = newViewIndex - oldViewIndex > 0;
      this.focus.refs = isViewChangeUp ? ['up', 'tabbableCell'] : ['tabbableCell', 'up'];
    },

    /**
     * Set the view to the next view down e.g. from `month` to `day`
     * @param {Object} cell The currently focused cell
     */
    showNextViewDown: function showNextViewDown(cell) {
      this.setPageDate(new Date(cell.timestamp));
      this.$emit("changed-".concat(this.view), cell);
      this.setView(this.nextView.down);
    },

    /**
     * Capitalizes the first letter
     * @param {String} str The string to capitalize
     * @returns {String}
     */
    ucFirst: function ucFirst(str) {
      return str[0].toUpperCase() + str.substring(1);
    }
  }
};

/* script */
const __vue_script__ = script;
/* template */
var __vue_render__ = function () {
  var _vm = this;
  var _h = _vm.$createElement;
  var _c = _vm._self._c || _h;
  return _c(
    "div",
    {
      ref: "datepicker",
      staticClass: "vdp-datepicker",
      class: [_vm.wrapperClass, { rtl: _vm.isRtl }],
      attrs: { id: _vm.datepickerId },
      on: {
        focusin: function ($event) {
          return _vm.handleFocusIn($event)
        },
        focusout: function ($event) {
          return _vm.handleFocusOut($event)
        },
        keydown: [
          function ($event) {
            if (
              !$event.type.indexOf("key") &&
              _vm._k($event.keyCode, "esc", 27, $event.key, ["Esc", "Escape"])
            ) {
              return null
            }
            return _vm.resetOrClose($event)
          },
          function ($event) {
            if (
              !$event.type.indexOf("key") &&
              _vm._k($event.keyCode, "tab", 9, $event.key, "Tab")
            ) {
              return null
            }
            return _vm.tabThroughNavigation($event)
          },
        ],
      },
    },
    [
      _c(
        "DateInput",
        {
          ref: "dateInput",
          attrs: {
            id: _vm.id,
            autofocus: _vm.autofocus,
            "bootstrap-styling": _vm.bootstrapStyling,
            "calendar-button": _vm.calendarButton,
            "calendar-button-icon": _vm.calendarButtonIcon,
            "calendar-button-icon-content": _vm.calendarButtonIconContent,
            "clear-button": _vm.clearButton,
            "clear-button-icon": _vm.clearButtonIcon,
            disabled: _vm.disabled,
            format: _vm.format,
            inline: _vm.inline,
            "input-class": _vm.inputClass,
            "is-open": _vm.isOpen,
            maxlength: _vm.maxlength,
            name: _vm.name,
            parser: _vm.parser,
            pattern: _vm.pattern,
            placeholder: _vm.placeholder,
            "ref-name": _vm.refName,
            required: _vm.required,
            "selected-date": _vm.selectedDate,
            "show-calendar-on-button-click": _vm.showCalendarOnButtonClick,
            "show-calendar-on-focus": _vm.showCalendarOnFocus,
            tabindex: _vm.tabindex,
            translation: _vm.translation,
            typeable: _vm.typeable,
            "use-utc": _vm.useUtc,
          },
          on: {
            blur: _vm.handleInputBlur,
            "clear-date": _vm.clearDate,
            close: _vm.close,
            focus: _vm.handleInputFocus,
            open: _vm.open,
            "set-focus": function ($event) {
              return _vm.setFocus($event)
            },
            "typed-date": _vm.handleTypedDate,
          },
        },
        [
          _vm._t("beforeDateInput", null, { slot: "beforeDateInput" }),
          _vm._v(" "),
          _vm._t("afterDateInput", null, { slot: "afterDateInput" }),
          _vm._v(" "),
          _vm._t("clearBtn", null, { slot: "clearBtn" }),
          _vm._v(" "),
          _vm._t("calendarBtn", null, { slot: "calendarBtn" }),
        ],
        2
      ),
      _vm._v(" "),
      _c(
        "Popup",
        {
          ref: "popup",
          attrs: {
            "append-to-body": _vm.appendToBody,
            "fixed-position": _vm.fixedPosition,
            inline: _vm.inline,
            rtl: _vm.isRtl,
            visible: _vm.isOpen,
          },
        },
        [
          _c("Transition", { attrs: { name: "toggle" } }, [
            _c(
              "div",
              {
                directives: [
                  {
                    name: "show",
                    rawName: "v-show",
                    value: _vm.isOpen,
                    expression: "isOpen",
                  },
                ],
                staticClass: "vdp-datepicker__calendar",
                class: _vm.pickerClasses,
                attrs: { "data-test-calendar": "" },
                on: {
                  mousedown: function ($event) {
                    $event.preventDefault();
                  },
                  focusin: function ($event) {
                    $event.stopPropagation();
                    return _vm.handleFocusIn($event)
                  },
                  focusout: function ($event) {
                    $event.stopPropagation();
                    return _vm.handleFocusOut($event)
                  },
                  keydown: [
                    function ($event) {
                      if (
                        !$event.type.indexOf("key") &&
                        _vm._k($event.keyCode, "esc", 27, $event.key, [
                          "Esc",
                          "Escape",
                        ])
                      ) {
                        return null
                      }
                      $event.stopPropagation();
                      return _vm.resetOrClose($event)
                    },
                    function ($event) {
                      if (
                        !$event.type.indexOf("key") &&
                        _vm._k($event.keyCode, "tab", 9, $event.key, "Tab")
                      ) {
                        return null
                      }
                      $event.stopPropagation();
                      return _vm.tabThroughNavigation($event)
                    },
                  ],
                },
              },
              [
                _c("Transition", { attrs: { name: "view" } }, [
                  _c(
                    "div",
                    { key: _vm.view, ref: "view" },
                    [
                      _vm.$slots.beforeCalendarHeader
                        ? _c("div", [_vm._t("beforeCalendarHeader")], 2)
                        : _vm._e(),
                      _vm._v(" "),
                      _c(
                        _vm.picker,
                        {
                          ref: "picker",
                          tag: "Component",
                          staticClass: "picker-view",
                          attrs: {
                            "bootstrap-styling": _vm.bootstrapStyling,
                            "day-cell-content": _vm.dayCellContent,
                            "disabled-dates": _vm.disabledDates,
                            "first-day-of-week": _vm.firstDayOfWeek,
                            highlighted: _vm.highlighted,
                            "is-rtl": _vm.isRtl,
                            "is-typeable": _vm.typeable,
                            "is-up-disabled": _vm.isUpDisabled,
                            "is-minimum-view": _vm.isMinimumView,
                            "open-date": _vm.computedOpenDate,
                            "page-date": _vm.pageDate,
                            "selected-date": _vm.selectedDate,
                            "show-edge-dates": _vm.showEdgeDates,
                            "show-full-month-name": _vm.fullMonthName,
                            "show-header": _vm.showHeader,
                            "slide-duration": _vm.slideDuration,
                            "tabbable-cell-id": _vm.tabbableCellId,
                            "transition-name": _vm.transitionName,
                            translation: _vm.translation,
                            "use-utc": _vm.useUtc,
                            view: _vm.view || _vm.computedInitialView,
                            "year-range": _vm.yearPickerRange,
                          },
                          on: {
                            "page-change": _vm.handlePageChange,
                            select: _vm.handleSelect,
                            "set-focus": function ($event) {
                              return _vm.setFocus($event)
                            },
                            "set-transition-name": function ($event) {
                              return _vm.setTransitionName($event)
                            },
                            "set-view": _vm.setView,
                          },
                          scopedSlots: _vm._u(
                            [
                              {
                                key: "dayCellContent",
                                fn: function (ref) {
                                  var cell = ref.cell;
                                  return [
                                    cell
                                      ? _vm._t("dayCellContent", null, {
                                          cell: cell,
                                        })
                                      : _vm._e(),
                                  ]
                                },
                              },
                            ],
                            null,
                            true
                          ),
                        },
                        [
                          _vm._l(_vm.calendarSlots, function (slotKey) {
                            return [_vm._t(slotKey, null, { slot: slotKey })]
                          }),
                        ],
                        2
                      ),
                      _vm._v(" "),
                      _vm.$slots.calendarFooter
                        ? _c("div", [_vm._t("calendarFooter")], 2)
                        : _vm._e(),
                    ],
                    1
                  ),
                ]),
              ],
              1
            ),
          ]),
        ],
        1
      ),
    ],
    1
  )
};
var __vue_staticRenderFns__ = [];
__vue_render__._withStripped = true;

  /* style */
  const __vue_inject_styles__ = undefined;
  /* scoped */
  const __vue_scope_id__ = undefined;
  /* module identifier */
  const __vue_module_identifier__ = undefined;
  /* functional template */
  const __vue_is_functional_template__ = false;
  /* style inject */
  
  /* style inject SSR */
  
  /* style inject shadow dom */
  

  
  const __vue_component__ = /*#__PURE__*/normalizeComponent(
    { render: __vue_render__, staticRenderFns: __vue_staticRenderFns__ },
    __vue_inject_styles__,
    __vue_script__,
    __vue_scope_id__,
    __vue_is_functional_template__,
    __vue_module_identifier__,
    false,
    undefined,
    undefined,
    undefined
  );

module.exports = __vue_component__;
//# sourceMappingURL=Datepicker.common.js.map
