import moment from 'moment';

export default {
    methods: {
        getTimeFromDate(date) {
            return moment(date).format("H:mm")
        },
        getFormattedDate(date) {
            return moment(date).format("DD.MM.YY H:mm")
            // return moment(date).format("DD/MM/YY H:mm")
        },
        getDotFormattedDate(date) {
            return moment(date).format("h:mm a DD/MM/YY ")
        },
        getDotFormattedOnlyDate(date) {
            return moment(date).format("DD.MM.YY")
        },
        getFormattedDetailedDateTime(date) {
            return moment(date).format("dddd, MMMM Do YYYY, h:mm:ss a")
        },
        getFormattedDateOnly(date) {
            return moment(date).format("YYYY-MM-DD")
        },
        getFormattedCurrentDate() {
            return moment().format("YYYY-MM-DD")
        },
        compareDates(date) {
            let date1 = moment();
            let date2 = moment(date);

            return date1.diff(date2, "hours");
        },
        dateCheck(date) {
            // return moment('2010/12/20').isAfter('2010/10/32', 'month');
            if (date) return moment(this.getFormattedDateOnly(date)).isAfter(this.getFormattedCurrentDate())
        },
        getFormattedTime(date) {
            return moment(date).format("hh:mm  a")
        },

    },
}
