@extends('new_admin.layouts.app')

@section('content')
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Appointment Types</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active"> <a href='#'>Appointment Types </a></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->


    <section class="content">
        <div class="container-fluid">
            <!-- Small boxes (Stat box) -->
            <div class="row">

                <div class="col-md-12">
                    <!-- Appointment Type form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">Appointment Types</h3>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form action="{{ route('admin.appointment_types.update') }}" enctype="multipart/form-data"
                            method="post">
                            @csrf
                            <div class="card-body">
                                @foreach ($appointment_types as $key => $appointment_type)
                                    <label>{{ $appointment_type->display_name }}:</label>
                                    <div class="row">
                                        <div class="col-md-6 form-group">
                                            <label>Display Name</label>
                                            <input class="form-control" type="text"
                                                name="display_name[{{ $appointment_type->name }}]"
                                                value="{{ $appointment_type->display_name }}">
                                        </div>
                                        @if (isset($appointment_type->is_active))
                                            <div class=" col-md-6 form-group">
                                                <label>Active</label>
                                                <select class="form-control "
                                                    name="is_active[{{ $appointment_type->name }}]">
                                                    <option {{ $appointment_type->is_active ? 'selected' : '' }}
                                                        value="1">Yes</option>
                                                    <option {{ !$appointment_type->is_active ? 'selected' : '' }}
                                                        value="0">No</option>
                                                </select>
                                            </div>
                                        @endif
                                    </div>
                                @endforeach
                                <div class="col-md-6 pl-0 pt-3">
                                    <button class="btn btn-primary" type="submit">
                                        Update
                                    </button>
                                </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>

            </div>
        </div>
    </section>
@endsection
