@extends('new_admin.layouts.app')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">Edit Blog Category</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active"><a href="{{route('admin.blog.category.list')}}"> Blog Category List</a></li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->


  <section class="content">
    <div class="container-fluid">
      <!-- Small boxes (Stat box) -->
      <div class="row">

            <div class="col-md-12">
                <!-- general form elements -->
                <div class="card card-secondary">
                  <div class="card-header">
                    <h3 class="card-title">Edit Blog Category</h3>
                  </div>
                  <!-- /.card-header -->
                  <!-- form start -->
                  <form action="{{route('admin.blog.category.update')}}" enctype="multipart/form-data"   method="post">
                    @csrf
                    <div class="card-body">
                        <input type="hidden" name="id" value="{{$detail->id}}">
                      <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" required name="name" value="{{$detail->name}}" placeholder="Enter Category Name">
                      </div>
                      <div class="form-group">
                        <label>Category Image</label> <br>
                        @if ($detail->image_path)
                            <img src="{{asset($detail->image_path)}}" height="100" width="200" alt=""><br><br>
                        @endif
                        <input type="file"  onchange="openFile(this)" class="form-control h-100" name="image" placeholder="International Phone Number">
                      </div>
                      <div class="image_preview">

                    </div>
                      <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control rounded-0" name="description" id="" cols="30" rows="10">{{$detail->description}}</textarea>
                      </div>


                    <!-- /.card-body -->

                    <div class="col-md-6 pl-0">
                      <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                  </form>
                </div>
                <!-- /.card -->



              </div>

      </div>
    </div>
  </section>
@endsection
