@extends('new_admin.layouts.app')

@section('content')
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Custom CSS/Javascript</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active"> <a href='#'>Custom CSS/Javascript </a></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <section class="content">
        <div class="container-fluid">
            <!-- Small boxes (Stat box) -->
            <div class="row">

                <div class="col-md-12">
                    <!-- Custom CSS/Javascript form elements -->
                    <div class="card card-secondary">
                        <div class="card-header">
                            <h3 class="card-title">Custom CSS/Javascript</h3>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form action="{{ route('admin.custom_scripts.update') }}" method="post">
                            @csrf
                            <div class="card-body">
                                <div class="form-group">
                                    <label>CSS Code Editor</label>
                                    <textarea id="code-editor-css" name="custom_css" class="form-control">{{$custom_scripts->custom_css}}</textarea>

                                </div>
                                <div class="form-group">
                                    <label>Javascript Code Editor</label>
                                    <textarea id="code-editor-js" name="custom_js" class="form-control">{{$custom_scripts->custom_js}}</textarea>

                                </div>
                                <div class="col-md-6 pl-0 pt-3">
                                    <button class="btn btn-primary" type="submit">
                                        Update
                                    </button>
                                </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>

            </div>
        </div>
    </section>
@endsection
@section('footer_script')
    <script>
        // Initialize CodeMirror on the textarea
        var css_editor = CodeMirror.fromTextArea(document.getElementById('code-editor-css'), {
            lineNumbers: true, // Show line numbers.
            matchBrackets: true, // Enable bracket matching
            theme: 'dracula',
            mode: 'css',
            fontSize: 16, // Change font size to 16 pixels
            indentUnit: 4, // Change indentation to 4 spaces
            tabSize: 4, // Change tab size to 4 spaces
        });
        var js_editor = CodeMirror.fromTextArea(document.getElementById('code-editor-js'), {
            lineNumbers: true, // Show line numbers.
            matchBrackets: true, // Enable bracket matching
            theme: 'dracula',
            mode: 'javascript',
            fontSize: 16, // Change font size to 16 pixels
            indentUnit: 4, // Change indentation to 4 spaces
            tabSize: 4, // Change tab size to 4 spaces
        });
    </script>
@endsection
