@extends('new_admin.layouts.app')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">Edit User Role </h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active"> <a href="{{route('admin.user.role.list')}}"> User Role List</a></li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <!-- /.content-header -->


  <section class="content">
    <div class="container-fluid">
      <!-- Small boxes (Stat box) -->
      <div class="row">

            <div class="col-md-12">
                <!-- general form elements -->
                <div class="card card-secondary">
                  <div class="card-header">
                    <h3 class="card-title">Edit User Role</h3>
                  </div>
                  <!-- /.card-header -->
                  <!-- form start -->
                  <form action="{{route('admin.user.role.update')}}"  method="post">
                    @csrf
                    <input type="hidden" name="id" value="{{$userrole->id}}"/>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="exampleInputEmail1">Name</label>
                            <select class="form-control " name="user" >
                                <option class="form-control " value="0">Select User</option>
                                @foreach($users as $user)
                                <option class="form-control"
                                @if($userrole->user_id==$user->id)
                                {{"selected"}}
                                @endif
                                value="{{$user->id}}">{{$user->first_name}} {{$user->last_name}}</option>
                                @endforeach
                            </select> </div>
                          <div class="form-group">
                            <label for="exampleInputEmail1">Role </label>
                            <select class="form-control " name="role" >
                                <option class="form-control " value="0">Select Role</option>
                                @foreach($roles as $role)
                                <option class="form-control"

                                @if($userrole->role_id==$role->id)
                                {{"selected"}}
                                @endif
                                value="{{$role->id}}">{{$role->name}}</option>
                                @endforeach
                            </select></div>


                    <!-- /.card-body -->

                    <div class="col-md-6 pl-0">
                      <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                  </form>
                </div>
                <!-- /.card -->



              </div>

      </div>
    </div>
  </section>
@endsection
